/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import java.util.List;
import java.util.Objects;

public final class StandardFunctionResolution {
    private final Session session;
    private final Metadata metadata;

    public StandardFunctionResolution(Session session, Metadata metadata) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public ResolvedFunction arithmeticFunction(ArithmeticBinaryExpression.Operator operator, Type leftType, Type rightType) {
        return this.metadata.resolveOperator(switch (operator) {
            case ArithmeticBinaryExpression.Operator.ADD -> OperatorType.ADD;
            case ArithmeticBinaryExpression.Operator.SUBTRACT -> OperatorType.SUBTRACT;
            case ArithmeticBinaryExpression.Operator.MULTIPLY -> OperatorType.MULTIPLY;
            case ArithmeticBinaryExpression.Operator.DIVIDE -> OperatorType.DIVIDE;
            case ArithmeticBinaryExpression.Operator.MODULUS -> OperatorType.MODULUS;
            default -> throw new IllegalStateException("Unknown arithmetic operator: " + operator);
        }, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
    }

    public ResolvedFunction comparisonFunction(ComparisonExpression.Operator operator, Type leftType, Type rightType) {
        return this.metadata.resolveOperator(switch (operator) {
            case ComparisonExpression.Operator.EQUAL -> OperatorType.EQUAL;
            case ComparisonExpression.Operator.LESS_THAN -> OperatorType.LESS_THAN;
            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> OperatorType.LESS_THAN_OR_EQUAL;
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> OperatorType.IS_DISTINCT_FROM;
            default -> throw new IllegalStateException("Unsupported comparison operator type: " + operator);
        }, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
    }
}

