/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type.setdigest;

import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.type.setdigest.SetDigest;

public final class SetDigestFunctions {
    private SetDigestFunctions() {
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="SetDigest") Slice digest) {
        return SetDigest.newInstance(digest).cardinality();
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long intersectionCardinality(@SqlType(value="SetDigest") Slice slice1, @SqlType(value="SetDigest") Slice slice2) {
        SetDigest digest1 = SetDigest.newInstance(slice1);
        SetDigest digest2 = SetDigest.newInstance(slice2);
        if (digest1.isExact() && digest2.isExact()) {
            return SetDigest.exactIntersectionCardinality(digest1, digest2);
        }
        long cardinality1 = digest1.cardinality();
        long cardinality2 = digest2.cardinality();
        double jaccard = SetDigest.jaccardIndex(digest1, digest2);
        digest1.mergeWith(digest2);
        long result = Math.round(jaccard * (double)digest1.cardinality());
        return Math.min(result, Math.min(cardinality1, cardinality2));
    }

    @ScalarFunction
    @SqlType(value="double")
    public static double jaccardIndex(@SqlType(value="SetDigest") Slice slice1, @SqlType(value="SetDigest") Slice slice2) {
        SetDigest digest1 = SetDigest.newInstance(slice1);
        SetDigest digest2 = SetDigest.newInstance(slice2);
        return SetDigest.jaccardIndex(digest1, digest2);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,smallint)")
    public static Block hashCounts(@TypeParameter(value="map(bigint,smallint)") Type mapType, @SqlType(value="SetDigest") Slice slice) {
        SetDigest digest = SetDigest.newInstance(slice);
        return MapValueBuilder.buildMapValue((MapType)((MapType)mapType), (int)digest.getHashCounts().size(), (keyBuilder, valueBuilder) -> digest.getHashCounts().forEach((key, value) -> {
            BigintType.BIGINT.writeLong(keyBuilder, key.longValue());
            SmallintType.SMALLINT.writeLong(valueBuilder, (long)value.shortValue());
        }));
    }
}

