/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.trino.block.AbstractTestBlock;
import io.trino.block.BlockAssertions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestDictionaryBlock
extends AbstractTestBlock {
    @Test
    public void testConstructionNoPositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Block dictionary = BlockAssertions.createSlicesBlock(expectedValues);
        Block block = DictionaryBlock.create((int)0, (Block)dictionary, (int[])new int[]{1, 5, 9});
        Assertions.assertThat((Object)block).isInstanceOf(VariableWidthBlock.class);
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(0);
    }

    @Test
    public void testConstructionOnePositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Block dictionary = BlockAssertions.createSlicesBlock(expectedValues);
        Block block = DictionaryBlock.create((int)1, (Block)dictionary, (int[])new int[]{1, 5, 9});
        Assertions.assertThat((Object)block).isInstanceOf(VariableWidthBlock.class);
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(1);
        Assertions.assertThat((Comparable)block.getSlice(0, 0, block.getSliceLength(0))).isEqualTo((Object)expectedValues[1]);
    }

    @Test
    public void testConstructionUnnestDictionary() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Block innerDictionary = BlockAssertions.createSlicesBlock(expectedValues);
        DictionaryBlock dictionary = (DictionaryBlock)DictionaryBlock.create((int)4, (Block)innerDictionary, (int[])new int[]{1, 3, 5, 7});
        Block block = DictionaryBlock.create((int)2, (Block)dictionary, (int[])new int[]{1, 3});
        Assertions.assertThat((Object)block).isInstanceOf(DictionaryBlock.class);
        this.assertBlock(block, new Slice[]{expectedValues[3], expectedValues[7]});
        Block actualDictionary = ((DictionaryBlock)block).getDictionary();
        Assertions.assertThat((Object)actualDictionary).isSameAs((Object)innerDictionary);
    }

    @Test
    public void testSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assert.assertEquals((long)dictionaryBlock.getSizeInBytes(), (long)(dictionaryBlock.getDictionary().getSizeInBytes() + 400L));
    }

    @Test
    public void testLogicalSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assert.assertEquals((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes(), (long)95L);
        Assert.assertEquals((long)dictionaryBlock.getLogicalSizeInBytes(), (long)950L);
        dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(TestDictionaryBlock.alternatingNullValues(expectedValues), 210);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)21);
        Assert.assertEquals((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes(), (long)150L);
        Assert.assertEquals((long)dictionaryBlock.getLogicalSizeInBytes(), (long)1500L);
    }

    @Test
    public void testCopyRegionCreatesCompactBlock() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        DictionaryBlock copyRegionDictionaryBlock = (DictionaryBlock)dictionaryBlock.copyRegion(1, 3);
        Assert.assertTrue((boolean)copyRegionDictionaryBlock.isCompact());
    }

    @Test
    public void testCopyPositionsWithCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Slice firstExpectedValue = expectedValues[0];
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 10, 20, 30, 40};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)1);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), new Slice[]{firstExpectedValue});
        this.assertBlock((Block)copiedBlock, new Slice[]{firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue});
    }

    @Test
    public void testCopyPositionsWithCompactionsAndReorder() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{50, 55, 40, 45, 60};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)2);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), new Slice[]{expectedValues[0], expectedValues[5]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 1, 0, 1, 0);
    }

    @Test
    public void testCopyPositionsSamePosition() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{52, 52, 52};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)1);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), new Slice[]{expectedValues[2]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 0, 0);
    }

    @Test
    public void testCopyPositionsNoCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(1);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 2, 4, 5};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), expectedValues);
    }

    @Test
    public void testCompact() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlockWithUnreferencedKeys(expectedValues, 10);
        Assert.assertEquals((boolean)dictionaryBlock.isCompact(), (boolean)false);
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assert.assertNotEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)compactBlock.getDictionarySourceId());
        Assert.assertEquals((int)compactBlock.getDictionary().getPositionCount(), (int)(expectedValues.length / 2 + 1));
        this.assertBlock(compactBlock.getDictionary(), new Slice[]{expectedValues[0], expectedValues[1], expectedValues[3]});
        TestDictionaryBlock.assertDictionaryIds(compactBlock, 0, 1, 1, 2, 2, 0, 1, 1, 2, 2);
        Assert.assertEquals((boolean)compactBlock.isCompact(), (boolean)true);
        DictionaryBlock reCompactedBlock = compactBlock.compact();
        Assert.assertEquals((Object)reCompactedBlock.getDictionarySourceId(), (Object)compactBlock.getDictionarySourceId());
    }

    @Test
    public void testCompactAllKeysReferenced() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 10);
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assert.assertEquals((Object)compactBlock.getDictionary(), (Object)dictionaryBlock.getDictionary());
        Assert.assertEquals((int)compactBlock.getPositionCount(), (int)dictionaryBlock.getPositionCount());
        for (int position = 0; position < compactBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)compactBlock.getId(position), (int)dictionaryBlock.getId(position));
        }
        Assert.assertEquals((boolean)compactBlock.isCompact(), (boolean)true);
    }

    @Test
    public void testBasicGetPositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Block dictionaryBlock = DictionaryBlock.create((int)6, (Block)BlockAssertions.createSlicesBlock(expectedValues), (int[])new int[]{0, 1, 2, 3, 4, 5});
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[0], expectedValues[1], expectedValues[2], expectedValues[3], expectedValues[4], expectedValues[5]});
        DictionaryId dictionaryId = ((DictionaryBlock)dictionaryBlock).getDictionarySourceId();
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 8, 1, 2, 4, 5, 7, 9}, 2, 4);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[4], expectedValues[5]});
        Assert.assertEquals((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 1, 3, 0, 0}, 0, 3);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assert.assertEquals((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{-1, -1, 0, 1, 2}, 2, 3);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assert.assertEquals((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 2, 2}, 0, 3);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[5], expectedValues[5]});
        Assert.assertEquals((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{1, 1, 1, 1, 1}, 0, 5);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5]});
        Assert.assertEquals((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId(), (Object)dictionaryId);
        Block finalDictionaryBlock = dictionaryBlock;
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int position = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalDictionaryBlock.getPositions(new int[]{position}, 0, 1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{position, finalDictionaryBlock.getPositionCount()});
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int offset = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalDictionaryBlock.getPositions(new int[]{0}, offset, 1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessage("Invalid offset %d and length 1 in array with 1 elements", new Object[]{offset});
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalDictionaryBlock.getPositions(new int[]{0}, 0, length)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessage("Invalid offset 0 and length %d in array with 1 elements", new Object[]{length});
        }
    }

    @Test
    public void testCompactGetPositions() {
        DictionaryBlock block = (DictionaryBlock)DictionaryBlock.create((int)6, (Block)BlockAssertions.createSlicesBlock(TestDictionaryBlock.createExpectedValues(10)), (int[])new int[]{0, 1, 2, 3, 4, 5});
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{3, 3, 4, 5, 2, 0, 1, 1}, 0, 7);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 2, 3, 4, 5, 6, 6, 5, 4, 3, 2, 1}, 0, 12);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{0, 2, 0, 2, 0}, 0, 5);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 1, 1}, 0, 4);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{1, 1, 1, 1}, 0, 4);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0}, 0, 1);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assert.assertTrue((boolean)block.isCompact());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        int positionCount = 10;
        int dictionaryPositionCount = 100;
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(positionCount);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, dictionaryPositionCount);
        for (int position = 0; position < dictionaryPositionCount; ++position) {
            Assert.assertEquals((long)dictionaryBlock.getEstimatedDataSizeForStats(position), (long)expectedValues[position % positionCount].length());
        }
    }

    @Test
    public void testDictionarySizes() {
        TestDictionaryBlock.assertDictionarySizeMethods((Block)new IntArrayBlock(100, Optional.empty(), IntStream.range(0, 100).toArray()));
        TestDictionaryBlock.assertDictionarySizeMethods(BlockAssertions.createSlicesBlock(TestDictionaryBlock.createExpectedValues(100)));
    }

    private static void assertDictionarySizeMethods(Block block) {
        Assertions.assertThat((Object)block).isNotInstanceOf(DictionaryBlock.class);
        int positions = block.getPositionCount();
        Assertions.assertThat((positions > 0 ? 1 : 0) != 0).isTrue();
        int[] allIds = IntStream.range(0, positions).toArray();
        Assert.assertEquals((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getSizeInBytes(), (long)(block.getSizeInBytes() + 4L * (long)positions));
        int firstHalfLength = positions / 2;
        int secondHalfLength = positions - firstHalfLength;
        int[] firstHalfIds = IntStream.range(0, firstHalfLength).toArray();
        int[] secondHalfIds = IntStream.range(firstHalfLength, positions).toArray();
        boolean[] selectedPositions = new boolean[positions];
        selectedPositions[0] = true;
        Assert.assertEquals((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getPositionsSizeInBytes(selectedPositions, 1), (long)(block.getPositionsSizeInBytes(selectedPositions, 1) + 4L));
        Arrays.fill(selectedPositions, true);
        Assert.assertEquals((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getPositionsSizeInBytes(selectedPositions, positions), (long)(block.getSizeInBytes() + 4L * (long)positions));
        Assert.assertEquals((long)DictionaryBlock.create((int)firstHalfIds.length, (Block)block, (int[])firstHalfIds).getSizeInBytes(), (long)(block.getRegionSizeInBytes(0, firstHalfLength) + 4L * (long)firstHalfLength));
        Assert.assertEquals((long)DictionaryBlock.create((int)secondHalfIds.length, (Block)block, (int[])secondHalfIds).getSizeInBytes(), (long)(block.getRegionSizeInBytes(firstHalfLength, secondHalfLength) + 4L * (long)secondHalfLength));
        Assert.assertEquals((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getRegionSizeInBytes(0, firstHalfLength), (long)(block.getRegionSizeInBytes(0, firstHalfLength) + 4L * (long)firstHalfLength));
        Assert.assertEquals((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getRegionSizeInBytes(firstHalfLength, secondHalfLength), (long)(block.getRegionSizeInBytes(firstHalfLength, secondHalfLength) + 4L * (long)secondHalfLength));
    }

    private static DictionaryBlock createDictionaryBlockWithUnreferencedKeys(Slice[] expectedValues, int positionCount) {
        Preconditions.checkArgument((positionCount >= 2 ? 1 : 0) != 0, (Object)"positionCount must be at least 2 for a dictionary block");
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int index = i % dictionarySize;
            if (index % 2 != 0 || index != 0) {
                // empty if block
            }
            ids[i] = --index;
        }
        return (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)BlockAssertions.createSlicesBlock(expectedValues), (int[])ids);
    }

    private static DictionaryBlock createDictionaryBlock(Slice[] expectedValues, int positionCount) {
        Preconditions.checkArgument((positionCount >= 2 ? 1 : 0) != 0, (Object)"positionCount must be at least 2 for a dictionary block");
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)BlockAssertions.createSlicesBlock(expectedValues), (int[])ids);
    }

    private static BlockBuilder createBlockBuilder() {
        return new VariableWidthBlockBuilder(null, 100, 1);
    }

    private static void assertDictionaryIds(DictionaryBlock dictionaryBlock, int ... expected) {
        Assert.assertEquals((int)dictionaryBlock.getPositionCount(), (int)expected.length);
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)dictionaryBlock.getId(position), (int)expected[position]);
        }
    }
}

