/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.IntArrayBlockBuilder;
import java.util.Optional;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestIntArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestIntArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestIntArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestIntArrayBlock.alternatingNullValues(TestIntArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestIntArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestIntArrayBlock.createTestValue(100);
        IntArrayBlockBuilder emptyBlockBuilder = new IntArrayBlockBuilder(null, 0);
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, expectedValues.length);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestIntArrayBlock.writeValues(expectedValues, blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = (IntArrayBlockBuilder)blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestIntArrayBlock.createTestValue(100);
        TestIntArrayBlock.assertEstimatedDataSizeForStats(TestIntArrayBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        int[] intArray = new int[]{0, 0, 1, 2, 3, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestIntArrayBlock.testCompactBlock((Block)new IntArrayBlock(0, Optional.empty(), new int[0]));
        TestIntArrayBlock.testCompactBlock((Block)new IntArrayBlock(intArray.length, Optional.of(valueIsNull), intArray));
        TestIntArrayBlock.testIncompactBlock((Block)new IntArrayBlock(intArray.length - 1, Optional.of(valueIsNull), intArray));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        Block block = TestIntArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, expectedValues.length);
        TestIntArrayBlock.writeValues(expectedValues, blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, IntArrayBlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeInt(expectedValue.getInt(0));
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestIntArrayBlock.createExpectedValue(4);
        }
        return expectedValues;
    }

    @Override
    protected boolean isByteAccessSupported() {
        return false;
    }

    @Override
    protected boolean isShortAccessSupported() {
        return false;
    }

    @Override
    protected boolean isLongAccessSupported() {
        return false;
    }

    @Override
    protected boolean isSliceAccessSupported() {
        return false;
    }
}

