/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.StatsCalculatorAssertion;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import java.util.Map;
import java.util.function.Function;

public class StatsCalculatorTester
implements AutoCloseable {
    private final LocalQueryRunner queryRunner;

    public StatsCalculatorTester() {
        this(TestingSession.testSessionBuilder().build());
    }

    public StatsCalculatorTester(Session session) {
        this(StatsCalculatorTester.createQueryRunner(session));
    }

    private StatsCalculatorTester(LocalQueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    private static LocalQueryRunner createQueryRunner(Session session) {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)session);
        queryRunner.createCatalog((String)session.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    public StatsCalculatorAssertion assertStatsFor(Function<PlanBuilder, PlanNode> planProvider) {
        return this.assertStatsFor(this.queryRunner.getDefaultSession(), planProvider);
    }

    public StatsCalculatorAssertion assertStatsFor(Session session, Function<PlanBuilder, PlanNode> planProvider) {
        session = TestingSession.testSession((Session)session);
        TransactionId transactionId = this.queryRunner.getTransactionManager().beginTransaction(IsolationLevel.READ_UNCOMMITTED, false, false);
        Session transactionSession = session.beginTransactionId(transactionId, this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl());
        this.queryRunner.getMetadata().beginQuery(transactionSession);
        try {
            PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.queryRunner.getPlannerContext(), transactionSession);
            PlanNode planNode = planProvider.apply(planBuilder);
            return new StatsCalculatorAssertion((QueryRunner)this.queryRunner, transactionSession, planNode, planBuilder.getTypes());
        }
        catch (Throwable t) {
            this.queryRunner.getTransactionManager().asyncAbort(transactionId);
            throw t;
        }
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }
}

