/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CallTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogProcedures;
import io.trino.metadata.Metadata;
import io.trino.metadata.ProcedureRegistry;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.security.DenyAllAccessControl;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.AccessDeniedException;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionManager;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestCallTask {
    private static final MethodHandle PROCEDURE_METHOD_HANDLE = Reflection.methodHandle(TestingProcedure.class, (String)"testingMethod", (Class[])new Class[]{Target.class, ConnectorAccessControl.class});
    private ExecutorService executor;
    private LocalQueryRunner queryRunner;

    @BeforeAll
    public void init() {
        this.queryRunner = LocalQueryRunner.builder((Session)SessionTestUtils.TEST_SESSION).build();
        this.queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"call-task-test-%s"));
    }

    @AfterAll
    public void close() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testExecute() {
        Target target = new Target();
        this.executeCallTask(PROCEDURE_METHOD_HANDLE.bindTo(target), transactionManager -> new AllowAllAccessControl());
        Assertions.assertThat((boolean)target.invoked).isTrue();
    }

    @Test
    public void testExecuteNoPermission() {
        Target target = new Target();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(PROCEDURE_METHOD_HANDLE.bindTo(target), transactionManager -> new DenyAllAccessControl())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute procedure test-catalog.test.testing_procedure");
        Assertions.assertThat((boolean)target.invoked).isFalse();
    }

    @Test
    public void testExecuteNoPermissionOnInsert() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(PROCEDURE_METHOD_HANDLE.bindTo(new Target()), transactionManager -> {
            TestingAccessControlManager accessControl = new TestingAccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager());
            accessControl.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
            accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"testing_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
            return accessControl;
        })).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table test-catalog.test.testing_table");
    }

    private void executeCallTask(MethodHandle methodHandle, Function<TransactionManager, AccessControl> accessControlProvider) {
        TransactionManager transactionManager = this.queryRunner.getTransactionManager();
        ProcedureRegistry procedureRegistry = new ProcedureRegistry(CatalogServiceProvider.singleton((CatalogHandle)this.queryRunner.getCatalogHandle("test-catalog"), (Object)new CatalogProcedures((Collection)ImmutableList.of((Object)new Procedure("test", "testing_procedure", (List)ImmutableList.of(), methodHandle)))));
        AccessControl accessControl = accessControlProvider.apply(transactionManager);
        PlannerContext plannerContext = TestingPlannerContext.plannerContextBuilder().withTransactionManager(transactionManager).build();
        new CallTask(transactionManager, plannerContext, accessControl, procedureRegistry).execute(new Call(QualifiedName.of((String)"testing_procedure"), (List)ImmutableList.of()), this.stateMachine(transactionManager, plannerContext.getMetadata(), accessControl), (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, Metadata metadata, AccessControl accessControl) {
        return QueryStateMachine.begin(Optional.empty(), (String)"CALL testing_procedure()", Optional.empty(), (Session)TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema("test").build(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
    }

    private static class Target {
        public boolean invoked;

        private Target() {
        }
    }

    public static class TestingProcedure {
        public static void testingMethod(Target target, ConnectorAccessControl connectorAccessControl) {
            target.invoked = true;
            connectorAccessControl.checkCanInsertIntoTable(null, new SchemaTableName("test", "testing_table"));
        }
    }
}

