/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.DropColumnTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDropColumnTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testDropColumn() {
        QualifiedObjectName tableName = TestDropColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropColumnTask.simpleTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"b"), false, false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testDropOnlyColumn() {
        QualifiedObjectName tableName = TestDropColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT)});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"test"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Cannot drop the only column in a table");
    }

    @Test
    public void testDropColumnNotExistingTable() {
        QualifiedObjectName tableName = TestDropColumnTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"test"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testDropColumnNotExistingTableIfExists() {
        QualifiedName tableName = TestDropColumnTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeDropColumn(tableName, QualifiedName.of((String)"test"), true, false));
    }

    @Test
    public void testDropMissingColumn() {
        QualifiedObjectName tableName = TestDropColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropColumnTask.simpleTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"missing_column"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column 'missing_column' does not exist");
    }

    @Test
    public void testDropColumnIfExists() {
        QualifiedObjectName tableName = TestDropColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropColumnTask.simpleTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"c"), false, true));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testUnsupportedDropDuplicatedField() {
        QualifiedObjectName tableName = TestDropColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT), new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT), new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)}))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a"}), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Field path [a] within row(a bigint, a bigint) is ambiguous");
    }

    @Test
    public void testUnsupportedDropOnlyField() {
        QualifiedObjectName tableName = TestDropColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)}))});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a"}), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Cannot drop the only field in a row type");
    }

    @Test
    public void testDropColumnOnView() {
        QualifiedObjectName viewName = TestDropColumnTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestDropColumnTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(viewName), QualifiedName.of((String)"test"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testDropColumnOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestDropColumnTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropColumn(TestDropColumnTask.asQualifiedName(materializedViewName), QualifiedName.of((String)"test"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{materializedViewName});
    }

    private ListenableFuture<Void> executeDropColumn(QualifiedName table, QualifiedName column, boolean tableExists, boolean columnExists) {
        return new DropColumnTask(this.plannerContext.getMetadata(), (AccessControl)new AllowAllAccessControl()).execute(new DropColumn(table, column, tableExists, columnExists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private static ConnectorTableMetadata simpleTable(QualifiedObjectName tableName) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT)));
    }

    private static ConnectorTableMetadata rowTable(QualifiedObjectName tableName, RowType.Field ... fields) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])fields))));
    }
}

