/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.RenameColumnTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.QueryUtil;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.RenameColumn;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRenameColumnTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testRenameColumn() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a_renamed", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testRenameColumnNotExistingTable() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testRenameColumnNotExistingTableIfExists() {
        QualifiedName tableName = TestRenameColumnTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeRenameColumn(tableName, QualifiedName.of((String)"a"), QueryUtil.identifier((String)"a_renamed"), true, false));
    }

    @Test
    public void testRenameMissingColumn() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"missing_column"), QueryUtil.identifier((String)"test"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column 'missing_column' does not exist");
    }

    @Test
    public void testRenameColumnIfExists() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"missing_column"), QueryUtil.identifier((String)"test"), false, true));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testRenameColumnOnView() {
        QualifiedObjectName viewName = TestRenameColumnTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestRenameColumnTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(viewName), QualifiedName.of((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testRenameColumnOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestRenameColumnTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(materializedViewName), QualifiedName.of((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{materializedViewName});
    }

    @Test
    public void testRenameFieldNotExistingTable() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"test"), QueryUtil.identifier((String)"x"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testRenameFieldNotExistingTableIfExists() {
        QualifiedName tableName = TestRenameColumnTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeRenameColumn(tableName, QualifiedName.of((String)"test"), QueryUtil.identifier((String)"x"), true, false));
    }

    @Test
    public void testRenameMissingField() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"missing_column"), QueryUtil.identifier((String)"x"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column 'missing_column' does not exist");
    }

    @Test
    public void testRenameFieldIfExists() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"c"), QueryUtil.identifier((String)"x"), false, true));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testUnsupportedRenameDuplicatedField() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT), new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT), new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)}))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a"}), QueryUtil.identifier((String)"x"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessageContaining("Field path [col, a] within row(a bigint, a bigint) is ambiguous");
    }

    @Test
    public void testUnsupportedRenameToExistingField() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT), new RowType.Field(Optional.of("b"), (Type)BigintType.BIGINT)), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT), new RowType.Field(Optional.of("b"), (Type)BigintType.BIGINT)}))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a"}), QueryUtil.identifier((String)"b"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_ALREADY_EXISTS}).hasMessageContaining("Field 'b' already exists");
    }

    @Test
    public void testRenameFieldOnView() {
        QualifiedObjectName viewName = TestRenameColumnTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestRenameColumnTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(viewName), QualifiedName.of((String)"test"), QueryUtil.identifier((String)"x"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testRenameFieldOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestRenameColumnTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(materializedViewName), QualifiedName.of((String)"test"), QueryUtil.identifier((String)"x"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{materializedViewName});
    }

    private ListenableFuture<Void> executeRenameColumn(QualifiedName table, QualifiedName source, Identifier target, boolean tableExists, boolean columnExists) {
        return new RenameColumnTask(this.plannerContext.getMetadata(), (AccessControl)new AllowAllAccessControl()).execute(new RenameColumn(new NodeLocation(1, 1), table, source, target, tableExists, columnExists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private static ConnectorTableMetadata simpleTable(QualifiedObjectName tableName) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT)));
    }

    private static ConnectorTableMetadata rowTable(QualifiedObjectName tableName, RowType.Field ... fields) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])fields))));
    }
}

