/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import io.trino.execution.scheduler.ResettableRandomizedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestResettableRandomizedIterator {
    @Test
    public void testResetting() {
        ImmutableSet expected = new HashSet();
        for (int i = 0; i < 100; ++i) {
            expected.add(i);
        }
        expected = ImmutableSet.copyOf(expected);
        ResettableRandomizedIterator randomizedIterator = new ResettableRandomizedIterator((Collection)expected);
        HashSet<Integer> actual = new HashSet<Integer>();
        while (randomizedIterator.hasNext()) {
            actual.add((Integer)randomizedIterator.next());
        }
        Assert.assertEquals(actual, (Set)expected);
        actual.clear();
        randomizedIterator.reset();
        while (randomizedIterator.hasNext()) {
            actual.add((Integer)randomizedIterator.next());
        }
        Assert.assertEquals(actual, (Set)expected);
    }

    @Test
    public void testRandom() {
        int i;
        ImmutableSet values = new HashSet();
        for (int i2 = 0; i2 < 100; ++i2) {
            values.add(i2);
        }
        values = ImmutableSet.copyOf(values);
        ResettableRandomizedIterator randomizedIterator = new ResettableRandomizedIterator((Collection)values);
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        randomizedIterator.reset();
        for (i = 0; i < 99; ++i) {
            list1.add((Integer)randomizedIterator.next());
        }
        randomizedIterator.reset();
        for (i = 0; i < 99; ++i) {
            list2.add((Integer)randomizedIterator.next());
        }
        Assert.assertNotEquals(list1, list2);
    }
}

