/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.BroadcastOutputBuffer;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.BufferTestUtils;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferMemoryManager;
import io.trino.execution.buffer.OutputBufferStateMachine;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.MemoryReservationHandler;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.type.BigintType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestBroadcastOutputBuffer {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private static final ImmutableList<BigintType> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final PipelinedOutputBuffers.OutputBufferId FIRST = new PipelinedOutputBuffers.OutputBufferId(0);
    private static final PipelinedOutputBuffers.OutputBufferId SECOND = new PipelinedOutputBuffers.OutputBufferId(1);
    private static final PipelinedOutputBuffers.OutputBufferId THIRD = new PipelinedOutputBuffers.OutputBufferId(2);
    private ScheduledExecutorService stateNotificationExecutor;

    @BeforeAll
    public void setUp() {
        this.stateNotificationExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    @AfterAll
    public void tearDown() {
        if (this.stateNotificationExecutor != null) {
            this.stateNotificationExecutor.shutdownNow();
            this.stateNotificationExecutor = null;
        }
    }

    @Test
    public void testInvalidConstructorArg() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxBufferedBytes must be > 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxBufferedBytes must be > 0");
    }

    @Test
    public void testSimple() {
        int i;
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST);
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)outputBuffers, BufferTestUtils.sizeOfPages(10));
        for (i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 3);
        for (i = 3; i < 10; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 7, 3);
        ListenableFuture<Void> future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 8, 3);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 3L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(3L, BufferTestUtils.createPage(3), new Page[0]));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 8, 3);
        Assert.assertFalse((boolean)future.isDone());
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 11, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2), BufferTestUtils.createPage(3), BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6), BufferTestUtils.createPage(7), BufferTestUtils.createPage(8), BufferTestUtils.createPage(9)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 11, 0);
        buffer.get(SECOND, 10L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 1, 10);
        outputBuffers = outputBuffers.withNoMoreBufferIds();
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 8, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 1, 10);
        BufferTestUtils.assertFutureIsDone(future);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(11));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(12));
        future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(13));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 11, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 4, 10);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 4L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(4L, BufferTestUtils.createPage(4), new Page[0]));
        BufferTestUtils.assertFutureIsDone(future);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 10, 4);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 4, 10);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        buffer.setNoMorePages();
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 10, 4);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 4, 10);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 5L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(5L, BufferTestUtils.createPage(5), new Page[0]));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 9, 5);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 4, 10);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        BufferResult x = BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 6L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT);
        BufferTestUtils.assertBufferResultEquals(TYPES, x, TestBroadcastOutputBuffer.bufferResult(6L, BufferTestUtils.createPage(6), BufferTestUtils.createPage(7), BufferTestUtils.createPage(8), BufferTestUtils.createPage(9), BufferTestUtils.createPage(10), BufferTestUtils.createPage(11), BufferTestUtils.createPage(12), BufferTestUtils.createPage(13)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 8, 6);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 14L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)14L, (boolean)true));
        buffer.destroy(FIRST);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 14);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 4, 10);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, SECOND, 10L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(10L, BufferTestUtils.createPage(10), BufferTestUtils.createPage(11), BufferTestUtils.createPage(12), BufferTestUtils.createPage(13)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 4, 10);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, SECOND, 14L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)14L, (boolean)true));
        buffer.destroy(SECOND);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 14);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, SECOND, 14);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 14L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)14L, (boolean)true));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, SECOND, 14L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)14L, (boolean)true));
    }

    @Test
    public void testAcknowledge() {
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST);
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)outputBuffers, BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 2L);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 1, 2);
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 3L);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 3);
        try {
            BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 4L);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid sequence id");
        }
        for (int i = 3; i < 6; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 3);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 3);
    }

    @Test
    public void testSharedBufferFull() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), BufferTestUtils.sizeOfPages(2));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
    }

    @Test
    public void testNotifyStatusOnBufferFull() {
        AtomicInteger notifyCount = new AtomicInteger();
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0), BufferTestUtils.sizeOfPages(1), notifyCount::incrementAndGet);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assert.assertTrue((boolean)buffer.isFull().isDone());
        Assert.assertEquals((int)notifyCount.get(), (int)0);
        ListenableFuture<Void> future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((int)notifyCount.get(), (int)1);
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds());
        buffer.acknowledge(FIRST, 2L);
        BufferTestUtils.assertFutureIsDone(future);
        Assert.assertEquals((int)notifyCount.get(), (int)1);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
        future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(4));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((int)notifyCount.get(), (int)1);
    }

    @Test
    public void testNotifyStatusOnBufferFullWithNoBufferIds() {
        AtomicInteger notifyCount = new AtomicInteger();
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(1), notifyCount::incrementAndGet);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assert.assertTrue((boolean)buffer.isFull().isDone());
        Assert.assertEquals((int)notifyCount.get(), (int)0);
        ListenableFuture<Void> future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((int)notifyCount.get(), (int)0);
        buffer.acknowledge(FIRST, 2L);
        BufferTestUtils.assertFutureIsDone(future);
        Assert.assertEquals((int)notifyCount.get(), (int)0);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
        future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(4));
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((int)notifyCount.get(), (int)0);
    }

    @Test
    public void testDuplicateRequests() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 3);
    }

    @Test
    public void testAddQueueAfterCreation() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected buffer to not change after no more buffers is set");
    }

    @Test
    public void testAddAfterFinish() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        Assert.assertEquals((long)buffer.getInfo().getTotalPagesSent(), (long)0L);
    }

    @Test
    public void testAddQueueAfterNoMoreQueues() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), BufferTestUtils.sizeOfPages(10));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.OPEN);
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withNoMoreBufferIds());
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withNoMoreBufferIds());
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
        buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withNoMoreBufferIds());
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
    }

    @Test
    public void testAddAfterDestroy() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.destroy();
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        Assert.assertEquals((long)buffer.getInfo().getTotalPagesSent(), (long)0L);
    }

    @Test
    public void testGetBeforeCreate() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), BufferTestUtils.sizeOfPages(10));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(1));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
        Assert.assertTrue((boolean)future.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(33), new Page[0]));
    }

    @Test
    public void testSetFinalBuffersWihtoutDeclaringUsedBuffer() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), BufferTestUtils.sizeOfPages(10));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(1));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
        buffer.setNoMorePages();
        Assert.assertTrue((boolean)future.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(33), new Page[0]));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)true));
        buffer.destroy(FIRST);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withNoMoreBufferIds())).isInstanceOf(IllegalStateException.class)).hasMessageMatching(".*does not contain.*\\[0]");
    }

    @Test
    public void testUseUndeclaredBufferAfterFinalBuffersSet() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(1))).isInstanceOf(IllegalStateException.class)).hasMessage("No more buffers already set");
    }

    @Test
    public void testAbortBeforeCreate() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), BufferTestUtils.sizeOfPages(2));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(1));
        Assert.assertFalse((boolean)future.isDone());
        buffer.destroy(FIRST);
        Assert.assertTrue((boolean)future.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testFullBufferBlocksWriter() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(2));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
    }

    @Test
    public void testAcknowledgementFreesWriters() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(2));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 2, 0);
        ListenableFuture<Void> future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 3, 0);
        buffer.get(FIRST, 2L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        Assert.assertFalse((boolean)future.isDone());
        buffer.get(SECOND, 2L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertFutureIsDone(future);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 1, 2);
    }

    @Test
    public void testAbort() {
        BroadcastOutputBuffer bufferedBuffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 10; ++i) {
            BufferTestUtils.addPage((OutputBuffer)bufferedBuffer, BufferTestUtils.createPage(i));
        }
        bufferedBuffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)bufferedBuffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        bufferedBuffer.destroy(FIRST);
        BufferTestUtils.assertQueueClosed((OutputBuffer)bufferedBuffer, FIRST, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)bufferedBuffer, FIRST, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)bufferedBuffer, SECOND, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        bufferedBuffer.destroy(SECOND);
        BufferTestUtils.assertQueueClosed((OutputBuffer)bufferedBuffer, SECOND, 0);
        BufferTestUtils.assertFinished((OutputBuffer)bufferedBuffer);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)bufferedBuffer, SECOND, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testFinishClosesEmptyQueues() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 0);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 0, 0);
        buffer.destroy(FIRST);
        buffer.destroy(SECOND);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 0);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, SECOND, 0);
    }

    @Test
    public void testAbortFreesReader() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        Assert.assertTrue((boolean)future.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.destroy(FIRST);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 1);
    }

    @Test
    public void testFinishFreesReader() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.setNoMorePages();
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)true));
    }

    @Test
    public void testFinishFreesWriter() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.setNoMorePages();
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), BufferTestUtils.createPage(2), BufferTestUtils.createPage(3), BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6)));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 7L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)7L, (boolean)true));
        buffer.destroy(FIRST);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
    }

    @Test
    public void testDestroyFreesReader() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.destroy();
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testDestroyFreesWriter() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.destroy();
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testFailDoesNotFreeReader() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.abort();
        Assert.assertFalse((boolean)future.isDone());
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testFailFreesWriter() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.abort();
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.ABORTED);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testAddBufferAfterFail() {
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0);
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)outputBuffers, BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.OPEN);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestBroadcastOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.abort();
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        future = buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        outputBuffers = outputBuffers.withNoMoreBufferIds();
        buffer.setOutputBuffers((OutputBuffers)outputBuffers);
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        future = buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testBufferCompletion() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < 5; ++i) {
            Page page = BufferTestUtils.createPage(i);
            BufferTestUtils.addPage((OutputBuffer)buffer, page);
            pages.add(page);
        }
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(5), BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        buffer.destroy(FIRST);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
    }

    @Test
    public void testSharedBufferBlocking() {
        SettableFuture blockedFuture = SettableFuture.create();
        MockMemoryReservationHandler reservationHandler = new MockMemoryReservationHandler((ListenableFuture<Void>)blockedFuture);
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)0L);
        Page page = BufferTestUtils.createPage(1);
        long pageSize = BufferTestUtils.serializePage(page).getRetainedSize();
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), DataSize.ofBytes((long)(pageSize * 2L)), memoryContext, MoreExecutors.directExecutor());
        OutputBufferMemoryManager memoryManager = buffer.getMemoryManager();
        BufferTestUtils.enqueuePage((OutputBuffer)buffer, page);
        blockedFuture.set(null);
        memoryManager.onMemoryAvailable();
        Assert.assertTrue((boolean)memoryManager.getBufferBlockedFuture().isDone(), (String)"buffer shouldn't be blocked");
        BufferTestUtils.addPage((OutputBuffer)buffer, page);
        BufferTestUtils.enqueuePage((OutputBuffer)buffer, page);
    }

    @Test
    public void testSharedBufferBlocking2() {
        SettableFuture blockedFuture = SettableFuture.create();
        blockedFuture.set(null);
        MockMemoryReservationHandler reservationHandler = new MockMemoryReservationHandler((ListenableFuture<Void>)blockedFuture);
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)0L);
        Page page = BufferTestUtils.createPage(1);
        long pageSize = BufferTestUtils.serializePage(page).getRetainedSize();
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), DataSize.ofBytes((long)(pageSize * 2L)), memoryContext, MoreExecutors.directExecutor());
        OutputBufferMemoryManager memoryManager = buffer.getMemoryManager();
        BufferTestUtils.addPage((OutputBuffer)buffer, page);
        BufferTestUtils.addPage((OutputBuffer)buffer, page);
        blockedFuture = SettableFuture.create();
        reservationHandler.updateBlockedFuture((ListenableFuture<Void>)blockedFuture);
        memoryManager.updateMemoryUsage(1L);
        blockedFuture.set(null);
        memoryManager.onMemoryAvailable();
        Assert.assertFalse((boolean)memoryManager.getBufferBlockedFuture().isDone(), (String)"buffer should be blocked");
        memoryManager.updateMemoryUsage(-pageSize * 2L - 1L);
        Assert.assertTrue((boolean)memoryManager.getBufferBlockedFuture().isDone(), (String)"buffer shouldn't be blocked");
        BufferTestUtils.addPage((OutputBuffer)buffer, page);
        BufferTestUtils.addPage((OutputBuffer)buffer, page);
        BufferTestUtils.enqueuePage((OutputBuffer)buffer, page);
    }

    @Test
    public void testSharedBufferBlockingNoBlockOnFull() {
        SettableFuture blockedFuture = SettableFuture.create();
        MockMemoryReservationHandler reservationHandler = new MockMemoryReservationHandler((ListenableFuture<Void>)blockedFuture);
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)0L);
        Page page = BufferTestUtils.createPage(1);
        long pageSize = BufferTestUtils.serializePage(page).getRetainedSize();
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), DataSize.ofBytes((long)(pageSize * 2L)), memoryContext, MoreExecutors.directExecutor());
        OutputBufferMemoryManager memoryManager = buffer.getMemoryManager();
        memoryManager.setNoBlockOnFull();
        BufferTestUtils.enqueuePage((OutputBuffer)buffer, page);
        blockedFuture.set(null);
        memoryManager.onMemoryAvailable();
        Assert.assertTrue((boolean)memoryManager.getBufferBlockedFuture().isDone(), (String)"buffer shouldn't be blocked");
        BufferTestUtils.addPage((OutputBuffer)buffer, page);
        BufferTestUtils.addPage((OutputBuffer)buffer, page);
    }

    private BroadcastOutputBuffer createBroadcastBuffer(OutputBuffers outputBuffers, DataSize dataSize, AggregatedMemoryContext memoryContext, Executor notificationExecutor) {
        BroadcastOutputBuffer buffer = new BroadcastOutputBuffer(TASK_INSTANCE_ID, new OutputBufferStateMachine(new TaskId(new StageId(new QueryId("query"), 0), 0, 0), (Executor)this.stateNotificationExecutor), dataSize, () -> memoryContext.newLocalMemoryContext("test"), notificationExecutor, () -> {});
        buffer.setOutputBuffers(outputBuffers);
        return buffer;
    }

    @Test
    public void testBufferFinishesWhenClientBuffersDestroyed() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withBuffer(THIRD, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        buffer.destroy(FIRST);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        buffer.destroy(SECOND);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        buffer.destroy(THIRD);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
    }

    @Test
    public void testForceFreeMemory() {
        BroadcastOutputBuffer buffer = this.createBroadcastBuffer((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1), 0);
        }
        OutputBufferMemoryManager memoryManager = buffer.getMemoryManager();
        Assert.assertTrue((memoryManager.getBufferedBytes() > 0L ? 1 : 0) != 0);
        buffer.forceFreeMemory();
        Assert.assertEquals((long)memoryManager.getBufferedBytes(), (long)0L);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assert.assertEquals((long)memoryManager.getBufferedBytes(), (long)0L);
    }

    private BroadcastOutputBuffer createBroadcastBuffer(OutputBuffers outputBuffers, DataSize dataSize) {
        return this.createBroadcastBuffer(outputBuffers, dataSize, () -> {});
    }

    private BroadcastOutputBuffer createBroadcastBuffer(OutputBuffers outputBuffers, DataSize dataSize, Runnable notifyStatusChanged) {
        BroadcastOutputBuffer buffer = new BroadcastOutputBuffer(TASK_INSTANCE_ID, new OutputBufferStateMachine(new TaskId(new StageId(new QueryId("query"), 0), 0, 0), (Executor)this.stateNotificationExecutor), dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)this.stateNotificationExecutor, notifyStatusChanged);
        buffer.setOutputBuffers(outputBuffers);
        return buffer;
    }

    private static BufferResult bufferResult(long token, Page firstPage, Page ... otherPages) {
        ImmutableList pages = ImmutableList.builder().add((Object)firstPage).add((Object[])otherPages).build();
        return BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, token, (List<Page>)pages);
    }

    private static class MockMemoryReservationHandler
    implements MemoryReservationHandler {
        private ListenableFuture<Void> blockedFuture;

        public MockMemoryReservationHandler(ListenableFuture<Void> blockedFuture) {
            this.blockedFuture = Objects.requireNonNull(blockedFuture, "blockedFuture is null");
        }

        public ListenableFuture<Void> reserveMemory(String allocationTag, long delta) {
            return this.blockedFuture;
        }

        public boolean tryReserveMemory(String allocationTag, long delta) {
            return true;
        }

        public void updateBlockedFuture(ListenableFuture<Void> blockedFuture) {
            this.blockedFuture = Objects.requireNonNull(blockedFuture);
        }
    }
}

