/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.SingleDistributionSplitAssigner;
import io.trino.execution.scheduler.SplitAssignerTester;
import io.trino.execution.scheduler.TestingConnectorSplit;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestSingleDistributionSplitAssigner {
    private static final PlanNodeId PLAN_NODE_1 = new PlanNodeId("plan-node-1");
    private static final PlanNodeId PLAN_NODE_2 = new PlanNodeId("plan-node-2");

    @Test
    public void testNoSources() {
        ImmutableSet hostRequirement = ImmutableSet.of((Object)HostAddress.fromParts((String)"localhost", (int)8080));
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner((Set)hostRequirement, (Set)ImmutableSet.of());
        SplitAssignerTester tester = new SplitAssignerTester();
        tester.update(splitAssigner.finish());
        Assert.assertEquals((int)tester.getPartitionCount(), (int)1);
        Assert.assertEquals((Object)tester.getNodeRequirements(0), (Object)new NodeRequirements(Optional.empty(), (Set)hostRequirement));
        Assert.assertTrue((boolean)tester.isSealed(0));
        Assert.assertTrue((boolean)tester.isNoMorePartitions());
    }

    @Test
    public void testEmptySource() {
        ImmutableSet hostRequirement = ImmutableSet.of((Object)HostAddress.fromParts((String)"localhost", (int)8080));
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner((Set)hostRequirement, (Set)ImmutableSet.of((Object)PLAN_NODE_1));
        SplitAssignerTester tester = new SplitAssignerTester();
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of(), true));
        tester.update(splitAssigner.finish());
        Assert.assertEquals((int)tester.getPartitionCount(), (int)1);
        Assert.assertEquals((Object)tester.getNodeRequirements(0), (Object)new NodeRequirements(Optional.empty(), (Set)hostRequirement));
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).isEmpty();
        Assert.assertTrue((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1));
        Assert.assertTrue((boolean)tester.isSealed(0));
        Assert.assertTrue((boolean)tester.isNoMorePartitions());
    }

    @Test
    public void testSingleSource() {
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)PLAN_NODE_1));
        SplitAssignerTester tester = new SplitAssignerTester();
        Assert.assertEquals((int)tester.getPartitionCount(), (int)0);
        Assert.assertFalse((boolean)tester.isNoMorePartitions());
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(1)), false));
        tester.update(splitAssigner.finish());
        Assert.assertEquals((int)tester.getPartitionCount(), (int)1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactly((Object[])new Integer[]{1});
        Assert.assertTrue((boolean)tester.isNoMorePartitions());
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(2), (Object)1, (Object)this.createSplit(3)), false));
        tester.update(splitAssigner.finish());
        Assert.assertEquals((int)tester.getPartitionCount(), (int)1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactly((Object[])new Integer[]{1, 2, 3});
        Assert.assertFalse((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1));
        Assert.assertFalse((boolean)tester.isSealed(0));
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(4)), true));
        tester.update(splitAssigner.finish());
        Assert.assertTrue((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1));
        Assert.assertTrue((boolean)tester.isSealed(0));
    }

    @Test
    public void testMultipleSources() {
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)PLAN_NODE_1, (Object)PLAN_NODE_2));
        SplitAssignerTester tester = new SplitAssignerTester();
        Assert.assertEquals((int)tester.getPartitionCount(), (int)0);
        Assert.assertFalse((boolean)tester.isNoMorePartitions());
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(1)), false));
        tester.update(splitAssigner.finish());
        Assert.assertEquals((int)tester.getPartitionCount(), (int)1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactly((Object[])new Integer[]{1});
        Assert.assertTrue((boolean)tester.isNoMorePartitions());
        tester.update(splitAssigner.assign(PLAN_NODE_2, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(2), (Object)1, (Object)this.createSplit(3)), false));
        tester.update(splitAssigner.finish());
        Assert.assertEquals((int)tester.getPartitionCount(), (int)1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_2)).containsExactly((Object[])new Integer[]{2, 3});
        Assert.assertFalse((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1));
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)2, (Object)this.createSplit(4)), true));
        tester.update(splitAssigner.finish());
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactly((Object[])new Integer[]{1, 4});
        Assert.assertTrue((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1));
        Assert.assertFalse((boolean)tester.isNoMoreSplits(0, PLAN_NODE_2));
        Assert.assertFalse((boolean)tester.isSealed(0));
        tester.update(splitAssigner.assign(PLAN_NODE_2, (ListMultimap)ImmutableListMultimap.of((Object)3, (Object)this.createSplit(5)), true));
        tester.update(splitAssigner.finish());
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_2)).containsExactly((Object[])new Integer[]{2, 3, 5});
        Assert.assertTrue((boolean)tester.isNoMoreSplits(0, PLAN_NODE_2));
        Assert.assertTrue((boolean)tester.isSealed(0));
    }

    private Split createSplit(int id) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.empty(), Optional.empty()));
    }
}

