/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalFunctionDependencies;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.function.TypeVariableConstraint;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestPolymorphicScalarFunction {
    private static final FunctionManager FUNCTION_MANAGER = FunctionManager.createTestingFunctionManager();
    private static final String FUNCTION_NAME = "foo";
    private static final Signature SIGNATURE = Signature.builder().returnType((Type)BigintType.BIGINT).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
    private static final int INPUT_VARCHAR_LENGTH = 10;
    private static final Slice INPUT_SLICE = Slices.allocate((int)10);
    private static final BoundSignature BOUND_SIGNATURE = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"foo"), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)10)));
    private static final TypeSignature DECIMAL_SIGNATURE = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
    private static final DecimalType LONG_DECIMAL_BOUND_TYPE = DecimalType.createDecimalType((int)19, (int)2);
    private static final DecimalType SHORT_DECIMAL_BOUND_TYPE = DecimalType.createDecimalType((int)18, (int)2);

    @Test
    public void testSelectsMultipleChoiceWithBlockPosition() throws Throwable {
        Signature signature = Signature.builder().argumentType(DECIMAL_SIGNATURE).argumentType(DECIMAL_SIGNATURE).returnType((Type)BooleanType.BOOLEAN).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(OperatorType.IS_DISTINCT_FROM, TestMethods.class).signature(signature).argumentNullability(new boolean[]{true, true}).deterministic(true).choice(choice -> choice.argumentProperties(new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NULL_FLAG, InvocationConvention.InvocationArgumentConvention.NULL_FLAG}).implementation(methodsGroup -> methodsGroup.methods(new String[]{"shortShort", "longLong"}))).choice(choice -> choice.argumentProperties(new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}).implementation(methodsGroup -> methodsGroup.methodWithExplicitJavaTypes("blockPositionLongLong", Arrays.asList(Optional.of(Int128.class), Optional.of(Int128.class))).methodWithExplicitJavaTypes("blockPositionShortShort", Arrays.asList(Optional.of(Long.TYPE), Optional.of(Long.TYPE))))).build();
        BoundSignature shortDecimalBoundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)OperatorNameUtil.mangleOperatorName((OperatorType)OperatorType.IS_DISTINCT_FROM)), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)SHORT_DECIMAL_BOUND_TYPE, (Object)SHORT_DECIMAL_BOUND_TYPE));
        ChoicesSpecializedSqlScalarFunction specializedFunction = (ChoicesSpecializedSqlScalarFunction)function.specialize(shortDecimalBoundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertEquals((int)specializedFunction.getChoices().size(), (int)2);
        Assert.assertEquals((Object)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(0)).getInvocationConvention(), (Object)new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, false));
        Assert.assertEquals((Object)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(1)).getInvocationConvention(), (Object)new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, (Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, false));
        LongArrayBlock block1 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        LongArrayBlock block2 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        Assert.assertFalse((boolean)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
        BoundSignature longDecimalBoundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)OperatorNameUtil.mangleOperatorName((OperatorType)OperatorType.IS_DISTINCT_FROM)), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)LONG_DECIMAL_BOUND_TYPE, (Object)LONG_DECIMAL_BOUND_TYPE));
        specializedFunction = (ChoicesSpecializedSqlScalarFunction)function.specialize(longDecimalBoundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertTrue((boolean)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
    }

    @Test
    public void testSelectsMethodBasedOnArgumentTypes() throws Throwable {
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(FUNCTION_NAME, TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)context.getLiteral("x"))))).build();
        ChoicesSpecializedSqlScalarFunction specializedFunction = (ChoicesSpecializedSqlScalarFunction)function.specialize(BOUND_SIGNATURE, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertEquals((Object)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE), (Object)10L);
    }

    @Test
    public void testSelectsMethodBasedOnReturnType() throws Throwable {
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(FUNCTION_NAME, TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarcharCreateSliceWithExtraParameterLength"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)42)))).build();
        ChoicesSpecializedSqlScalarFunction specializedFunction = (ChoicesSpecializedSqlScalarFunction)function.specialize(BOUND_SIGNATURE, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertEquals((Object)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE), (Object)42L);
    }

    @Test
    public void testSameLiteralInArgumentsAndReturnValue() throws Throwable {
        Signature signature = Signature.builder().returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(FUNCTION_NAME, TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)FUNCTION_NAME), (Type)VarcharType.createVarcharType((int)10), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)10)));
        ChoicesSpecializedSqlScalarFunction specializedFunction = (ChoicesSpecializedSqlScalarFunction)function.specialize(boundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Slice slice = ((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testTypeParameters() throws Throwable {
        Signature signature = Signature.builder().typeVariableConstraint(TypeVariableConstraint.builder((String)"V").comparableRequired().variadicBound("ROW").build()).returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentType(new TypeSignature("V", new TypeSignatureParameter[0])).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(FUNCTION_NAME, TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)FUNCTION_NAME), (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR));
        ChoicesSpecializedSqlScalarFunction specializedFunction = (ChoicesSpecializedSqlScalarFunction)function.specialize(boundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Slice slice = ((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specializedFunction.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testSetsHiddenToTrueForOperators() {
        Signature signature = Signature.builder().returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(OperatorType.ADD, TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)OperatorNameUtil.mangleOperatorName((OperatorType)OperatorType.ADD)), (Type)VarcharType.createVarcharType((int)10), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)10)));
        function.specialize(boundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
    }

    @Test
    public void testFailIfNotAllMethodsPresent() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new PolymorphicScalarFunctionBuilder(FUNCTION_NAME, TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{FUNCTION_NAME}))).build()).isInstanceOf(IllegalStateException.class)).hasMessageMatching("method foo was not found in class io.trino.metadata.TestPolymorphicScalarFunction\\$TestMethods");
    }

    @Test
    public void testFailNoMethodsAreSelectedWhenExtraParametersFunctionIsSet() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new PolymorphicScalarFunctionBuilder(FUNCTION_NAME, TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.withExtraParameters(context -> ImmutableList.of((Object)42)))).build()).isInstanceOf(IllegalStateException.class)).hasMessageMatching("methods must be selected first");
    }

    @Test
    public void testFailIfTwoMethodsWithSameArguments() {
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(FUNCTION_NAME, TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnFirstExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}))).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> function.specialize(BOUND_SIGNATURE, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()))).isInstanceOf(IllegalStateException.class)).hasMessageMatching("two matching methods \\(varcharToBigintReturnFirstExtraParameter and varcharToBigintReturnExtraParameter\\) for parameter types \\[varchar\\(10\\)\\]");
    }

    public static final class TestMethods {
        static final Slice VARCHAR_TO_VARCHAR_RETURN_VALUE = Slices.utf8Slice((String)"hello world");
        static final long VARCHAR_TO_BIGINT_RETURN_VALUE = 42L;

        public static Slice varcharToVarchar(Slice varchar) {
            return VARCHAR_TO_VARCHAR_RETURN_VALUE;
        }

        public static long varcharToBigint(Slice varchar) {
            return 42L;
        }

        public static long varcharToBigintReturnExtraParameter(Slice varchar, long extraParameter) {
            return extraParameter;
        }

        public static long bigintToBigintReturnExtraParameter(long bigint, int extraParameter) {
            return bigint;
        }

        public static long varcharToBigintReturnFirstExtraParameter(Slice varchar, long extraParameter1, int extraParameter2) {
            return extraParameter1;
        }

        public static Slice varcharToVarcharCreateSliceWithExtraParameterLength(Slice string, int extraParameter) {
            return Slices.allocate((int)extraParameter);
        }

        public static boolean blockPositionLongLong(Block left, int leftPosition, Block right, int rightPosition) {
            return true;
        }

        public static boolean blockPositionShortShort(Block left, int leftPosition, Block right, int rightPosition) {
            return false;
        }

        public static boolean shortShort(long left, boolean leftNull, long right, boolean rightNull) {
            return false;
        }

        public static boolean longLong(Int128 left, boolean leftNull, Int128 right, boolean rightNull) {
            return false;
        }
    }
}

