/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SqlFunction;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.testing.LocalQueryRunner;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TestingFunctionResolution {
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final PlannerContext plannerContext;

    public TestingFunctionResolution() {
        this((FunctionBundle)new InternalFunctionBundle(new SqlFunction[0]));
    }

    public TestingFunctionResolution(FunctionBundle functions) {
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withTransactionManager(this.transactionManager).addFunctions(functions).build();
        this.metadata = this.plannerContext.getMetadata();
    }

    public TestingFunctionResolution(LocalQueryRunner localQueryRunner) {
        this(localQueryRunner.getTransactionManager(), localQueryRunner.getPlannerContext());
    }

    public TestingFunctionResolution(TransactionManager transactionManager, PlannerContext plannerContext) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public ExpressionCompiler getExpressionCompiler() {
        return new ExpressionCompiler(this.plannerContext.getFunctionManager(), this.getPageFunctionCompiler());
    }

    public PageFunctionCompiler getPageFunctionCompiler() {
        return this.getPageFunctionCompiler(0);
    }

    public PageFunctionCompiler getPageFunctionCompiler(int expressionCacheSize) {
        return new PageFunctionCompiler(this.plannerContext.getFunctionManager(), expressionCacheSize);
    }

    public Collection<FunctionMetadata> listGlobalFunctions() {
        return this.inTransaction(arg_0 -> ((Metadata)this.metadata).listGlobalFunctions(arg_0));
    }

    public ResolvedFunction resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.inTransaction(session -> this.metadata.resolveOperator(operatorType, argumentTypes));
    }

    public ResolvedFunction getCoercion(Type fromType, Type toType) {
        return this.inTransaction(session -> this.metadata.getCoercion(fromType, toType));
    }

    public ResolvedFunction getCoercion(CatalogSchemaFunctionName name, Type fromType, Type toType) {
        return this.inTransaction(session -> this.metadata.getCoercion(name, fromType, toType));
    }

    public TestingFunctionCallBuilder functionCallBuilder(String name) {
        return new TestingFunctionCallBuilder(name);
    }

    public ResolvedFunction resolveFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        return this.metadata.resolveBuiltinFunction(name, parameterTypes);
    }

    public TestingAggregationFunction getAggregateFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        return this.inTransaction(session -> {
            ResolvedFunction resolvedFunction = this.metadata.resolveBuiltinFunction(name, parameterTypes);
            return new TestingAggregationFunction(resolvedFunction.getSignature(), resolvedFunction.getFunctionNullability(), this.plannerContext.getFunctionManager().getAggregationImplementation(resolvedFunction));
        });
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    public class TestingFunctionCallBuilder {
        private final String name;
        private List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private List<Expression> argumentValues = new ArrayList<Expression>();

        public TestingFunctionCallBuilder(String name) {
            this.name = name;
        }

        public TestingFunctionCallBuilder addArgument(Type type, Expression value) {
            Objects.requireNonNull(type, "type is null");
            return this.addArgument(type.getTypeSignature(), value);
        }

        public TestingFunctionCallBuilder addArgument(TypeSignature typeSignature, Expression value) {
            Objects.requireNonNull(typeSignature, "typeSignature is null");
            Objects.requireNonNull(value, "value is null");
            this.argumentTypes.add(typeSignature);
            this.argumentValues.add(value);
            return this;
        }

        public TestingFunctionCallBuilder setArguments(List<Type> types, List<Expression> values) {
            Objects.requireNonNull(types, "types is null");
            Objects.requireNonNull(values, "values is null");
            this.argumentTypes = types.stream().map(Type::getTypeSignature).collect(Collectors.toList());
            this.argumentValues = new ArrayList<Expression>(values);
            return this;
        }

        public FunctionCall build() {
            return new FunctionCall(Optional.empty(), TestingFunctionResolution.this.resolveFunction(this.name, TypeSignatureProvider.fromTypeSignatures(this.argumentTypes)).toQualifiedName(), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), this.argumentValues);
        }
    }
}

