/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.operator.DeduplicatingDirectExchangeBuffer;
import io.trino.operator.DirectExchangeBuffer;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeManagerFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeManagerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeduplicatingDirectExchangeBuffer {
    private static final DataSize DEFAULT_BUFFER_CAPACITY = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private ExchangeManagerRegistry exchangeManagerRegistry;

    @BeforeAll
    public void beforeClass() {
        this.exchangeManagerRegistry = new ExchangeManagerRegistry();
        this.exchangeManagerRegistry.addExchangeManagerFactory((ExchangeManagerFactory)new FileSystemExchangeManagerFactory());
        this.exchangeManagerRegistry.loadExchangeManager("filesystem", (Map)ImmutableMap.of((Object)"exchange.base-directories", (Object)(System.getProperty("java.io.tmpdir") + "/trino-local-file-system-exchange-manager")));
    }

    @AfterAll
    public void afterClass() {
        this.exchangeManagerRegistry = null;
    }

    @Test
    public void testIsBlocked() {
        TaskId taskId;
        ListenableFuture blocked;
        try (DeduplicatingDirectExchangeBuffer buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);){
            blocked = buffer.isBlocked();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.close();
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFinished(taskId);
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFinished(taskId);
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            ListenableFuture blocked1 = buffer.isBlocked();
            ListenableFuture blocked2 = buffer.isBlocked();
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked1);
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked2);
            blocked2.cancel(true);
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)blocked1);
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)blocked2);
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
    }

    @Test
    public void testPollPagesQueryLevelRetry() {
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.of(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DEFAULT_BUFFER_CAPACITY, 0, (List<Slice>)ImmutableList.of());
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.BYTE))), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.BYTE))));
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 1, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)new RuntimeException("error")), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v1", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.KILOBYTE)), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v1", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)new RuntimeException("error")), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a1v0", DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)new RuntimeException("error")), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE)), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a1v0", DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(2, 0), (Object)new RuntimeException("error")), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(2, 0), (Object)new RuntimeException("error")), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 3, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        RuntimeException error = new RuntimeException("error");
        this.testPollPagesFailure(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(2, 2), (Object)error), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, error);
        this.testPollPagesFailure(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)error), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, error);
        this.testPollPagesFailure(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(2, 2), (Object)error), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 3, error);
        this.testPollPagesFailure(RetryPolicy.QUERY, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)error), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 3, error);
    }

    @Test
    public void testPollPagesTaskLevelRetry() {
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.of(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DEFAULT_BUFFER_CAPACITY, 0, (List<Slice>)ImmutableList.of());
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.BYTE))), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.BYTE))));
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 1, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 3, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)new RuntimeException("error")), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        this.testPollPages(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)new RuntimeException("error")), DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 3, (List<Slice>)ImmutableList.of((Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))));
        RuntimeException error = new RuntimeException("error");
        this.testPollPagesFailure(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(2, 2), (Object)error), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, error);
        this.testPollPagesFailure(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)error), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 0, error);
        this.testPollPagesFailure(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(2, 2), (Object)error), DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 3, error);
        this.testPollPagesFailure(RetryPolicy.TASK, (Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p0a1v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).put((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0), (Object)TestDeduplicatingDirectExchangeBuffer.createPage("p1a0v0", DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE))).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1), (Object)error), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2, error);
    }

    private void testPollPages(RetryPolicy retryPolicy, Multimap<TaskId, Slice> pages, Map<TaskId, RuntimeException> failures, DataSize bufferCapacity, int expectedSpilledPageCount, List<Slice> expectedOutput) {
        List<Slice> actualOutput = this.pollPages(retryPolicy, pages, failures, bufferCapacity, expectedSpilledPageCount);
        Assert.assertEquals(actualOutput, expectedOutput);
    }

    private void testPollPagesFailure(RetryPolicy retryPolicy, Multimap<TaskId, Slice> pages, Map<TaskId, RuntimeException> failures, DataSize bufferCapacity, int expectedSpilledPageCount, Throwable expectedFailure) {
        Assertions.assertThatThrownBy(() -> this.pollPages(retryPolicy, pages, failures, bufferCapacity, expectedSpilledPageCount)).isEqualTo((Object)expectedFailure);
    }

    private List<Slice> pollPages(RetryPolicy retryPolicy, Multimap<TaskId, Slice> pages, Map<TaskId, RuntimeException> failures, DataSize bufferCapacity, int expectedSpilledPageCount) {
        HashSet<TaskId> addedTasks = new HashSet<TaskId>();
        try (DeduplicatingDirectExchangeBuffer buffer = this.createDeduplicatingDirectExchangeBuffer(bufferCapacity, retryPolicy);){
            for (Map.Entry immutableList : pages.entries()) {
                if (addedTasks.add((TaskId)immutableList.getKey())) {
                    buffer.addTask((TaskId)immutableList.getKey());
                }
                buffer.addPages((TaskId)immutableList.getKey(), (List)ImmutableList.of((Object)((Slice)immutableList.getValue())));
            }
            for (Map.Entry entry : failures.entrySet()) {
                if (addedTasks.add((TaskId)entry.getKey())) {
                    buffer.addTask((TaskId)entry.getKey());
                }
                buffer.taskFailed((TaskId)entry.getKey(), (Throwable)entry.getValue());
            }
            for (TaskId taskId : Sets.difference((Set)pages.keySet(), failures.keySet())) {
                buffer.taskFinished(taskId);
            }
            buffer.noMoreTasks();
            ImmutableList.Builder result = ImmutableList.builder();
            while (!buffer.isFinished()) {
                Futures.getUnchecked((Future)buffer.isBlocked());
                Slice slice = buffer.pollPage();
                if (slice == null) continue;
                result.add((Object)slice);
            }
            Assert.assertTrue((boolean)buffer.isFinished());
            Assert.assertEquals((int)buffer.getSpilledPageCount(), (int)expectedSpilledPageCount);
            ImmutableList immutableList = result.build();
            return immutableList;
        }
    }

    @Test
    public void testRemovePagesForPreviousAttempts() {
        try (DeduplicatingDirectExchangeBuffer buffer = this.createDeduplicatingDirectExchangeBuffer(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), RetryPolicy.QUERY);){
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)0L);
            TaskId partition0Attempt0 = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            TaskId partition1Attempt0 = TestDeduplicatingDirectExchangeBuffer.createTaskId(1, 0);
            TaskId partition0Attempt1 = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 1);
            Slice page1 = Slices.utf8Slice((String)"textofrandomlength");
            Slice page2 = Slices.utf8Slice((String)"textwithdifferentlength");
            Slice page3 = Slices.utf8Slice((String)"smalltext");
            buffer.addTask(partition0Attempt0);
            buffer.addPages(partition0Attempt0, (List)ImmutableList.of((Object)page1));
            buffer.addTask(partition1Attempt0);
            buffer.addPages(partition1Attempt0, (List)ImmutableList.of((Object)page2));
            Assertions.assertThat((long)buffer.getRetainedSizeInBytes()).isGreaterThan(0L);
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)(page1.getRetainedSize() + page2.getRetainedSize()));
            buffer.addTask(partition0Attempt1);
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)0L);
            buffer.addPages(partition0Attempt1, (List)ImmutableList.of((Object)page3));
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)page3.getRetainedSize());
        }
    }

    @Test
    public void testExchangeManagerNotConfigured() {
        TaskId task;
        try (DeduplicatingDirectExchangeBuffer buffer = new DeduplicatingDirectExchangeBuffer(MoreExecutors.directExecutor(), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.BYTE), RetryPolicy.QUERY, new ExchangeManagerRegistry(), new QueryId("query"), ExchangeId.createRandomExchangeId());){
            task = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            Slice page = TestDeduplicatingDirectExchangeBuffer.createPage("1234", DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.BYTE));
            buffer.addTask(task);
            buffer.addPages(task, (List)ImmutableList.of((Object)page));
            buffer.taskFinished(task);
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertEquals((Object)buffer.pollPage(), (Object)page);
            Assert.assertNull((Object)buffer.pollPage());
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        buffer = new DeduplicatingDirectExchangeBuffer(MoreExecutors.directExecutor(), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.BYTE), RetryPolicy.QUERY, new ExchangeManagerRegistry(), new QueryId("query"), ExchangeId.createRandomExchangeId());
        try {
            task = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            Slice page1 = Slices.utf8Slice((String)"1234");
            Slice page2 = Slices.utf8Slice((String)"123456789");
            Assertions.assertThat((long)page1.getRetainedSize()).isLessThanOrEqualTo(100L);
            Assertions.assertThat((long)(page1.getRetainedSize() + page2.getRetainedSize())).isGreaterThan(100L);
            buffer.addTask(task);
            buffer.addPages(task, (List)ImmutableList.of((Object)page1));
            Assert.assertFalse((boolean)buffer.isFinished());
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)page1.getRetainedSize());
            buffer.addPages(task, (List)ImmutableList.of((Object)page2));
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
            TestDeduplicatingDirectExchangeBuffer.assertNotBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)0L);
            Assert.assertEquals((int)buffer.getBufferedPageCount(), (int)0);
            Assertions.assertThatThrownBy(() -> ((DirectExchangeBuffer)buffer).pollPage()).isInstanceOf(TrinoException.class);
        }
        finally {
            buffer.close();
        }
    }

    @Test
    public void testIsFinished() {
        TaskId taskId;
        try (DeduplicatingDirectExchangeBuffer buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);){
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.close();
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.addPages(taskId, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"page")));
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.addPages(taskId, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"page")));
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertNotNull((Object)buffer.pollPage());
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.addPages(taskId, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"page")));
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertNotNull((Object)buffer.pollPage());
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
    }

    @Test
    public void testRemainingBufferCapacity() {
        try (DeduplicatingDirectExchangeBuffer buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, RetryPolicy.QUERY);){
            Assert.assertFalse((boolean)buffer.isFinished());
            TaskId taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Slice page = Slices.utf8Slice((String)"page");
            buffer.addPages(taskId, (List)ImmutableList.of((Object)page));
            Assert.assertEquals((long)buffer.getRemainingCapacityInBytes(), (long)Long.MAX_VALUE);
        }
    }

    @Test
    public void testRemoteTaskFailedError() {
        this.testRemoteTaskFailedError(RetryPolicy.QUERY);
        this.testRemoteTaskFailedError(RetryPolicy.TASK);
    }

    private void testRemoteTaskFailedError(RetryPolicy retryPolicy) {
        TaskId taskId;
        try (DeduplicatingDirectExchangeBuffer buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, retryPolicy);){
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.taskFailed(taskId, (Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_FAILED, "Remote task failed"));
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertFalse((boolean)buffer.isFailed());
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertNull((Object)buffer.pollPage());
        }
        buffer = this.createDeduplicatingDirectExchangeBuffer(DEFAULT_BUFFER_CAPACITY, retryPolicy);
        try {
            taskId = TestDeduplicatingDirectExchangeBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.noMoreTasks();
            buffer.taskFailed(taskId, (Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_FAILED, "Remote task failed"));
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertFalse((boolean)buffer.isFailed());
            TestDeduplicatingDirectExchangeBuffer.assertBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertNull((Object)buffer.pollPage());
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
        }
    }

    private DeduplicatingDirectExchangeBuffer createDeduplicatingDirectExchangeBuffer(DataSize bufferCapacity, RetryPolicy retryPolicy) {
        return new DeduplicatingDirectExchangeBuffer(MoreExecutors.directExecutor(), bufferCapacity, retryPolicy, this.exchangeManagerRegistry, new QueryId("query"), ExchangeId.createRandomExchangeId());
    }

    private static TaskId createTaskId(int partition, int attempt) {
        return new TaskId(new StageId("query", 0), partition, attempt);
    }

    private static Slice createPage(String value, DataSize size) {
        Slice encodedValue = Slices.utf8Slice((String)value);
        int sizeInBytes = Math.toIntExact(size.toBytes());
        Preconditions.checkArgument((encodedValue.length() <= sizeInBytes ? 1 : 0) != 0, (String)"encoded value %s is larger than the total requested size of a page %s", (Object)value, (Object)size);
        Slice result = Slices.allocate((int)sizeInBytes);
        result.setBytes(0, encodedValue);
        return result;
    }

    private static void assertNotBlocked(ListenableFuture<Void> blocked) {
        Assert.assertTrue((boolean)blocked.isDone());
    }

    private static void assertBlocked(ListenableFuture<Void> blocked) {
        Assert.assertFalse((boolean)blocked.isDone());
    }
}

