/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.RowPagesBuilder;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.MergeHashSort;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorAssertion;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestMergeHashSort {
    private final TypeOperators typeOperators = new TypeOperators();

    @Test
    public void testBinaryMergeIteratorOverEmptyPage() {
        Page emptyPage = new Page(0, new Block[]{BigintType.BIGINT.createFixedSizeBlockBuilder(0).build()});
        WorkProcessor mergedPage = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), this.typeOperators).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)emptyPage).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        WorkProcessorAssertion.assertFinishes(mergedPage);
    }

    @Test
    public void testBinaryMergeIteratorOverEmptyPageAndNonEmptyPage() {
        Page emptyPage = new Page(0, new Block[]{BigintType.BIGINT.createFixedSizeBlockBuilder(0).build()});
        Page page = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0);
        WorkProcessor mergedPage = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), this.typeOperators).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)emptyPage, (Object)page).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        Assert.assertTrue((boolean)mergedPage.process());
        Page actualPage = (Page)mergedPage.getResult();
        Assert.assertEquals((int)actualPage.getPositionCount(), (int)1);
        Assert.assertEquals((int)actualPage.getChannelCount(), (int)1);
        Assert.assertEquals((long)actualPage.getBlock(0).getLong(0, 0), (long)42L);
        WorkProcessorAssertion.assertFinishes(mergedPage);
    }

    @Test
    public void testBinaryMergeIteratorOverPageWith() {
        Page emptyPage = new Page(0, new Block[]{BigintType.BIGINT.createFixedSizeBlockBuilder(0).build()});
        Page page = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0);
        WorkProcessor mergedPage = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), this.typeOperators).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)emptyPage, (Object)page).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        Assert.assertTrue((boolean)mergedPage.process());
        Page actualPage = (Page)mergedPage.getResult();
        Assert.assertEquals((int)actualPage.getPositionCount(), (int)1);
        Assert.assertEquals((int)actualPage.getChannelCount(), (int)1);
        Assert.assertEquals((long)actualPage.getBlock(0).getLong(0, 0), (long)42L);
        WorkProcessorAssertion.assertFinishes(mergedPage);
    }

    @Test
    public void testBinaryMergeIteratorOverPageWithDifferentHashes() {
        Page page = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).row(42).row(52).row(60).build().get(0);
        WorkProcessor mergedPages = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), this.typeOperators).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)page).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        Assert.assertTrue((boolean)mergedPages.process());
        Page resultPage = (Page)mergedPages.getResult();
        Assert.assertEquals((int)resultPage.getPositionCount(), (int)4);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(0, 0), (long)42L);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(1, 0), (long)42L);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(2, 0), (long)52L);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(3, 0), (long)60L);
        WorkProcessorAssertion.assertFinishes(mergedPages);
    }
}

