/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.SequencePageBuilder;
import io.trino.SessionTestUtils;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.PagesIndex;
import io.trino.operator.join.LookupSource;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestPagesIndex {
    @Test
    public void testEstimatedSize() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
        PagesIndex pagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 30, false);
        long initialEstimatedSize = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertTrue((initialEstimatedSize > 0L ? 1 : 0) != 0, (String)String.format("Initial estimated size must be positive, got %s", initialEstimatedSize));
        pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
        long estimatedSizeWithOnePage = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertTrue((estimatedSizeWithOnePage > initialEstimatedSize ? 1 : 0) != 0, (String)"Estimated size should grow after adding a page");
        pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
        long estimatedSizeWithTwoPages = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertEquals((long)estimatedSizeWithTwoPages, (long)(initialEstimatedSize + (estimatedSizeWithOnePage - initialEstimatedSize) * 2L), (String)"Estimated size should grow linearly as long as we don't pass expectedPositions");
        pagesIndex.compact();
        long estimatedSizeAfterCompact = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertTrue((estimatedSizeAfterCompact < estimatedSizeWithTwoPages ? 1 : 0) != 0, (String)String.format("Compact should reduce (or retain) size, but changed from %s to %s", estimatedSizeWithTwoPages, estimatedSizeAfterCompact));
    }

    @Test
    public void testEagerCompact() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        PagesIndex lazyCompactPagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, false);
        PagesIndex eagerCompactPagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, true);
        for (int i = 0; i < 5; ++i) {
            lazyCompactPagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
            eagerCompactPagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
            Assert.assertTrue((eagerCompactPagesIndex.getEstimatedSize().toBytes() < lazyCompactPagesIndex.getEstimatedSize().toBytes() ? 1 : 0) != 0, (String)"Expect eagerCompactPagesIndex retained less data than lazyCompactPagesIndex after adding the page, because the pages used in the test are compactable.");
        }
        lazyCompactPagesIndex.compact();
        Assert.assertEquals((Object)lazyCompactPagesIndex.getEstimatedSize(), (Object)eagerCompactPagesIndex.getEstimatedSize());
    }

    @Test
    public void testCompactWithNoColumns() {
        PagesIndex index = TestPagesIndex.newPagesIndex((List<Type>)ImmutableList.of(), 50, false);
        index.addPage(new Page(10));
        index.addPage(new Page(20));
        index.compact();
        Assert.assertEquals((int)index.getPositionCount(), (int)30);
    }

    @Test
    public void testGetPagesWithNoColumns() {
        PagesIndex index = TestPagesIndex.newPagesIndex((List<Type>)ImmutableList.of(), 50, false);
        index.addPage(new Page(10));
        index.addPage(new Page(20));
        Iterator pages = index.getPages();
        Assert.assertEquals((int)((Page)pages.next()).getPositionCount(), (int)10);
        Assert.assertEquals((int)((Page)pages.next()).getPositionCount(), (int)20);
        Assert.assertFalse((boolean)pages.hasNext());
    }

    @Test
    public void testGetEstimatedLookupSourceSizeInBytes() {
        for (Optional sortChannel : Arrays.asList(Optional.empty(), Optional.of(0), Optional.of(1))) {
            for (int joinChannel : Arrays.asList(0, 1)) {
                ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
                PagesIndex pagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, false);
                int pageCount = 100;
                for (int i = 0; i < pageCount; ++i) {
                    pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
                }
                long pageIndexSize = pagesIndex.getEstimatedSize().toBytes();
                long estimatedMemoryRequiredToCreateLookupSource = pagesIndex.getEstimatedMemoryRequiredToCreateLookupSource(HashArraySizeSupplier.defaultHashArraySizeSupplier(), sortChannel, (List)ImmutableList.of((Object)joinChannel));
                Assertions.assertThat((long)estimatedMemoryRequiredToCreateLookupSource).isGreaterThan(pageIndexSize);
                long estimatedLookupSourceSize = estimatedMemoryRequiredToCreateLookupSource - SizeOf.sizeOfIntArray((int)pageCount);
                long estimatedAdditionalSize = estimatedMemoryRequiredToCreateLookupSource - pageIndexSize;
                JoinFilterFunctionCompiler.JoinFilterFunctionFactory filterFunctionFactory = (session, addresses, pages) -> (leftPosition, rightPosition, rightPage) -> false;
                LookupSource lookupSource = (LookupSource)pagesIndex.createLookupSourceSupplier(SessionTestUtils.TEST_SESSION, (List)ImmutableList.of((Object)joinChannel), OptionalInt.empty(), sortChannel.map(channel -> filterFunctionFactory), sortChannel, (List)ImmutableList.of((Object)filterFunctionFactory), Optional.of(ImmutableList.of((Object)0, (Object)1)), HashArraySizeSupplier.defaultHashArraySizeSupplier()).get();
                long actualLookupSourceSize = lookupSource.getInMemorySizeInBytes();
                Assertions.assertThat((long)estimatedLookupSourceSize).isGreaterThanOrEqualTo(actualLookupSourceSize);
                Assertions.assertThat((long)estimatedLookupSourceSize).isCloseTo(actualLookupSourceSize, Percentage.withPercentage((double)1.0));
                long addressesSize = SizeOf.sizeOf((long[])pagesIndex.getValueAddresses().elements());
                long channelsArraySize = SizeOf.sizeOf((Object[])pagesIndex.getChannel(0).elements()) * (long)types.size();
                long blocksSize = 0L;
                for (int channel2 = 0; channel2 < 2; ++channel2) {
                    blocksSize += pagesIndex.getChannel(channel2).stream().mapToLong(Block::getRetainedSizeInBytes).sum();
                }
                long actualAdditionalSize = actualLookupSourceSize - (addressesSize + channelsArraySize + blocksSize);
                Assertions.assertThat((long)estimatedAdditionalSize).isCloseTo(actualAdditionalSize, Percentage.withPercentage((double)1.0));
            }
        }
    }

    private static PagesIndex newPagesIndex(List<Type> types, int expectedPositions, boolean eagerCompact) {
        return new PagesIndex.TestingFactory(eagerCompact).newPagesIndex(types, expectedPositions);
    }

    private static Page somePage(List<Type> types) {
        int[] initialValues = new int[types.size()];
        Arrays.setAll(initialValues, i -> 100 * i);
        return SequencePageBuilder.createSequencePage(types, 7, initialValues);
    }
}

