/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import java.util.List;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.junit.jupiter.api.Test;

public class TestDoubleRegrInterceptAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 2, start + 2 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "regr_intercept";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = start; i < start + length; ++i) {
            regression.addData((double)(i + 2), (double)i);
        }
        return regression.getIntercept();
    }

    @Test
    public void testNonTrivialResult() {
        this.testNonTrivialAggregation(new Double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new Double[]{1.0, 4.0, 9.0, 16.0, 25.0});
        this.testNonTrivialAggregation(new Double[]{1.0, 4.0, 9.0, 16.0, 25.0}, new Double[]{1.0, 2.0, 3.0, 4.0, 5.0});
    }

    private void testNonTrivialAggregation(Double[] y, Double[] x) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData(x[i].doubleValue(), y[i].doubleValue());
        }
        double expected = regression.getIntercept();
        Preconditions.checkArgument((Double.isFinite(expected) && expected != 0.0 ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(expected, BlockAssertions.createDoublesBlock(y), BlockAssertions.createDoublesBlock(x));
    }
}

