/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.SqlIntervalDayTime;
import java.util.List;

public class TestIntervalDayToSecondSumAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalDayTimeType.INTERVAL_DAY_TIME.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(blockBuilder, (long)i * 1000L);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected SqlIntervalDayTime getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        long sum = 0L;
        for (int i = start; i < start + length; ++i) {
            sum += (long)i * 1000L;
        }
        return new SqlIntervalDayTime(sum);
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)IntervalDayTimeType.INTERVAL_DAY_TIME);
    }
}

