/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestListagg {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testEmpty() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN}), null, BlockAssertions.createStringsBlock(new String[]{null}), BlockAssertions.createStringsBlock(","), BlockAssertions.createBooleansBlock(true), BlockAssertions.createStringsBlock("..."), BlockAssertions.createBooleansBlock(false));
    }

    @Test
    public void testOnlyNullValues() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN}), null, BlockAssertions.createStringsBlock(null, null, null), BlockAssertions.createStringsBlock(Collections.nCopies(3, ",")), BlockAssertions.createBooleansBlock(Collections.nCopies(3, true)), BlockAssertions.createStringsBlock(Collections.nCopies(3, "...")), BlockAssertions.createBooleansBlock(Collections.nCopies(3, true)));
    }

    @Test
    public void testOneValue() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN}), (Object)"value", BlockAssertions.createStringsBlock("value"), BlockAssertions.createStringsBlock(","), BlockAssertions.createBooleansBlock(true), BlockAssertions.createStringsBlock("..."), BlockAssertions.createBooleansBlock(false));
    }

    @Test
    public void testTwoValues() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN}), (Object)"value1,value2", BlockAssertions.createStringsBlock("value1", "value2"), BlockAssertions.createStringsBlock(Collections.nCopies(2, ",")), BlockAssertions.createBooleansBlock(Collections.nCopies(2, true)), BlockAssertions.createStringsBlock(Collections.nCopies(2, "...")), BlockAssertions.createBooleansBlock(Collections.nCopies(2, true)));
    }

    @Test
    public void testTwoValuesMixedWithNullValues() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN}), (Object)"value1,value2", BlockAssertions.createStringsBlock(null, "value1", null, "value2", null), BlockAssertions.createStringsBlock(Collections.nCopies(5, ",")), BlockAssertions.createBooleansBlock(Collections.nCopies(5, true)), BlockAssertions.createStringsBlock(Collections.nCopies(5, "...")), BlockAssertions.createBooleansBlock(Collections.nCopies(5, true)));
    }

    @Test
    public void testTwoValuesWithDefaultDelimiter() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN}), (Object)"value1value2", BlockAssertions.createStringsBlock("value1", "value2"), BlockAssertions.createStringsBlock(Collections.nCopies(2, "")), BlockAssertions.createBooleansBlock(Collections.nCopies(2, true)), BlockAssertions.createStringsBlock(Collections.nCopies(2, "...")), BlockAssertions.createBooleansBlock(Collections.nCopies(2, true)));
    }
}

