/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.util.StructuralTestUtil;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestTypedHistogram {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();

    @Test
    public void testMassive() {
        TestTypedHistogram.testMassive(false, (Type)BigintType.BIGINT, (arg_0, arg_1) -> ((BigintType)BigintType.BIGINT).writeLong(arg_0, arg_1));
        TestTypedHistogram.testMassive(false, (Type)VarcharType.VARCHAR, (blockBuilder, value) -> VarcharType.VARCHAR.writeString(blockBuilder, String.valueOf(value)));
        TestTypedHistogram.testMassive(true, (Type)BigintType.BIGINT, (arg_0, arg_1) -> ((BigintType)BigintType.BIGINT).writeLong(arg_0, arg_1));
        TestTypedHistogram.testMassive(true, (Type)VarcharType.VARCHAR, (blockBuilder, value) -> VarcharType.VARCHAR.writeString(blockBuilder, String.valueOf(value)));
    }

    private static void testMassive(boolean grouped, Type type, ObjIntConsumer<BlockBuilder> writeData) {
        BlockBuilder inputBlockBuilder = type.createBlockBuilder(null, 5000);
        IntStream.range(1, 2000).flatMap(value -> IntStream.iterate(value, IntUnaryOperator.identity()).limit(value)).forEach(value -> writeData.accept(inputBlockBuilder, value));
        Block inputBlock = inputBlockBuilder.build();
        TypedHistogram typedHistogram = new TypedHistogram(type, TYPE_OPERATORS.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT})), TYPE_OPERATORS.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT})), TYPE_OPERATORS.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), grouped);
        int groupId = 0;
        if (grouped) {
            groupId = 10;
            typedHistogram.setMaxGroupId(groupId);
        }
        for (int i = 0; i < inputBlock.getPositionCount(); ++i) {
            typedHistogram.add(groupId, inputBlock, i, 1L);
        }
        MapType mapType = StructuralTestUtil.mapType(type, (Type)BigintType.BIGINT);
        MapBlockBuilder actualBuilder = mapType.createBlockBuilder(null, 1);
        typedHistogram.serialize(groupId, actualBuilder);
        Block actualBlock = actualBuilder.build();
        MapBlockBuilder expectedBuilder = mapType.createBlockBuilder(null, 1);
        expectedBuilder.buildEntry((keyBuilder, valueBuilder) -> IntStream.range(1, 2000).forEach(value -> {
            writeData.accept(keyBuilder, value);
            BigintType.BIGINT.writeLong(valueBuilder, (long)value);
        }));
        Block expectedBlock = expectedBuilder.build();
        BlockAssertions.assertBlockEquals((Type)mapType, actualBlock, expectedBlock);
        Assert.assertEquals((int)typedHistogram.size(), (int)1999);
        if (grouped) {
            actualBuilder = mapType.createBlockBuilder(null, 1);
            typedHistogram.serialize(3, actualBuilder);
            actualBlock = actualBuilder.build();
            Assertions.assertThat((int)actualBlock.getPositionCount()).isEqualTo(1);
            Assertions.assertThat((boolean)actualBlock.isNull(0)).isTrue();
        }
    }
}

