/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.array.BlockBigArray;
import io.trino.array.BooleanBigArray;
import io.trino.array.ByteBigArray;
import io.trino.array.DoubleBigArray;
import io.trino.array.IntBigArray;
import io.trino.array.LongBigArray;
import io.trino.array.ReferenceCountMap;
import io.trino.array.SliceBigArray;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.operator.aggregation.state.VarianceState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import io.trino.util.StructuralTestUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestStateCompiler {
    @Test
    public void testPrimitiveNullableLongSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(NullableLongState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(NullableLongState.class);
        NullableLongState state = (NullableLongState)factory.createSingleState();
        NullableLongState deserializedState = (NullableLongState)factory.createSingleState();
        state.setValue(2L);
        state.setNull(false);
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 2);
        serializer.serialize((AccumulatorState)state, builder);
        state.setNull(true);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        Assert.assertFalse((boolean)block.isNull(0));
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 0), (long)state.getValue());
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((long)deserializedState.getValue(), (long)state.getValue());
        Assert.assertTrue((boolean)block.isNull(1));
    }

    @Test
    public void testPrimitiveLongSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(LongState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(LongState.class);
        LongState state = (LongState)factory.createSingleState();
        LongState deserializedState = (LongState)factory.createSingleState();
        state.setValue(2L);
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 0), (long)state.getValue());
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((long)deserializedState.getValue(), (long)state.getValue());
    }

    @Test
    public void testGetSerializedType() {
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(LongState.class);
        Assert.assertEquals((Object)serializer.getSerializedType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testPrimitiveBooleanSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(BooleanState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(BooleanState.class);
        BooleanState state = (BooleanState)factory.createSingleState();
        BooleanState deserializedState = (BooleanState)factory.createSingleState();
        state.setBoolean(true);
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((boolean)deserializedState.isBoolean(), (boolean)state.isBoolean());
    }

    @Test
    public void testPrimitiveByteSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(ByteState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(ByteState.class);
        ByteState state = (ByteState)factory.createSingleState();
        ByteState deserializedState = (ByteState)factory.createSingleState();
        state.setByte((byte)3);
        BlockBuilder builder = TinyintType.TINYINT.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((byte)deserializedState.getByte(), (byte)state.getByte());
    }

    @Test
    public void testNonPrimitiveSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(SliceState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(SliceState.class);
        SliceState state = (SliceState)factory.createSingleState();
        SliceState deserializedState = (SliceState)factory.createSingleState();
        state.setSlice(null);
        VariableWidthBlockBuilder nullBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, (BlockBuilder)nullBlockBuilder);
        Block nullBlock = nullBlockBuilder.build();
        serializer.deserialize(nullBlock, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((Object)deserializedState.getSlice(), (Object)state.getSlice());
        state.setSlice(Slices.utf8Slice((String)"test"));
        VariableWidthBlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, (BlockBuilder)builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((Object)deserializedState.getSlice(), (Object)state.getSlice());
    }

    @Test
    public void testVarianceStateSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(VarianceState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(VarianceState.class);
        VarianceState singleState = (VarianceState)factory.createSingleState();
        VarianceState deserializedState = (VarianceState)factory.createSingleState();
        singleState.setMean(1.0);
        singleState.setCount(2L);
        singleState.setM2(3.0);
        RowBlockBuilder builder = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)).createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)singleState, (BlockBuilder)builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((long)deserializedState.getCount(), (long)singleState.getCount());
        Assert.assertEquals((Object)deserializedState.getMean(), (Object)singleState.getMean());
        Assert.assertEquals((Object)deserializedState.getM2(), (Object)singleState.getM2());
    }

    @Test
    public void testComplexSerialization() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR);
        ImmutableMap fieldMap = ImmutableMap.of((Object)"Block", (Object)arrayType, (Object)"AnotherBlock", (Object)mapType);
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(TestComplexState.class, (Map)fieldMap);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(TestComplexState.class, (Map)fieldMap);
        TestComplexState singleState = (TestComplexState)factory.createSingleState();
        TestComplexState deserializedState = (TestComplexState)factory.createSingleState();
        singleState.setBoolean(true);
        singleState.setLong(1L);
        singleState.setDouble(2.0);
        singleState.setByte((byte)3);
        singleState.setInt(4);
        singleState.setSlice(Slices.utf8Slice((String)"test"));
        singleState.setAnotherSlice(TestStateCompiler.toSlice(1.0, 2.0, 3.0));
        singleState.setYetAnotherSlice(null);
        Block array = BlockAssertions.createLongsBlock(45);
        singleState.setBlock(array);
        singleState.setAnotherBlock(StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)123L, (Object)"testBlock")));
        RowBlockBuilder builder = RowType.anonymous((List)ImmutableList.of((Object)mapType, (Object)VarbinaryType.VARBINARY, (Object)arrayType, (Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY)).createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)singleState, (BlockBuilder)builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assert.assertEquals((boolean)deserializedState.getBoolean(), (boolean)singleState.getBoolean());
        Assert.assertEquals((long)deserializedState.getLong(), (long)singleState.getLong());
        Assert.assertEquals((Object)deserializedState.getDouble(), (Object)singleState.getDouble());
        Assert.assertEquals((byte)deserializedState.getByte(), (byte)singleState.getByte());
        Assert.assertEquals((int)deserializedState.getInt(), (int)singleState.getInt());
        Assert.assertEquals((Object)deserializedState.getSlice(), (Object)singleState.getSlice());
        Assert.assertEquals((Object)deserializedState.getAnotherSlice(), (Object)singleState.getAnotherSlice());
        Assert.assertEquals((Object)deserializedState.getYetAnotherSlice(), (Object)singleState.getYetAnotherSlice());
        Assert.assertEquals((long)deserializedState.getBlock().getLong(0, 0), (long)singleState.getBlock().getLong(0, 0));
        Assert.assertEquals((long)deserializedState.getAnotherBlock().getLong(0, 0), (long)singleState.getAnotherBlock().getLong(0, 0));
        Assert.assertEquals((Object)deserializedState.getAnotherBlock().getSlice(1, 0, 9), (Object)singleState.getAnotherBlock().getSlice(1, 0, 9));
    }

    private static long getComplexStateRetainedSize(TestComplexState state) {
        long retainedSize = SizeOf.instanceSize(state.getClass());
        Field[] fields = state.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                Class<?> type = field.getType();
                field.setAccessible(true);
                if (type != BlockBigArray.class && type != BooleanBigArray.class && type != SliceBigArray.class && type != ByteBigArray.class && type != DoubleBigArray.class && type != LongBigArray.class && type != IntBigArray.class) continue;
                MethodHandle sizeOf = Reflection.methodHandle(type, (String)"sizeOf", (Class[])new Class[0]);
                retainedSize += ((Long)sizeOf.invokeWithArguments(field.get(state))).longValue();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return retainedSize;
    }

    private static long getReferenceCountMapOverhead(TestComplexState state) {
        long overhead = 0L;
        Field[] stateFields = state.getClass().getDeclaredFields();
        try {
            for (Field stateField : stateFields) {
                Field[] bigArrayFields;
                if (stateField.getType() != BlockBigArray.class && stateField.getType() != SliceBigArray.class) continue;
                stateField.setAccessible(true);
                for (Field bigArrayField : bigArrayFields = stateField.getType().getDeclaredFields()) {
                    if (bigArrayField.getType() != ReferenceCountMap.class) continue;
                    bigArrayField.setAccessible(true);
                    MethodHandle sizeOf = Reflection.methodHandle(bigArrayField.getType(), (String)"sizeOf", (Class[])new Class[0]);
                    overhead += ((Long)sizeOf.invokeWithArguments(bigArrayField.get(stateField.get(state)))).longValue();
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return overhead;
    }

    @Test
    public void testComplexStateEstimatedSize() {
        Block map;
        MapBlockBuilder mapBlockBuilder;
        Block array;
        Slice slice;
        long retainedSize;
        int i;
        ImmutableMap fieldMap = ImmutableMap.of((Object)"Block", (Object)new ArrayType((Type)BigintType.BIGINT), (Object)"AnotherBlock", (Object)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR));
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(TestComplexState.class, (Map)fieldMap);
        TestComplexState groupedState = (TestComplexState)factory.createGroupedState();
        long initialRetainedSize = TestStateCompiler.getComplexStateRetainedSize(groupedState);
        Assert.assertEquals((long)groupedState.getEstimatedSize(), (long)initialRetainedSize);
        initialRetainedSize -= TestStateCompiler.getReferenceCountMapOverhead(groupedState);
        for (i = 0; i < 1000; ++i) {
            retainedSize = 0L;
            ((GroupedAccumulatorState)groupedState).setGroupId((long)i);
            groupedState.setBoolean(true);
            groupedState.setLong(1L);
            groupedState.setDouble(2.0);
            groupedState.setByte((byte)3);
            groupedState.setInt(4);
            slice = Slices.utf8Slice((String)"test");
            retainedSize += slice.getRetainedSize();
            groupedState.setSlice(slice);
            slice = TestStateCompiler.toSlice(1.0, 2.0, 3.0);
            retainedSize += slice.getRetainedSize();
            groupedState.setAnotherSlice(slice);
            groupedState.setYetAnotherSlice(null);
            array = BlockAssertions.createLongsBlock(45);
            retainedSize += array.getRetainedSizeInBytes();
            groupedState.setBlock(array);
            mapBlockBuilder = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR).createBlockBuilder(null, 1);
            mapBlockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
                BigintType.BIGINT.writeLong(keyBuilder, 123L);
                VarcharType.VARCHAR.writeSlice(valueBuilder, Slices.utf8Slice((String)"testBlock"));
            });
            map = mapBlockBuilder.build();
            groupedState.setAnotherBlock(map);
            Assert.assertEquals((long)groupedState.getEstimatedSize(), (long)(initialRetainedSize + (retainedSize += map.getRetainedSizeInBytes()) * (long)(i + 1) + TestStateCompiler.getReferenceCountMapOverhead(groupedState)));
        }
        for (i = 0; i < 1000; ++i) {
            retainedSize = 0L;
            ((GroupedAccumulatorState)groupedState).setGroupId((long)i);
            groupedState.setBoolean(true);
            groupedState.setLong(1L);
            groupedState.setDouble(2.0);
            groupedState.setByte((byte)3);
            groupedState.setInt(4);
            slice = Slices.utf8Slice((String)"test");
            retainedSize += slice.getRetainedSize();
            groupedState.setSlice(slice);
            slice = TestStateCompiler.toSlice(1.0, 2.0, 3.0);
            retainedSize += slice.getRetainedSize();
            groupedState.setAnotherSlice(slice);
            groupedState.setYetAnotherSlice(null);
            array = BlockAssertions.createLongsBlock(45);
            retainedSize += array.getRetainedSizeInBytes();
            groupedState.setBlock(array);
            mapBlockBuilder = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR).createBlockBuilder(null, 1);
            mapBlockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
                BigintType.BIGINT.writeLong(keyBuilder, 123L);
                VarcharType.VARCHAR.writeSlice(valueBuilder, Slices.utf8Slice((String)"testBlock"));
            });
            map = mapBlockBuilder.build();
            groupedState.setAnotherBlock(map);
            Assert.assertEquals((long)groupedState.getEstimatedSize(), (long)(initialRetainedSize + (retainedSize += map.getRetainedSizeInBytes()) * 1000L + TestStateCompiler.getReferenceCountMapOverhead(groupedState)));
        }
    }

    private static Slice toSlice(double ... values) {
        Slice slice = Slices.allocate((int)(values.length * 8));
        SliceOutput output = slice.getOutput();
        for (double value : values) {
            output.writeDouble(value);
        }
        return slice;
    }

    public static interface BooleanState
    extends AccumulatorState {
        public boolean isBoolean();

        public void setBoolean(boolean var1);
    }

    public static interface ByteState
    extends AccumulatorState {
        public byte getByte();

        public void setByte(byte var1);
    }

    public static interface SliceState
    extends AccumulatorState {
        public Slice getSlice();

        public void setSlice(Slice var1);
    }

    public static interface TestComplexState
    extends AccumulatorState {
        public double getDouble();

        public void setDouble(double var1);

        public boolean getBoolean();

        public void setBoolean(boolean var1);

        public long getLong();

        public void setLong(long var1);

        public byte getByte();

        public void setByte(byte var1);

        public int getInt();

        public void setInt(int var1);

        public Slice getSlice();

        public void setSlice(Slice var1);

        public Slice getAnotherSlice();

        public void setAnotherSlice(Slice var1);

        public Slice getYetAnotherSlice();

        public void setYetAnotherSlice(Slice var1);

        public Block getBlock();

        public void setBlock(Block var1);

        public Block getAnotherBlock();

        public void setAnotherBlock(Block var1);
    }
}

