/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.operator.output.SlicePositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import org.junit.jupiter.api.Test;
import org.testng.internal.junit.ArrayAsserts;

public class TestSlicePositionsAppender {
    @Test
    public void testAppendEmptySliceRle() {
        SlicePositionsAppender positionsAppender = new SlicePositionsAppender(1, 100);
        Block value = BlockAssertions.createStringsBlock("");
        positionsAppender.appendRle(value, 10);
        Block actualBlock = positionsAppender.build();
        BlockAssertions.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, RunLengthEncodedBlock.create((Block)value, (int)10));
    }

    @Test
    public void testDuplicateZeroLength() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[0]);
        byte[] target = new byte[]{-1};
        SlicePositionsAppender.duplicateBytes((Slice)slice, (byte[])target, (int)0, (int)100);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{-1}, (byte[])target);
    }

    @Test
    public void testDuplicate1Byte() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[]{2});
        byte[] target = new byte[5];
        Arrays.fill(target, (byte)-1);
        SlicePositionsAppender.duplicateBytes((Slice)slice, (byte[])target, (int)3, (int)2);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{-1, -1, -1, 2, 2}, (byte[])target);
    }

    @Test
    public void testDuplicate2Bytes() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[]{1, 2});
        byte[] target = new byte[8];
        Arrays.fill(target, (byte)-1);
        SlicePositionsAppender.duplicateBytes((Slice)slice, (byte[])target, (int)1, (int)3);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{-1, 1, 2, 1, 2, 1, 2, -1}, (byte[])target);
    }

    @Test
    public void testDuplicate1Time() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[]{1, 2});
        byte[] target = new byte[8];
        Arrays.fill(target, (byte)-1);
        SlicePositionsAppender.duplicateBytes((Slice)slice, (byte[])target, (int)1, (int)1);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{-1, 1, 2, -1, -1, -1, -1, -1}, (byte[])target);
    }

    @Test
    public void testDuplicateMultipleBytesOffNumberOfTimes() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[]{5, 3, 1});
        byte[] target = new byte[17];
        Arrays.fill(target, (byte)-1);
        SlicePositionsAppender.duplicateBytes((Slice)slice, (byte[])target, (int)1, (int)5);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{-1, 5, 3, 1, 5, 3, 1, 5, 3, 1, 5, 3, 1, 5, 3, 1, -1}, (byte[])target);
    }

    @Test
    public void testDuplicateMultipleBytesEvenNumberOfTimes() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[]{5, 3, 1});
        byte[] target = new byte[20];
        Arrays.fill(target, (byte)-1);
        SlicePositionsAppender.duplicateBytes((Slice)slice, (byte[])target, (int)1, (int)6);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{-1, 5, 3, 1, 5, 3, 1, 5, 3, 1, 5, 3, 1, 5, 3, 1, 5, 3, 1, -1}, (byte[])target);
    }

    @Test
    public void testDuplicateMultipleBytesPowerOfTwoNumberOfTimes() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[]{5, 3, 1});
        byte[] target = new byte[14];
        Arrays.fill(target, (byte)-1);
        SlicePositionsAppender.duplicateBytes((Slice)slice, (byte[])target, (int)1, (int)4);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{-1, 5, 3, 1, 5, 3, 1, 5, 3, 1, 5, 3, 1, -1}, (byte[])target);
    }
}

