/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.project.DictionaryAwarePageFilter;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.PageFilter;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestDictionaryAwarePageFilter {
    @Test
    public void testDelegateMethods() {
        DictionaryAwarePageFilter filter = new DictionaryAwarePageFilter((PageFilter)new TestDictionaryFilter(true));
        Assert.assertEquals((boolean)filter.isDeterministic(), (boolean)true);
        Assert.assertEquals((Collection)filter.getInputChannels().getInputChannels(), (Collection)ImmutableList.of((Object)3));
    }

    @Test
    public void testSimpleBlock() {
        Block block = BlockAssertions.createLongSequenceBlock(0, 100);
        TestDictionaryAwarePageFilter.testFilter(block, LongArrayBlock.class);
    }

    @Test
    public void testRleBlock() {
        TestDictionaryAwarePageFilter.testRleBlock(true);
        TestDictionaryAwarePageFilter.testRleBlock(false);
    }

    private static void testRleBlock(boolean filterRange) {
        DictionaryAwarePageFilter filter = TestDictionaryAwarePageFilter.createDictionaryAwarePageFilter(filterRange, LongArrayBlock.class);
        RunLengthEncodedBlock match = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)BlockAssertions.createLongSequenceBlock(4, 5), (int)100);
        TestDictionaryAwarePageFilter.testFilter(filter, (Block)match, filterRange);
        RunLengthEncodedBlock noMatch = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)BlockAssertions.createLongSequenceBlock(0, 1), (int)100);
        TestDictionaryAwarePageFilter.testFilter(filter, (Block)noMatch, filterRange);
    }

    @Test
    public void testRleBlockWithFailure() {
        DictionaryAwarePageFilter filter = TestDictionaryAwarePageFilter.createDictionaryAwarePageFilter(true, LongArrayBlock.class);
        RunLengthEncodedBlock fail = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)BlockAssertions.createLongSequenceBlock(-10, -9), (int)100);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwarePageFilter.testFilter(filter, (Block)fail, true)).isInstanceOf(NegativeValueException.class)).hasMessage("value is negative: -10");
    }

    @Test
    public void testDictionaryBlock() {
        TestDictionaryAwarePageFilter.testFilter(TestDictionaryAwarePageFilter.createDictionaryBlock(20, 100), LongArrayBlock.class);
        TestDictionaryAwarePageFilter.testFilter(TestDictionaryAwarePageFilter.createDictionaryBlock(20, 0), LongArrayBlock.class);
        TestDictionaryAwarePageFilter.testFilter(DictionaryBlock.create((int)100, (Block)BlockAssertions.createLongSequenceBlock(4, 5), (int[])new int[100]), LongArrayBlock.class);
    }

    @Test
    public void testDictionaryBlockWithFailure() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDictionaryAwarePageFilter.testFilter(TestDictionaryAwarePageFilter.createDictionaryBlockWithFailure(20, 100), LongArrayBlock.class)).isInstanceOf(NegativeValueException.class)).hasMessage("value is negative: -10");
    }

    @Test
    public void testDictionaryBlockProcessingWithUnusedFailure() {
        TestDictionaryAwarePageFilter.testFilter(TestDictionaryAwarePageFilter.createDictionaryBlockWithUnusedEntries(20, 100), DictionaryBlock.class);
        TestDictionaryAwarePageFilter.testFilter(TestDictionaryAwarePageFilter.createDictionaryBlockWithUnusedEntries(20, 2), DictionaryBlock.class);
        TestDictionaryAwarePageFilter.testFilter(DictionaryBlock.create((int)100, (Block)BlockAssertions.createLongsBlock(4, 5, -1), (int[])new int[100]), DictionaryBlock.class);
    }

    @Test
    public void testDictionaryProcessingEnableDisable() {
        TestDictionaryFilter nestedFilter = new TestDictionaryFilter(true);
        DictionaryAwarePageFilter filter = new DictionaryAwarePageFilter((PageFilter)nestedFilter);
        Block ineffectiveBlock = TestDictionaryAwarePageFilter.createDictionaryBlock(100, 20);
        Block effectiveBlock = TestDictionaryAwarePageFilter.createDictionaryBlock(10, 100);
        Block anotherIneffectiveBlock = TestDictionaryAwarePageFilter.createDictionaryBlock(100, 25);
        nestedFilter.setExpectedType(LongArrayBlock.class);
        TestDictionaryAwarePageFilter.testFilter(filter, ineffectiveBlock, true);
        nestedFilter.setExpectedType(DictionaryBlock.class);
        TestDictionaryAwarePageFilter.testFilter(filter, anotherIneffectiveBlock, true);
        for (int i = 0; i < 5; ++i) {
            TestDictionaryAwarePageFilter.testFilter(filter, anotherIneffectiveBlock, true);
        }
        nestedFilter.setExpectedType(LongArrayBlock.class);
        TestDictionaryAwarePageFilter.testFilter(filter, ineffectiveBlock, true);
        nestedFilter.setExpectedType(LongArrayBlock.class);
        TestDictionaryAwarePageFilter.testFilter(filter, effectiveBlock, true);
    }

    private static Block createDictionaryBlock(int dictionarySize, int blockSize) {
        Block dictionary = BlockAssertions.createLongSequenceBlock(0, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block createDictionaryBlockWithFailure(int dictionarySize, int blockSize) {
        Block dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize - 10);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block createDictionaryBlockWithUnusedEntries(int dictionarySize, int blockSize) {
        Block dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize + 10);
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static void testFilter(Block block, Class<? extends Block> expectedType) {
        TestDictionaryAwarePageFilter.testFilter(block, true, expectedType);
        TestDictionaryAwarePageFilter.testFilter(block, false, expectedType);
        TestDictionaryAwarePageFilter.testFilter((Block)TestDictionaryAwarePageFilter.lazyWrapper(block), true, expectedType);
        TestDictionaryAwarePageFilter.testFilter((Block)TestDictionaryAwarePageFilter.lazyWrapper(block), false, expectedType);
    }

    private static void testFilter(Block block, boolean filterRange, Class<? extends Block> expectedType) {
        DictionaryAwarePageFilter filter = TestDictionaryAwarePageFilter.createDictionaryAwarePageFilter(filterRange, expectedType);
        TestDictionaryAwarePageFilter.testFilter(filter, block, filterRange);
        TestDictionaryAwarePageFilter.testFilter(filter, block, filterRange);
    }

    private static DictionaryAwarePageFilter createDictionaryAwarePageFilter(boolean filterRange, Class<? extends Block> expectedType) {
        return new DictionaryAwarePageFilter((PageFilter)new TestDictionaryFilter(filterRange, expectedType));
    }

    private static void testFilter(DictionaryAwarePageFilter filter, Block block, boolean filterRange) {
        IntSet actualSelectedPositions = TestDictionaryAwarePageFilter.toSet(filter.filter(null, new Page(new Block[]{block})));
        block = block.getLoadedBlock();
        IntArraySet expectedSelectedPositions = new IntArraySet(block.getPositionCount());
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!TestDictionaryAwarePageFilter.isSelected(filterRange, block.getLong(position, 0))) continue;
            expectedSelectedPositions.add(position);
        }
        Assert.assertEquals((Set)actualSelectedPositions, (Set)expectedSelectedPositions);
    }

    private static IntSet toSet(SelectedPositions selectedPositions) {
        int start = selectedPositions.getOffset();
        int end = start + selectedPositions.size();
        if (selectedPositions.isList()) {
            return new IntArraySet(Arrays.copyOfRange(selectedPositions.getPositions(), start, end));
        }
        return new IntArraySet(IntStream.range(start, end).toArray());
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> block);
    }

    private static boolean isSelected(boolean filterRange, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value is negative: " + value);
        }
        boolean selected = filterRange ? value > 3L && value < 11L : value % 3L == 1L;
        return selected;
    }

    private static class TestDictionaryFilter
    implements PageFilter {
        private final boolean filterRange;
        private Class<? extends Block> expectedType;

        public TestDictionaryFilter(boolean filterRange) {
            this.filterRange = filterRange;
        }

        public TestDictionaryFilter(boolean filterRange, Class<? extends Block> expectedType) {
            this.filterRange = filterRange;
            this.expectedType = expectedType;
        }

        public void setExpectedType(Class<? extends Block> expectedType) {
            this.expectedType = expectedType;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{3});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            Assert.assertEquals((int)page.getChannelCount(), (int)1);
            Block block = page.getBlock(0);
            boolean sequential = true;
            IntArrayList selectedPositions = new IntArrayList();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                long value = block.getLong(position, 0);
                TestDictionaryFilter.verifyPositive(value);
                boolean selected = TestDictionaryAwarePageFilter.isSelected(this.filterRange, value);
                if (!selected) continue;
                if (sequential && !selectedPositions.isEmpty()) {
                    sequential = position == selectedPositions.getInt(selectedPositions.size() - 1) + 1;
                }
                selectedPositions.add(position);
            }
            io.airlift.testing.Assertions.assertInstanceOf((Object)block, this.expectedType);
            if (selectedPositions.isEmpty()) {
                return SelectedPositions.positionsRange((int)0, (int)0);
            }
            if (sequential) {
                return SelectedPositions.positionsRange((int)selectedPositions.getInt(0), (int)selectedPositions.size());
            }
            for (int i = 0; i < 3; ++i) {
                selectedPositions.add(0, -1);
                selectedPositions.add(-1);
            }
            return SelectedPositions.positionsList((int[])selectedPositions.elements(), (int)3, (int)(selectedPositions.size() - 6));
        }

        private static long verifyPositive(long value) {
            if (value < 0L) {
                throw new NegativeValueException(value);
            }
            return value;
        }
    }

    private static class NegativeValueException
    extends RuntimeException {
        public NegativeValueException(long value) {
            super("value is negative: " + value);
        }
    }
}

