/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.ColorFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestColorFunctions {
    @Test
    public void testParseRgb() {
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#000")), (int)0);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#FFF")), (int)0xFFFFFF);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#F00")), (int)0xFF0000);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#0F0")), (int)65280);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#00F")), (int)255);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#700")), (int)0x770000);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#070")), (int)30464);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#007")), (int)119);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#cde")), (int)0xCCDDEE);
    }

    @Test
    public void testGetComponent() {
        Assert.assertEquals((int)ColorFunctions.getRed((long)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#789"))), (int)119);
        Assert.assertEquals((int)ColorFunctions.getGreen((long)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#789"))), (int)136);
        Assert.assertEquals((int)ColorFunctions.getBlue((long)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#789"))), (int)153);
    }

    @Test
    public void testToRgb() {
        Assert.assertEquals((long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.rgb((long)0L, (long)255L, (long)0L), (long)65280L);
        Assert.assertEquals((long)ColorFunctions.rgb((long)0L, (long)0L, (long)255L), (long)255L);
    }

    @Test
    public void testColor() {
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"black")), (long)-1L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red")), (long)-2L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"green")), (long)-3L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"yellow")), (long)-4L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"blue")), (long)-5L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"magenta")), (long)-6L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"cyan")), (long)-7L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"white")), (long)-8L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00")), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0")), (long)65280L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f")), (long)255L);
    }

    @Test
    public void testBar() {
        Assert.assertEquals((Object)ColorFunctions.bar((double)0.6, (long)5L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f0f")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;201m\u2588\u001b[38;5;165m\u2588\u001b[38;5;129m\u2588\u001b[0m  "));
        Assert.assertEquals((Object)ColorFunctions.bar((double)1.0, (long)10L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;196m\u2588\u001b[38;5;202m\u2588\u001b[38;5;208m\u2588\u001b[38;5;214m\u2588\u001b[38;5;226m\u2588\u001b[38;5;226m\u2588\u001b[38;5;154m\u2588\u001b[38;5;118m\u2588\u001b[38;5;82m\u2588\u001b[38;5;46m\u2588\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.bar((double)0.6, (long)5L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f0f")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;201m\u2588\u001b[38;5;165m\u2588\u001b[38;5;129m\u2588\u001b[0m  "));
    }

    @Test
    public void testRenderBoolean() {
        Assert.assertEquals((Object)ColorFunctions.render((boolean)true), (Object)Slices.utf8Slice((String)"\u001b[38;5;2m\u2713\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((boolean)false), (Object)Slices.utf8Slice((String)"\u001b[38;5;1m\u2717\u001b[0m"));
    }

    @Test
    public void testRenderString() {
        Assert.assertEquals((Object)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;1mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;196mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;46mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;21mhello\u001b[0m"));
    }

    @Test
    public void testRenderLong() {
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;1m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;196m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;46m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;21m1234\u001b[0m"));
    }

    @Test
    public void testRenderDouble() {
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;1m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5677490234375, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red"))), (Object)Slices.utf8Slice((String)String.format("\u001b[38;5;1m%s\u001b[0m", 1234.5677490234375)));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;196m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;46m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f"))), (Object)Slices.utf8Slice((String)"\u001b[38;5;21m1234.5678\u001b[0m"));
    }

    @Test
    public void testInterpolate() {
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)128.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0x808080L);
        Assert.assertEquals((long)ColorFunctions.color((double)255.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)-1.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L)), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.color((double)47.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L)), (long)0xFF8000L);
        Assert.assertEquals((long)ColorFunctions.color((double)142.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L)), (long)0xFFFF00L);
        Assert.assertEquals((long)ColorFunctions.color((double)-42.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.5, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0x808080L);
        Assert.assertEquals((long)ColorFunctions.color((double)1.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)42.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)1.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)-0.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff"))), (long)0L);
    }

    @Test
    public void testIndeterminate() {
        try (QueryAssertions assertions = new QueryAssertions();){
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.operator(OperatorType.INDETERMINATE, "color(null)")))).isEqualTo(true);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.operator(OperatorType.INDETERMINATE, "color('black')")))).isEqualTo(false);
        }
    }
}

