/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.util.HashMap;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestMapTransformKeysFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEmpty() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> NULL)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> v)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> 0)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> true)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> 'key')").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k + CAST(v as BIGINT))").binding("a", "CAST(map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR))")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> v)").binding("a", "CAST(map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR))")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of());
    }

    @Test
    public void testNullKey() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> NULL)").binding("a", "map(ARRAY[1, 2, 3], ARRAY['a', 'b', 'c'])").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> v)").binding("a", "map(ARRAY[1, 2, 3], ARRAY['a', 'b', NULL])").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> k + v)").binding("a", "map(ARRAY[1, 2, 3], ARRAY[1, 2, NULL])").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> TRY_CAST(v as BIGINT))").binding("a", "map(ARRAY[1, 2, 3], ARRAY['1', '2', 'Invalid'])").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> element_at(map(ARRAY[1, 2], ARRAY['one', 'two']), k))").binding("a", "map(ARRAY[1, 2, 3], ARRAY[1.0E0, 1.4E0, 1.7E0])").evaluate()).hasMessage("map key cannot be null");
    }

    @Test
    public void testDuplicateKeys() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> k % 3)").binding("a", "map(ARRAY[1, 2, 3, 4], ARRAY['a', 'b', 'c', 'd'])").evaluate()).hasMessage("Duplicate map keys (1) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> k % 2 = 0)").binding("a", "map(ARRAY[1, 2, 3], ARRAY['a', 'b', 'c'])").evaluate()).hasMessage("Duplicate map keys (false) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> k - floor(k))").binding("a", "map(ARRAY[1.5E0, 2.5E0, 3.5E0], ARRAY['a', 'b', 'c'])").evaluate()).hasMessage("Duplicate map keys (0.5) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> v)").binding("a", "map(ARRAY[1, 2, 3, 4], ARRAY['a', 'b', 'c', 'b'])").evaluate()).hasMessage("Duplicate map keys (b) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> substr(k, 1, 3))").binding("a", "map(ARRAY['abc1', 'cba2', 'abc3'], ARRAY[1, 2, 3])").evaluate()).hasMessage("Duplicate map keys (abc) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> array_sort(k || v))").binding("a", "map(ARRAY[ARRAY[1], ARRAY[2]], ARRAY[2, 1])").evaluate()).hasMessage("Duplicate map keys ([1, 2]) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> DATE '2001-08-22')").binding("a", "map(ARRAY[1, 2], ARRAY[null, null])").evaluate()).hasMessage("Duplicate map keys (2001-08-22) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform_keys(a, (k, v) -> TIMESTAMP '2001-08-22 03:04:05.321')").binding("a", "map(ARRAY[1, 2], ARRAY[null, null])").evaluate()).hasMessage("Duplicate map keys (2001-08-22 03:04:05.321) are not allowed");
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k + v)").binding("a", "map(ARRAY[1, 2, 3, 4], ARRAY[10, 20, 30, 40])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)11, (Object)10, (Object)22, (Object)20, (Object)33, (Object)30, (Object)44, (Object)40));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> v * v)").binding("a", "map(ARRAY['a', 'b', 'c', 'd'], ARRAY[1, 2, 3, 4])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)1, (Object)4, (Object)2, (Object)9, (Object)3, (Object)16, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k || CAST(v as VARCHAR))").binding("a", "map(ARRAY['a', 'b', 'c', 'd'], ARRAY[1, 2, 3, 4])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"a1", (Object)1, (Object)"b2", (Object)2, (Object)"c3", (Object)3, (Object)"d4", (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> map(ARRAY[1, 2, 3], ARRAY['one', 'two', 'three'])[k])").binding("a", "map(ARRAY[1, 2, 3], ARRAY[1.0E0, 1.4E0, 1.7E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)5), (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)"one", (Object)1.0, (Object)"two", (Object)1.4, (Object)"three", (Object)1.7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> date_add('year', 1, k))").binding("a", "map(ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2010-05-10 12:34:56.123456789'], ARRAY[1, 2])")))).matches("map_from_entries(ARRAY[(TIMESTAMP '2021-05-10 12:34:56.123456789', 1), (TIMESTAMP '2011-05-10 12:34:56.123456789', 2)])");
        HashMap<String, Integer> expectedStringIntMap = new HashMap<String, Integer>();
        expectedStringIntMap.put("a1", 1);
        expectedStringIntMap.put("b0", null);
        expectedStringIntMap.put("c3", 3);
        expectedStringIntMap.put("d4", 4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k || COALESCE(CAST(v as VARCHAR), '0'))").binding("a", "map(ARRAY['a', 'b', 'c', 'd'], ARRAY[1, NULL, 3, 4])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)).isEqualTo(expectedStringIntMap);
    }

    @Test
    public void testTypeCombinations() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k + v)").binding("a", "map(ARRAY[25, 26, 27], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)50, (Object)25, (Object)52, (Object)26, (Object)54, (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k + v)").binding("a", "map(ARRAY[25, 26, 27], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)50.5, (Object)25.5, (Object)52.5, (Object)26.5, (Object)54.5, (Object)27.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k % 2 = 0 OR v)").binding("a", "map(ARRAY[25, 26], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> to_base(k, 16) || substr(v, 1, 1))").binding("a", "map(ARRAY[25, 26, 27], ARRAY['abc', 'def', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)"19a", (Object)"abc", (Object)"1ad", (Object)"def", (Object)"1bx", (Object)"xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> ARRAY[CAST(k AS VARCHAR)] || v)").binding("a", "map(ARRAY[25, 26], ARRAY[ARRAY['a'], ARRAY['b']])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)"25", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"26", (Object)"b"), (Object)ImmutableList.of((Object)"b")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> CAST(k * 2 AS BIGINT) + v)").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)76L, (Object)25, (Object)79L, (Object)26, (Object)82L, (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k + v)").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)51.0, (Object)25.5, (Object)53.0, (Object)26.5, (Object)55.0, (Object)27.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> CAST(k AS BIGINT) % 2 = 0 OR v)").binding("a", "map(ARRAY[25.2E0, 26.2E0], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> CAST(k AS VARCHAR) || substr(v, 1, 1))").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY['abc', 'def', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)"2.55E1a", (Object)"abc", (Object)"2.65E1d", (Object)"def", (Object)"2.75E1x", (Object)"xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> ARRAY[CAST(k AS VARCHAR)] || v)").binding("a", "map(ARRAY[25.5E0, 26.5E0], ARRAY[ARRAY['a'], ARRAY['b']])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)"2.55E1", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"2.65E1", (Object)"b"), (Object)ImmutableList.of((Object)"b")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> if(k, 2 * v, 3 * v))").binding("a", "map(ARRAY[true, false], ARRAY[25, 26])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)50, (Object)25, (Object)78, (Object)26));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> if(k, 2 * v, 3 * v))").binding("a", "map(ARRAY[false, true], ARRAY[25.5E0, 26.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)76.5, (Object)25.5, (Object)53.0, (Object)26.5));
        HashMap<Boolean, Boolean> expectedBoolBoolMap = new HashMap<Boolean, Boolean>();
        expectedBoolBoolMap.put(false, true);
        expectedBoolBoolMap.put(true, null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> if(k, NOT v, v IS NULL))").binding("a", "map(ARRAY[true, false], ARRAY[true, NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(expectedBoolBoolMap);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> if(k, substr(v, 1, 2), substr(v, 1, 1)))").binding("a", "map(ARRAY[false, true], ARRAY['abc', 'def'])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)"a", (Object)"abc", (Object)"de", (Object)"def"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> if(k, reverse(v), v))").binding("a", "map(ARRAY[true, false], ARRAY[ARRAY['a', 'b'], ARRAY['x', 'y']])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)"b", (Object)"a"), (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"x", (Object)"y"), (Object)ImmutableList.of((Object)"x", (Object)"y")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> length(k) + v)").binding("a", "map(ARRAY['a', 'ab', 'abc'], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)26L, (Object)25, (Object)28L, (Object)26, (Object)30L, (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> length(k) + v)").binding("a", "map(ARRAY['a', 'ab', 'abc'], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)26.5, (Object)25.5, (Object)28.5, (Object)26.5, (Object)30.5, (Object)27.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k = 'b' OR v)").binding("a", "map(ARRAY['a', 'b'], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k || v)").binding("a", "map(ARRAY['a', 'x'], ARRAY['bc', 'yz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.createVarcharType((int)2))).isEqualTo(ImmutableMap.of((Object)"abc", (Object)"bc", (Object)"xyz", (Object)"yz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> k || v)").binding("a", "map(ARRAY['x', 'y'], ARRAY[ARRAY['a'], ARRAY['b']])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)"x", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"y", (Object)"b"), (Object)ImmutableList.of((Object)"b")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> reduce(k, 0, (s, x) -> s + x, s -> s) + v)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[25, 26])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)28, (Object)25, (Object)33, (Object)26));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> reduce(k, 0, (s, x) -> s + x, s -> s) + v)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[25.5E0, 26.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)28.5, (Object)25.5, (Object)33.5, (Object)26.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> contains(k, 3) AND v)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> transform(k, x -> CAST(x AS VARCHAR)) || v)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY['abc', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"abc"), (Object)"abc", (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)"xyz"), (Object)"xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_keys(a, (k, v) -> transform(k, x -> CAST(x AS VARCHAR)) || v)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[ARRAY['a'], ARRAY['a', 'b']])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"a", (Object)"b")));
    }
}

