/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Collections;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestMathFunctions {
    private static final double[] DOUBLE_VALUES = new double[]{123.0, -123.0, 123.45, -123.45, 0.0};
    private static final int[] intLefts = new int[]{9, 10, 11, -9, -10, -11, 0};
    private static final int[] intRights = new int[]{3, -3};
    private static final double[] doubleLefts = new double[]{9.0, 10.0, 11.0, -9.0, -10.0, -11.0, 9.1, 10.1, 11.1, -9.1, -10.1, -11.1};
    private static final double[] doubleRights = new double[]{3.0, -3.0, 3.1, -3.1};
    private static final double GREATEST_DOUBLE_LESS_THAN_HALF = 0.49999999999999994;
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testAbs() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "TINYINT '123'")))).isEqualTo((byte)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "TINYINT '-123'")))).isEqualTo((byte)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "CAST(NULL AS TINYINT)")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "SMALLINT '123'")))).isEqualTo((short)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "SMALLINT '-123'")))).isEqualTo((short)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "CAST(NULL AS SMALLINT)")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "123")))).isEqualTo(123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "-123")))).isEqualTo(123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "CAST(NULL AS INTEGER)")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "BIGINT '123'")))).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "BIGINT '-123'")))).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "12300000000")))).isEqualTo(12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "-12300000000")))).isEqualTo(12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "CAST(NULL AS BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "123.0E0")))).isEqualTo(123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "-123.0E0")))).isEqualTo(123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "123.45E0")))).isEqualTo(123.45);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "-123.45E0")))).isEqualTo(123.45);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "CAST(NULL AS DOUBLE)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "REAL '-754.1985'")))).isEqualTo(Float.valueOf(754.1985f));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("abs", "TINYINT '%s'".formatted((byte)-128))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("abs", "SMALLINT '%s'".formatted((short)Short.MIN_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("abs", "INTEGER '%s'".formatted(Integer.MIN_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("abs", "-9223372036854775807 - if(rand() < 10, 1, 1)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "DECIMAL '123.45'")))).isEqualTo(SqlDecimal.decimal((String)"12345", (DecimalType)DecimalType.createDecimalType((int)5, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "DECIMAL '-123.45'")))).isEqualTo(SqlDecimal.decimal((String)"12345", (DecimalType)DecimalType.createDecimalType((int)5, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "DECIMAL '1234567890123456.78'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)18, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "DECIMAL '-1234567890123456.78'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)18, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "DECIMAL '12345678901234560.78'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456078", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "DECIMAL '-12345678901234560.78'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456078", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("abs", "CAST(NULL AS DECIMAL(1,0))")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
    }

    @Test
    public void testAcos() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("acos", Double.toString(doubleValue))))).isEqualTo(Math.acos(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("acos", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.acos((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("acos", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testAsin() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("asin", Double.toString(doubleValue))))).isEqualTo(Math.asin(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("asin", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.asin((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("asin", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testAtan() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan", Double.toString(doubleValue))))).isEqualTo(Math.atan(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.atan((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testAtan2() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan2", Double.toString(doubleValue), Double.toString(doubleValue))))).isEqualTo(Math.atan2(doubleValue, doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan2", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)), "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.atan2((float)doubleValue, (float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan2", "NULL", "NULL")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan2", "1.0E0", "NULL")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("atan2", "NULL", "1.0E0")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testCbrt() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cbrt", Double.toString(doubleValue))))).isEqualTo(Math.cbrt(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cbrt", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.cbrt((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cbrt", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testCeil() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "TINYINT '123'")))).isEqualTo((byte)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "TINYINT '-123'")))).isEqualTo((byte)-123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "CAST(NULL AS TINYINT)")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "SMALLINT '123'")))).isEqualTo((short)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "SMALLINT '-123'")))).isEqualTo((short)-123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "CAST(NULL AS SMALLINT)")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "123")))).isEqualTo(123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "-123")))).isEqualTo(-123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "CAST(NULL AS INTEGER)")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "BIGINT '123'")))).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "BIGINT '-123'")))).isEqualTo(-123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "12300000000")))).isEqualTo(12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "-12300000000")))).isEqualTo(-12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "CAST(NULL as BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "123.0E0")))).isEqualTo(123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "-123.0E0")))).isEqualTo(-123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "123.45E0")))).isEqualTo(124.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "-123.45E0")))).isEqualTo(-123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "CAST(NULL as DOUBLE)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "REAL '123.0'")))).isEqualTo(Float.valueOf(123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "REAL '-123.0'")))).isEqualTo(Float.valueOf(-123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "REAL '123.45'")))).isEqualTo(Float.valueOf(124.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceil", "REAL '-123.45'")))).isEqualTo(Float.valueOf(-123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "12300000000")))).isEqualTo(12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "-12300000000")))).isEqualTo(-12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(NULL AS BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "123.0E0")))).isEqualTo(123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "-123.0E0")))).isEqualTo(-123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "123.45E0")))).isEqualTo(124.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "-123.45E0")))).isEqualTo(-123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "REAL '123.0'")))).isEqualTo(Float.valueOf(123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "REAL '-123.0'")))).isEqualTo(Float.valueOf(-123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "REAL '123.45'")))).isEqualTo(Float.valueOf(124.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "REAL '-123.45'")))).isEqualTo(Float.valueOf(-123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '0.00' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '0.00' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '0.01' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-0.01' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '0.49' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-0.49' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '0.50' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-0.50' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '0.99' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-0.99' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123.00'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123.00'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123.01'")))).isEqualTo(SqlDecimal.decimal((String)"124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123.01'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123.45'")))).isEqualTo(SqlDecimal.decimal((String)"124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123.45'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123.49'")))).isEqualTo(SqlDecimal.decimal((String)"124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123.49'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123.50'")))).isEqualTo(SqlDecimal.decimal((String)"124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123.50'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123.99'")))).isEqualTo(SqlDecimal.decimal((String)"124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123.99'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '999.9'")))).isEqualTo(SqlDecimal.decimal((String)"1000", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '0000000000000000000' AS DECIMAL(19,0))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '000000000000000000.00' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '000000000000000000.01' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-000000000000000000.01' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '000000000000000000.49' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-000000000000000000.49' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '000000000000000000.50' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-000000000000000000.50' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '000000000000000000.99' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(DECIMAL '-000000000000000000.99' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123456789012345678.00'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123456789012345678.00'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123456789012345678.01'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123456789012345678.01'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123456789012345678.99'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123456789012345678.99'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123456789012345678.49'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123456789012345678.49'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '123456789012345678.50'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-123456789012345678.50'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '999999999999999999.9'")))).isEqualTo(SqlDecimal.decimal((String)"1000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '1234567890123456.78'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123457", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "DECIMAL '-1234567890123456.78'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(NULL AS DOUBLE)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(NULL AS REAL)")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(NULL AS DECIMAL(1,0))")))).isNull((Type)DecimalType.createDecimalType((int)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ceiling", "CAST(NULL AS DECIMAL(25,5))")))).isNull((Type)DecimalType.createDecimalType((int)21));
    }

    @Test
    public void testTruncate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "17.18E0")))).isEqualTo(17.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "-17.18E0")))).isEqualTo(-17.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "17.88E0")))).isEqualTo(17.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "-17.88E0")))).isEqualTo(-17.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "REAL '17.18'")))).isEqualTo(Float.valueOf(17.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "REAL '-17.18'")))).isEqualTo(Float.valueOf(-17.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "REAL '17.88'")))).isEqualTo(Float.valueOf(17.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "REAL '-17.88'")))).isEqualTo(Float.valueOf(-17.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DOUBLE '%s'".formatted(Double.MAX_VALUE))))).isEqualTo(Double.MAX_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DOUBLE '%s'".formatted(-1.7976931348623157E308))))).isEqualTo(-1.7976931348623157E308);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234'")))).isEqualTo(SqlDecimal.decimal((String)"1234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1234'")))).isEqualTo(SqlDecimal.decimal((String)"-1234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234.56'")))).isEqualTo(SqlDecimal.decimal((String)"1234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1234.56'")))).isEqualTo(SqlDecimal.decimal((String)"-1234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789123456.999'")))).isEqualTo(SqlDecimal.decimal((String)"123456789123456", (DecimalType)DecimalType.createDecimalType((int)15)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-123456789123456.999'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789123456", (DecimalType)DecimalType.createDecimalType((int)15)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1.99999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1.99999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234567890123456789012'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789012", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1234567890123456789012'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456789012", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234567890123456789012.999'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789012", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1234567890123456789012.999'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456789012", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234'", "1")))).isEqualTo(SqlDecimal.decimal((String)"1234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"1230", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234.56'", "1")))).isEqualTo(SqlDecimal.decimal((String)"1234.50", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234.56'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"1230.00", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1234.56'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-1234.50", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1239.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"1239.90", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1239.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-1239.90", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1239.999'", "2")))).isEqualTo(SqlDecimal.decimal((String)"1239.990", (DecimalType)DecimalType.createDecimalType((int)7, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1239.999'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"1200.000", (DecimalType)DecimalType.createDecimalType((int)7, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789123456.999'", "2")))).isEqualTo(SqlDecimal.decimal((String)"123456789123456.990", (DecimalType)DecimalType.createDecimalType((int)18, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789123456.999'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"123456789123400.000", (DecimalType)DecimalType.createDecimalType((int)18, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234'", "-4")))).isEqualTo(SqlDecimal.decimal((String)"0000", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234.56'", "-4")))).isEqualTo(SqlDecimal.decimal((String)"0000.00", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1234.56'", "-4")))).isEqualTo(SqlDecimal.decimal((String)"0000.00", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234.56'", "3")))).isEqualTo(SqlDecimal.decimal((String)"1234.56", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-1234.56'", "3")))).isEqualTo(SqlDecimal.decimal((String)"-1234.56", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234567890123456789012'", "1")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789012", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234567890123456789012'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789010", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234567890123456789012.23'", "1")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789012.20", (DecimalType)DecimalType.createDecimalType((int)24, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '1234567890123456789012.23'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789010.00", (DecimalType)DecimalType.createDecimalType((int)24, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789012345678999.99'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678990.00", (DecimalType)DecimalType.createDecimalType((int)23, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-123456789012345678999.99'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678990.00", (DecimalType)DecimalType.createDecimalType((int)23, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789012345678999.999'", "2")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678999.990", (DecimalType)DecimalType.createDecimalType((int)24, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789012345678999.999'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678900.000", (DecimalType)DecimalType.createDecimalType((int)24, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789012345678901'", "-21")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789012345678901.23'", "-21")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)23, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '123456789012345678901.23'", "3")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678901.23", (DecimalType)DecimalType.createDecimalType((int)23, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "DECIMAL '-123456789012345678901.23'", "3")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678901.23", (DecimalType)DecimalType.createDecimalType((int)23, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "CAST(NULL AS DOUBLE)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "CAST(NULL AS DECIMAL(1,0))", "-1")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "CAST(NULL AS DECIMAL(1,0))")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "CAST(NULL AS DECIMAL(18,5))")))).isNull((Type)DecimalType.createDecimalType((int)13, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "CAST(NULL AS DECIMAL(25,2))")))).isNull((Type)DecimalType.createDecimalType((int)23, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("truncate", "NULL", "NULL")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
    }

    @Test
    public void testCos() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cos", Double.toString(doubleValue))))).isEqualTo(Math.cos(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cos", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.cos((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cos", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testCosh() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosh", Double.toString(doubleValue))))).isEqualTo(Math.cosh(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosh", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.cosh((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosh", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testDegrees() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("degrees", Double.toString(doubleValue))))).isEqualTo(Math.toDegrees(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("degrees", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.toDegrees((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("degrees", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testE() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("e", new String[0])))).isEqualTo(Math.E);
    }

    @Test
    public void testExp() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("exp", Double.toString(doubleValue))))).isEqualTo(Math.exp(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("exp", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.exp((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("exp", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testFloor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "TINYINT '123'")))).isEqualTo((byte)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "TINYINT '-123'")))).isEqualTo((byte)-123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL AS TINYINT)")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "SMALLINT '123'")))).isEqualTo((short)123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "SMALLINT '-123'")))).isEqualTo((short)-123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL AS SMALLINT)")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "123")))).isEqualTo(123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "-123")))).isEqualTo(-123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL AS INTEGER)")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "BIGINT '123'")))).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "BIGINT '-123'")))).isEqualTo(-123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "12300000000")))).isEqualTo(12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "-12300000000")))).isEqualTo(-12300000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL as BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "123.0E0")))).isEqualTo(123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "-123.0E0")))).isEqualTo(-123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "123.45E0")))).isEqualTo(123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "-123.45E0")))).isEqualTo(-124.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "REAL '123.0'")))).isEqualTo(Float.valueOf(123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "REAL '-123.0'")))).isEqualTo(Float.valueOf(-123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "REAL '123.45'")))).isEqualTo(Float.valueOf(123.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "REAL '-123.45'")))).isEqualTo(Float.valueOf(-124.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '0.00' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '0.00' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '0.01' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-0.01' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '0.49' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-0.49' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '0.50' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-0.50' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '0.99' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-0.99' AS DECIMAL(3,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123.00'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123.00'")))).isEqualTo(SqlDecimal.decimal((String)"-123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123.01'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123.01'")))).isEqualTo(SqlDecimal.decimal((String)"-124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123.45'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123.45'")))).isEqualTo(SqlDecimal.decimal((String)"-124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123.49'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123.49'")))).isEqualTo(SqlDecimal.decimal((String)"-124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123.50'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123.50'")))).isEqualTo(SqlDecimal.decimal((String)"-124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123.99'")))).isEqualTo(SqlDecimal.decimal((String)"123", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123.99'")))).isEqualTo(SqlDecimal.decimal((String)"-124", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-999.9'")))).isEqualTo(SqlDecimal.decimal((String)"-1000", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '0000000000000000000' AS DECIMAL(19,0))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '000000000000000000.00' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '000000000000000000.01' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-000000000000000000.01' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '000000000000000000.49' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-000000000000000000.49' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '000000000000000000.50' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-000000000000000000.50' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '000000000000000000.99' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(DECIMAL '-000000000000000000.99' AS DECIMAL(20,2))")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123456789012345678.00'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123456789012345678.00'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123456789012345678.01'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123456789012345678.01'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123456789012345678.99'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123456789012345678.49'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123456789012345678.49'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123456789012345678.50'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '123456789012345678.50'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-123456789012345678.99'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345679", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-999999999999999999.9'")))).isEqualTo(SqlDecimal.decimal((String)"-1000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '1234567890123456.78'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "DECIMAL '-1234567890123456.78'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123457", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL as REAL)")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL as DOUBLE)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL as DECIMAL(1,0))")))).isNull((Type)DecimalType.createDecimalType((int)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("floor", "CAST(NULL as DECIMAL(25,5))")))).isNull((Type)DecimalType.createDecimalType((int)21));
    }

    @Test
    public void testLn() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ln", Double.toString(doubleValue))))).isEqualTo(Math.log(doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ln", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testLog2() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log2", Double.toString(doubleValue))))).isEqualTo(Math.log(doubleValue) / Math.log(2.0));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log2", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testLog10() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log10", Double.toString(doubleValue))))).isEqualTo(Math.log10(doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log10", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testLog() {
        for (double doubleValue : DOUBLE_VALUES) {
            for (double base : DOUBLE_VALUES) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log", Double.toString(base), Double.toString(doubleValue))))).isEqualTo(Math.log(doubleValue) / Math.log(base));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log", "REAL '%s'".formatted(Float.valueOf((float)base)), "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.log((float)doubleValue) / Math.log((float)base));
            }
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log", "NULL", "NULL")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log", "5.0E0", "NULL")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("log", "NULL", "5.0E0")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testMod() {
        long right;
        int right2;
        int n;
        int n2;
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '0.0'", "DECIMAL '2.0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        for (int left : intLefts) {
            int[] nArray = intRights;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int right22 = nArray[n];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", Integer.toString(left), Integer.toString(right22))))).isEqualTo(left % right22);
            }
        }
        for (int left : intLefts) {
            int[] nArray = intRights;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                right2 = nArray[n];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "BIGINT '%s'".formatted(left), "BIGINT '%s'".formatted(right2))))).isEqualTo(left % right2);
            }
        }
        int[] nArray = intLefts;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            long left = nArray[i];
            int[] nArray2 = intRights;
            n = nArray2.length;
            for (right2 = 0; right2 < n; ++right2) {
                right = nArray2[right2];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", Long.toString(left * 10000000000L), Long.toString(right * 10000000000L))))).isEqualTo(left * 10000000000L % (right * 10000000000L));
            }
        }
        for (int left : intLefts) {
            double[] dArray = doubleRights;
            int n4 = dArray.length;
            for (n = 0; n < n4; ++n) {
                double right3 = dArray[n];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", Integer.toString(left), "DOUBLE '%s'".formatted(right3))))).isEqualTo((double)left % right3);
            }
        }
        for (int left : intLefts) {
            for (double right4 : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", Integer.toString(left), "REAL '%s'".formatted(Float.valueOf((float)right4)))))).isEqualTo(Float.valueOf((float)left % (float)right4));
            }
        }
        for (double left : doubleLefts) {
            int[] nArray3 = intRights;
            n = nArray3.length;
            for (int i = 0; i < n; ++i) {
                right = nArray3[i];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DOUBLE '%s'".formatted(left), Long.toString(right))))).isEqualTo(left % (double)right);
            }
        }
        for (double left : doubleLefts) {
            int[] nArray4 = intRights;
            n = nArray4.length;
            for (int i = 0; i < n; ++i) {
                right = nArray4[i];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "REAL '%s'".formatted(Float.valueOf((float)left)), Long.toString(right))))).isEqualTo(Float.valueOf((float)left % (float)right));
            }
        }
        for (double left : doubleLefts) {
            for (double right5 : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DOUBLE '%s'".formatted(left), "DOUBLE '%s'".formatted(right5))))).isEqualTo(left % right5);
            }
        }
        for (double left : doubleLefts) {
            for (double right6 : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "REAL '%s'".formatted(Float.valueOf((float)left)), "REAL '%s'".formatted(Float.valueOf((float)right6)))))).isEqualTo(Float.valueOf((float)left % (float)right6));
            }
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "5.0E0", "NULL")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "NULL", "5.0E0")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '0.0'", "DECIMAL '2.0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '13.0'", "DECIMAL '5.0'")))).isEqualTo(SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '-13.0'", "DECIMAL '5.0'")))).isEqualTo(SqlDecimal.decimal((String)"-3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '13.0'", "DECIMAL '-5.0'")))).isEqualTo(SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '-13.0'", "DECIMAL '-5.0'")))).isEqualTo(SqlDecimal.decimal((String)"-3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '5.0'", "DECIMAL '2.5'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '5.0'", "DECIMAL '2.05'")))).isEqualTo(SqlDecimal.decimal((String)"0.90", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '5.0'", "DECIMAL '2.55'")))).isEqualTo(SqlDecimal.decimal((String)"2.45", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '5.0001'", "DECIMAL '2.55'")))).isEqualTo(SqlDecimal.decimal((String)"2.4501", (DecimalType)DecimalType.createDecimalType((int)5, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '123456789012345670'", "DECIMAL '123456789012345669'")))).isEqualTo(SqlDecimal.decimal((String)"0.01", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '12345678901234567.90'", "DECIMAL '12345678901234567.89'")))).isEqualTo(SqlDecimal.decimal((String)"0.01", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "DECIMAL '5.0'", "CAST(NULL as DECIMAL(1,0))")))).isNull((Type)DecimalType.createDecimalType((int)2, (int)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", "CAST(NULL as DECIMAL(1,0))", "DECIMAL '5.0'")))).isNull((Type)DecimalType.createDecimalType((int)2, (int)1));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("mod", "DECIMAL '5.0'", "DECIMAL '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testPi() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("pi", new String[0])))).isEqualTo(Math.PI);
    }

    @Test
    public void testNaN() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nan", new String[0])))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", "0.0E0").binding("b", "0.0E0")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testInfinity() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("infinity", new String[0])))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("-rand() / a").binding("a", "0.0E0")))).isEqualTo(Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testIsInfinite() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_infinite", "1.0E0 / 0.0E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_infinite", "0.0E0 / 0.0E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_infinite", "1.0E0 / 1.0E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_infinite", "REAL '1.0' / REAL '0.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_infinite", "REAL '0.0' / REAL '0.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_infinite", "REAL '1.0' / REAL '1.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_infinite", "NULL")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testIsFinite() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_finite", "100000")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_finite", "rand() / 0.0E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_finite", "REAL '754.2008E0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_finite", "rand() / REAL '0.0E0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_finite", "NULL")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testIsNaN() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "0.0E0 / 0.0E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "0.0E0 / 1.0E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "infinity() / infinity()")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "nan()")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "REAL 'NaN'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "REAL '0.0' / REAL '0.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "REAL '0.0' / 1.0E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "infinity() / infinity()")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "nan()")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_nan", "NULL")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testPower() {
        long right;
        int n;
        int n2;
        int n3;
        int[] objectArray = intLefts;
        int n4 = objectArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            long left = objectArray[n3];
            int[] nArray = intRights;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                right = nArray[n];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", Double.toString(left), Double.toString(right))))).isEqualTo(Math.pow(left, right));
            }
        }
        for (int left : intLefts) {
            for (int right2 : intRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", "BIGINT '%s'".formatted(left), "BIGINT '%s'".formatted(right2))))).isEqualTo(Math.pow(left, right2));
            }
        }
        int[] nArray = intLefts;
        n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            long left = nArray[n3];
            int[] nArray2 = intRights;
            n2 = nArray2.length;
            for (n = 0; n < n2; ++n) {
                right = nArray2[n];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", "" + left * 10000000000L, Long.toString(right))))).isEqualTo(Math.pow(left * 10000000000L, right));
            }
        }
        int[] nArray3 = intLefts;
        n4 = nArray3.length;
        for (n3 = 0; n3 < n4; ++n3) {
            long left = nArray3[n3];
            for (double right3 : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", Long.toString(left), Double.toString(right3))))).isEqualTo(Math.pow(left, right3));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", Long.toString(left), "REAL '%s'".formatted(Float.valueOf((float)right3)))))).isEqualTo(Math.pow(left, (float)right3));
            }
        }
        for (double left : doubleLefts) {
            int[] nArray4 = intRights;
            n2 = nArray4.length;
            for (n = 0; n < n2; ++n) {
                long right4 = nArray4[n];
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", Double.toString(left), Long.toString(right4))))).isEqualTo(Math.pow(left, right4));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", "REAL '%s'".formatted(Float.valueOf((float)left)), Long.toString(right4))))).isEqualTo(Math.pow((float)left, right4));
            }
        }
        for (double left : doubleLefts) {
            for (double right5 : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", Double.toString(left), Double.toString(right5))))).isEqualTo(Math.pow(left, right5));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", "REAL '%s'".formatted(left), "REAL '%s'".formatted(right5))))).isEqualTo(Math.pow((float)left, (float)right5));
            }
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", "NULL", "NULL")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", "5.0E0", "NULL")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", "NULL", "5.0E0")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("pow", "5.0E0", "2.0E0")))).isEqualTo(25.0);
    }

    @Test
    public void testRadians() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("radians", Double.toString(doubleValue))))).isEqualTo(Math.toRadians(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("radians", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.toRadians((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("radians", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testRandom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rand", new String[0])))).hasType((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("random", new String[0])))).hasType((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("rand(1000)")))).hasType((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(TINYINT '3', TINYINT '5')")))).hasType((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(TINYINT '-3', TINYINT '-1')")))).hasType((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(TINYINT '-3', TINYINT '5')")))).hasType((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(SMALLINT '20000', SMALLINT '30000')")))).hasType((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(SMALLINT '-20000', SMALLINT '-10000')")))).hasType((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(SMALLINT '-20000', SMALLINT '30000')")))).hasType((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(1000, 2000)")))).hasType((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(-10, -5)")))).hasType((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(-10, 10)")))).hasType((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(2000)")))).hasType((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(3000000000)")))).hasType((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(3000000000, 5000000000)")))).hasType((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(-3000000000, -2000000000)")))).hasType((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("random(-3000000000, 5000000000)")))).hasType((Type)BigintType.BIGINT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rand", "-1")::evaluate).hasMessage("bound must be positive");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rand", "-3000000000")::evaluate).hasMessage("bound must be positive");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "TINYINT '5'", "TINYINT '3'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "TINYINT '5'", "TINYINT '5'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "TINYINT '-5'", "TINYINT '-10'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "TINYINT '-5'", "TINYINT '-5'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "SMALLINT '30000'", "SMALLINT '10000'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "SMALLINT '30000'", "SMALLINT '30000'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "SMALLINT '-30000'", "SMALLINT '-31000'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "SMALLINT '-30000'", "SMALLINT '-30000'")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "1000", "500")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "500", "500")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "-500", "-600")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "-500", "-500")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "3000000000", "1000000000")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "3000000000", "3000000000")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "-3000000000", "-4000000000")::evaluate).hasMessage("start value must be less than stop value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("random", "-3000000000", "-3000000000")::evaluate).hasMessage("start value must be less than stop value");
    }

    @Test
    public void testRound() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '3'")))).isEqualTo((byte)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '-3'")))).isEqualTo((byte)-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as TINYINT)")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '3'")))).isEqualTo((short)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '-3'")))).isEqualTo((short)-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as SMALLINT)")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3")))).isEqualTo(-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as INTEGER)")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "BIGINT '3'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "BIGINT '-3'")))).isEqualTo(-3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", " 3000000000")))).isEqualTo(3000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3000000000")))).isEqualTo(-3000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.0E0")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.0E0")))).isEqualTo(-3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.499E0")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.499E0")))).isEqualTo(-3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.5E0")))).isEqualTo(4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.5E0")))).isEqualTo(-4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.5001E0")))).isEqualTo(-4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.99E0")))).isEqualTo(-4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.0'")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.0'")))).isEqualTo(Float.valueOf(-3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.499'")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.499'")))).isEqualTo(Float.valueOf(-3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.5'")))).isEqualTo(Float.valueOf(4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.5'")))).isEqualTo(Float.valueOf(-4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.5001'")))).isEqualTo(Float.valueOf(-4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.99'")))).isEqualTo(Float.valueOf(-4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as DOUBLE)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '%s'".formatted(0.49999999999999994))))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '-0.5'")))).isEqualTo(-1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '-0.49999999999999994'")))).isEqualTo(-0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '3'", "TINYINT '0'")))).isEqualTo((byte)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '3'", "0")))).isEqualTo((byte)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '3'", "SMALLINT '0'")))).isEqualTo((short)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '3'", "0")))).isEqualTo((short)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3", "0")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3", "0")))).isEqualTo(-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3", "INTEGER '0'")))).isEqualTo(-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "BIGINT '3'", "0")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", " 3000000000", "0")))).isEqualTo(3000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3000000000", "0")))).isEqualTo(-3000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.0E0", "0")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.0E0", "0")))).isEqualTo(-3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.499E0", "0")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.499E0", "0")))).isEqualTo(-3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.5E0", "0")))).isEqualTo(4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.5E0", "0")))).isEqualTo(-4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.5001E0", "0")))).isEqualTo(-4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.99E0", "0")))).isEqualTo(-4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '%s'".formatted(0.49999999999999994), "0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '-0.5'")))).isEqualTo(-1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '-0.49999999999999994'", "0")))).isEqualTo(-0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "0.3E0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-0.3E0")))).isEqualTo(-0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "923e0", "16")))).isEqualTo(923.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '3000.1234567890123456789'", "16")))).isEqualTo(3000.1234567890124);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '1.8E292'", "16")))).isEqualTo(1.8E292);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DOUBLE '-1.8E292'", "16")))).isEqualTo(-1.8E292);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '3'", "TINYINT '1'")))).isEqualTo((byte)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '3'", "1")))).isEqualTo((byte)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '3'", "SMALLINT '1'")))).isEqualTo((short)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '3'", "1")))).isEqualTo((short)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.0'", "0")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.0'", "0")))).isEqualTo(Float.valueOf(-3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.499'", "0")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.499'", "0")))).isEqualTo(Float.valueOf(-3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.5'", "0")))).isEqualTo(Float.valueOf(4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.5'", "0")))).isEqualTo(Float.valueOf(-4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.5001'", "0")))).isEqualTo(Float.valueOf(-4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.99'", "0")))).isEqualTo(Float.valueOf(-4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '923'", "16")))).isEqualTo(Float.valueOf(923.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3000.1234567890123456789'", "16")))).isEqualTo(Float.valueOf(3000.1235f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.4028235e+38'", "271")))).isEqualTo(Float.valueOf(Float.MAX_VALUE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.4028235e+38'", "271")))).isEqualTo(Float.valueOf(-3.4028235E38f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3", "1")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3", "1")))).isEqualTo(-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3", "INTEGER '1'")))).isEqualTo(-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3", "CAST(NULL as INTEGER)")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "BIGINT '3'", "1")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", " 3000000000", "1")))).isEqualTo(3000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3000000000", "1")))).isEqualTo(-3000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as BIGINT)", "CAST(NULL as INTEGER)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as BIGINT)", "1")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.0E0", "1")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.0E0", "1")))).isEqualTo(-3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.499E0", "1")))).isEqualTo(3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.499E0", "1")))).isEqualTo(-3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "3.5E0", "1")))).isEqualTo(3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.5E0", "1")))).isEqualTo(-3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.5001E0", "1")))).isEqualTo(-3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.99E0", "1")))).isEqualTo(-4.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.0'", "1")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.0'", "1")))).isEqualTo(Float.valueOf(-3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.499'", "1")))).isEqualTo(Float.valueOf(3.5f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.499'", "1")))).isEqualTo(Float.valueOf(-3.5f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '3.5'", "1")))).isEqualTo(Float.valueOf(3.5f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.5'", "1")))).isEqualTo(Float.valueOf(-3.5f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.5001'", "1")))).isEqualTo(Float.valueOf(-3.5f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "REAL '-3.99'", "1")))).isEqualTo(Float.valueOf(-4.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '9'", "-1")))).isEqualTo((byte)10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '-9'", "-1")))).isEqualTo((byte)-10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '5'", "-1")))).isEqualTo((byte)10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '-5'", "-1")))).isEqualTo((byte)-10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '-14'", "-1")))).isEqualTo((byte)-10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '12'", "-1")))).isEqualTo((byte)10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '18'", "-1")))).isEqualTo((byte)20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '18'", "-2")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '18'", "-3")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '127'", "-2")))).isEqualTo((byte)100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '127'", "-3")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '-128'", "-2")))).isEqualTo((byte)-100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "TINYINT '-128'", "-3")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '99'", "-1")))).isEqualTo((short)100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '99'", "-2")))).isEqualTo((short)100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '99'", "-3")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '-99'", "-1")))).isEqualTo((short)-100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '-99'", "-2")))).isEqualTo((short)-100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '-99'", "-3")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '32767'", "-4")))).isEqualTo((short)30000);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '32767'", "-5")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '-32768'", "-4")))).isEqualTo((short)-30000);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "SMALLINT '-32768'", "-5")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "99", "-1")))).isEqualTo(100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-99", "-1")))).isEqualTo(-100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "99", "INTEGER '-1'")))).isEqualTo(100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-99", "INTEGER '-1'")))).isEqualTo(-100);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "12355", "-2")))).isEqualTo(12400);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "12345", "-2")))).isEqualTo(12300);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "2147483647", "-9")))).isEqualTo(2000000000);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "2147483647", "-10")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", " 3999999999", "-1")))).isEqualTo(4000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3999999999", "-1")))).isEqualTo(-4000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "9223372036854775807", "-2")))).isEqualTo(0x7FFFFFFFFFFFFFF8L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "9223372036854775807", "-17")))).isEqualTo(9200000000000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "9223372036854775807", "-18")))).isEqualTo(9000000000000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-9223372036854775807", "-17")))).isEqualTo(-9200000000000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-9223372036854775807", "-18")))).isEqualTo(-9000000000000000000L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "TINYINT '127'", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "TINYINT '-128'", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "SMALLINT '32767'", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "SMALLINT '32767'", "-3")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "SMALLINT '-32768'", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "SMALLINT '-32768'", "-3")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "2147483647", "-100")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "2147483647", "-2147483648")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "9223372036854775807", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "9223372036854775807", "-3")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "9223372036854775807", "-19")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "-9223372036854775807", "-20")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "-9223372036854775807", "-2147483648")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '0.1'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-0.1'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"3", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"-3", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.0'")))).isEqualTo(SqlDecimal.decimal((String)"3", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.0'")))).isEqualTo(SqlDecimal.decimal((String)"-3", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.49'")))).isEqualTo(SqlDecimal.decimal((String)"3", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.49'")))).isEqualTo(SqlDecimal.decimal((String)"-3", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.50'")))).isEqualTo(SqlDecimal.decimal((String)"4", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.50'")))).isEqualTo(SqlDecimal.decimal((String)"-4", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.99'")))).isEqualTo(SqlDecimal.decimal((String)"4", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.99'")))).isEqualTo(SqlDecimal.decimal((String)"-4", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9.99'")))).isEqualTo(SqlDecimal.decimal((String)"10", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9.99'")))).isEqualTo(SqlDecimal.decimal((String)"-10", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999.9'")))).isEqualTo(SqlDecimal.decimal((String)"10000", (DecimalType)DecimalType.createDecimalType((int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9999.9'")))).isEqualTo(SqlDecimal.decimal((String)"-10000", (DecimalType)DecimalType.createDecimalType((int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1000000000000.9999'")))).isEqualTo(SqlDecimal.decimal((String)"1000000000001", (DecimalType)DecimalType.createDecimalType((int)14)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1000000000000.9999'")))).isEqualTo(SqlDecimal.decimal((String)"-1000000000001", (DecimalType)DecimalType.createDecimalType((int)14)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '10000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-10000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999999999999999.99'")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '99999999999999999.9'")))).isEqualTo(SqlDecimal.decimal((String)"100000000000000000", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(0 AS DECIMAL(18,0))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(0 AS DECIMAL(18,1))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(0 AS DECIMAL(18,2))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(DECIMAL '0.1' AS DECIMAL(18,1))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(DECIMAL '-0.1' AS DECIMAL(18,1))")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000000000.0'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000000000.0'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000000000.49'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000000000.49'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000000000.50'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000000000.50'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000000000.99'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000000000.99'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999999999999999999999.99'")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9999999999999999999999.99'")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1000000000000000000000000000000000.9999'")))).isEqualTo(SqlDecimal.decimal((String)"1000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)35)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1000000000000000000000000000000000.9999'")))).isEqualTo(SqlDecimal.decimal((String)"-1000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)35)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '10000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-10000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000.000000'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000.000000'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000.499999'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000.499999'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000.500000'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000001", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000.500000'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000001", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3000000000000000.999999'")))).isEqualTo(SqlDecimal.decimal((String)"3000000000000001", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3000000000000000.999999'")))).isEqualTo(SqlDecimal.decimal((String)"-3000000000000001", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999999999999999.999999'")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9999999999999999.999999'")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3'", "1")))).isEqualTo(SqlDecimal.decimal((String)"3", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-3", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.0'", "1")))).isEqualTo(SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.0'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-3.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.449'", "1")))).isEqualTo(SqlDecimal.decimal((String)"3.400", (DecimalType)DecimalType.createDecimalType((int)5, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.449'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-3.400", (DecimalType)DecimalType.createDecimalType((int)5, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.450'", "1")))).isEqualTo(SqlDecimal.decimal((String)"3.500", (DecimalType)DecimalType.createDecimalType((int)5, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.450'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-3.500", (DecimalType)DecimalType.createDecimalType((int)5, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '3.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"4.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-4.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"10.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-10.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '0.3'", "0")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '0.7'", "0")))).isEqualTo(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1.7'", "0")))).isEqualTo(SqlDecimal.decimal((String)"2.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-0.3'", "0")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-0.7'", "0")))).isEqualTo(SqlDecimal.decimal((String)"-1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1.7'", "0")))).isEqualTo(SqlDecimal.decimal((String)"-2.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '0.7'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1.7'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '7.1'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"10.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '0.3'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '33.3'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(DECIMAL '0.7' AS decimal(20, 1))", "-19")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '0.00'", "1")))).isEqualTo(SqlDecimal.decimal((String)"0.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1234'", "7")))).isEqualTo(SqlDecimal.decimal((String)"1234", (DecimalType)DecimalType.createDecimalType((int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1234'", "7")))).isEqualTo(SqlDecimal.decimal((String)"-1234", (DecimalType)DecimalType.createDecimalType((int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1234'", "-7")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1234'", "-7")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1234.5678'", "7")))).isEqualTo(SqlDecimal.decimal((String)"1234.5678", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1234.5678'", "7")))).isEqualTo(SqlDecimal.decimal((String)"-1234.5678", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1234.5678'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"1200.0000", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1234.5678'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"-1200.0000", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1254.5678'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"1300.0000", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1254.5678'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"-1300.0000", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1234.5678'", "-7")))).isEqualTo(SqlDecimal.decimal((String)"0.0000", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1234.5678'", "-7")))).isEqualTo(SqlDecimal.decimal((String)"0.0000", (DecimalType)DecimalType.createDecimalType((int)9, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '99'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"100", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1234567890123456789'", "1")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1234567890123456789'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456789", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345678.0'", "1")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678.0", (DecimalType)DecimalType.createDecimalType((int)20, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345678.0'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678.0", (DecimalType)DecimalType.createDecimalType((int)20, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345678.449'", "1")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678.400", (DecimalType)DecimalType.createDecimalType((int)22, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345678.449'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678.400", (DecimalType)DecimalType.createDecimalType((int)22, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345678.45'", "1")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678.50", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345678.45'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678.50", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345678.501'", "1")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678.500", (DecimalType)DecimalType.createDecimalType((int)22, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345678.501'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678.500", (DecimalType)DecimalType.createDecimalType((int)22, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '999999999999999999.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"1000000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-999999999999999999.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-1000000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '1234567890123456789'", "7")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456789", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1234567890123456789'", "7")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456789", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345678.99'", "7")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678.99", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345678.99'", "7")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678.99", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345611.99'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345600.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345611.99'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345600.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345678.99'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345700.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345678.99'", "-2")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345700.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '123456789012345678.99'", "-30")))).isEqualTo(SqlDecimal.decimal((String)"0.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-123456789012345678.99'", "-30")))).isEqualTo(SqlDecimal.decimal((String)"0.00", (DecimalType)DecimalType.createDecimalType((int)21, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999999999999999999999999999999999999.9'", "1")))).isEqualTo(SqlDecimal.decimal((String)"9999999999999999999999999999999999999.9", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "DECIMAL '9999999999999999999999999999999999999.9'", "0")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("round", "DECIMAL '9999999999999999999999999999999999999.9'", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL  '1329123201320737513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"1329123201320738000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1329123201320737513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"-1329123201320738000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL  '1329123201320739513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"1329123201320740000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-1329123201320739513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"-1329123201320740000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL  '9999999999999999999'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9999999999999999999'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999999999999999.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9999999999999999.99'", "1")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999999999999999.99'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"10000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9999999999999999.99'", "-1")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '9999999999999999.99'", "2")))).isEqualTo(SqlDecimal.decimal((String)"9999999999999999.99", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-9999999999999999.99'", "2")))).isEqualTo(SqlDecimal.decimal((String)"-9999999999999999.99", (DecimalType)DecimalType.createDecimalType((int)19, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '329123201320737513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"329123201320738000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-329123201320737513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"-329123201320738000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '329123201320739513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"329123201320740000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-329123201320739513'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"-329123201320740000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '999999999999999999'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"1000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-999999999999999999'", "-3")))).isEqualTo(SqlDecimal.decimal((String)"-1000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as DOUBLE)", "CAST(NULL as INTEGER)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-3.0E0", "CAST(NULL as INTEGER)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as DOUBLE)", "1")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as DECIMAL(1,0))", "CAST(NULL as INTEGER)")))).isNull((Type)DecimalType.createDecimalType((int)2, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "DECIMAL '-3.0'", "CAST(NULL as INTEGER)")))).isNull((Type)DecimalType.createDecimalType((int)3, (int)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as DECIMAL(1,0))", "1")))).isNull((Type)DecimalType.createDecimalType((int)2, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as DECIMAL(17,2))", "1")))).isNull((Type)DecimalType.createDecimalType((int)18, (int)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "CAST(NULL as DECIMAL(20,2))", "1")))).isNull((Type)DecimalType.createDecimalType((int)21, (int)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "nan()", "2")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "1.0E0 / 0", "2")))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("round", "-1.0E0 / 0", "2")))).isEqualTo(Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testSign() {
        Float signum;
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "CAST(NULL as TINYINT)")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "CAST(NULL as SMALLINT)")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "CAST(NULL as INTEGER)")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "CAST(NULL as BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "CAST(NULL as DOUBLE)")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "CAST(NULL as DECIMAL(2,1))")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "CAST(NULL as DECIMAL(38,0))")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "TINYINT '%s'".formatted(intValue))))).isEqualTo(signum.byteValue());
        }
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "SMALLINT '%s'".formatted(intValue))))).isEqualTo(signum.shortValue());
        }
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "INTEGER '%s'".formatted(intValue))))).isEqualTo(signum.intValue());
        }
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "BIGINT '%s'".formatted(intValue))))).isEqualTo(signum.longValue());
        }
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DOUBLE '%s'".formatted(doubleValue))))).isEqualTo(Math.signum(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Float.valueOf(Math.signum((float)doubleValue)));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DOUBLE '+Infinity'")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DOUBLE '-Infinity'")))).isEqualTo(-1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '123'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '-123'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '123.000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '-123.000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '0.000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '1230.000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sign", "DECIMAL '-1230.000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
    }

    @Test
    public void testSin() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sin", Double.toString(doubleValue))))).isEqualTo(Math.sin(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sin", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.sin((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sin", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testSinh() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sinh", Double.toString(doubleValue))))).isEqualTo(Math.sinh(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sinh", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.sinh((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sinh", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testSqrt() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sqrt", Double.toString(doubleValue))))).isEqualTo(Math.sqrt(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sqrt", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.sqrt((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sqrt", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testTan() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("tan", Double.toString(doubleValue))))).isEqualTo(Math.tan(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("tan", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.tan((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("tan", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testTanh() {
        for (double doubleValue : DOUBLE_VALUES) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("tanh", Double.toString(doubleValue))))).isEqualTo(Math.tanh(doubleValue));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("tanh", "REAL '%s'".formatted(Float.valueOf((float)doubleValue)))))).isEqualTo(Math.tanh((float)doubleValue));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("tanh", "NULL")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testGreatest() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "TINYINT '1'", "TINYINT '2'")))).isEqualTo((byte)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "TINYINT '-1'", "TINYINT '-2'")))).isEqualTo((byte)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "TINYINT '5'", "TINYINT '4'", "TINYINT '3'", "TINYINT '2'", "TINYINT '1'", "TINYINT '2'", "TINYINT '3'", "TINYINT '4'", "TINYINT '1'", "TINYINT '5'")))).isEqualTo((byte)5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "TINYINT '-1'")))).isEqualTo((byte)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "TINYINT '5'", "TINYINT '4'", "CAST(NULL AS TINYINT)", "TINYINT '3'")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "SMALLINT '1'", "SMALLINT '2'")))).isEqualTo((short)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "SMALLINT '-1'", "SMALLINT '-2'")))).isEqualTo((short)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "SMALLINT '5'", "SMALLINT '4'", "SMALLINT '3'", "SMALLINT '2'", "SMALLINT '1'", "SMALLINT '2'", "SMALLINT '3'", "SMALLINT '4'", "SMALLINT '1'", "SMALLINT '5'")))).isEqualTo((short)5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "SMALLINT '-1'")))).isEqualTo((short)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "SMALLINT '5'", "SMALLINT '4'", "CAST(NULL AS SMALLINT)", "SMALLINT '3'")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1", "2")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "-1", "-2")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5", "4", "3", "2", "1", "2", "3", "4", "1", "5")))).isEqualTo(5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "-1")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5", "4", "CAST(NULL AS INTEGER)", "3")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "10000000000", "20000000000")))).isEqualTo(20000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "-10000000000", "-20000000000")))).isEqualTo(-10000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5000000000", "4", "3", "2", "1000000000", "2", "3", "4", "1", "5000000000")))).isEqualTo(5000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "-10000000000")))).isEqualTo(-10000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5000000000", "4000000000", "CAST(NULL as BIGINT)", "3000000000")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.5E0", "2.3E0")))).isEqualTo(2.3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "-1.5E0", "-2.3E0")))).isEqualTo(-1.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "-1.5E0", "-2.3E0", "-5/3")))).isEqualTo(-1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.5E0", "-infinity()", "infinity()")))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5", "4", "CAST(NULL as DOUBLE)", "3")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "NaN()", "5", "4", "3")))).isEqualTo(5.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5", "4", "NaN()", "3")))).isEqualTo(5.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5", "4", "3", "NaN()")))).isEqualTo(5.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "NaN()")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "NaN()", "NaN()", "NaN()")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "REAL '1.5'", "REAL '2.3'")))).isEqualTo(Float.valueOf(2.3f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "REAL '-1.5'", "REAL '-2.3'")))).isEqualTo(Float.valueOf(-1.5f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "REAL '-1.5'", "REAL '-2.3'", "CAST(-5/3 AS REAL)")))).isEqualTo(Float.valueOf(-1.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "REAL '1.5'", "CAST(infinity() AS REAL)")))).isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "REAL '5'", "REAL '4'", "CAST(NULL as REAL)", "REAL '3'")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "CAST(NaN() as REAL)", "REAL '5'", "REAL '4'", "REAL '3'")))).isEqualTo(Float.valueOf(5.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "REAL '5'", "REAL '4'", "CAST(NaN() as REAL)", "REAL '3'")))).isEqualTo(Float.valueOf(5.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "REAL '5'", "REAL '4'", "REAL '3'", "CAST(NaN() as REAL)")))).isEqualTo(Float.valueOf(5.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "CAST(NaN() as REAL)")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "CAST(NaN() as REAL)", "CAST(NaN() as REAL)", "CAST(NaN() as REAL)")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.0", "2.0")))).isEqualTo(SqlDecimal.decimal((String)"2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.0", "-2.0")))).isEqualTo(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.0", "1.1", "1.2", "1.3")))).isEqualTo(SqlDecimal.decimal((String)"1.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1", "20000000000")))).isEqualTo(20000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1", "BIGINT '2'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.0E0", "2")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1", "2.0E0")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.0E0", "2")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5.0E0", "4", "CAST(NULL as DOUBLE)", "3")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5.0E0", "4", "CAST(NULL as BIGINT)", "3")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "1.0", "2.0E0")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "5", "4", "3.0", "2")))).isEqualTo(SqlDecimal.decimal((String)"0000000005.0", (DecimalType)DecimalType.createDecimalType((int)11, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", Collections.nCopies(127, "1E0"))))).hasType((Type)DoubleType.DOUBLE);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("greatest", Collections.nCopies(128, "rand()"))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_ARGUMENTS}).hasMessage("line 1:8: Too many arguments for function call greatest()");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(1.5E0)", "ROW(2.3E0)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)2.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(-1.5E0)", "ROW(-2.3E0)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)-1.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(-1.5E0)", "ROW(-2.3E0)", "ROW(-5/3)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)-1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(1.5E0)", "ROW(-infinity())", "ROW(infinity())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)Double.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(5)", "ROW(4)", "CAST(NULL as ROW(DOUBLE))", "ROW(3)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(NaN())", "ROW(5)", "ROW(4)", "ROW(3)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(5)", "ROW(4)", "ROW(NaN())", "ROW(3)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(5)", "ROW(4)", "ROW(3)", "ROW(NaN())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(NaN())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(NaN())", "ROW(NaN())", "ROW(NaN())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(REAL '1.5')", "ROW(REAL '2.3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.3f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(REAL '-1.5')", "ROW(REAL '-2.3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(-1.5f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(REAL '-1.5')", "ROW(REAL '-2.3')", "ROW(CAST(-5/3 AS REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(-1.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(REAL '1.5')", "ROW(CAST(infinity() AS REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(REAL '5')", "ROW(REAL '4')", "CAST(NULL as ROW(REAL))", "ROW(REAL '3')")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(CAST(NaN() as REAL))", "ROW(REAL '5')", "ROW(REAL '4')", "ROW(REAL '3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(5.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(REAL '5')", "ROW(REAL '4')", "ROW(CAST(NaN() as REAL))", "ROW(REAL '3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(5.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(REAL '5')", "ROW(REAL '4')", "ROW(REAL '3')", "ROW(CAST(NaN() as REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(5.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(CAST(NaN() as REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ROW(CAST(NaN() as REAL))", "ROW(CAST(NaN() as REAL))", "ROW(CAST(NaN() as REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[1.5E0]", "ARRAY[2.3E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)2.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[-1.5E0]", "ARRAY[-2.3E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)-1.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[-1.5E0]", "ARRAY[-2.3E0]", "ARRAY[-5/3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)-1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[1.5E0]", "ARRAY[-infinity()]", "ARRAY[infinity()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[5]", "ARRAY[4]", "CAST(NULL as ARRAY(DOUBLE))", "ARRAY[3]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[NaN()]", "ARRAY[5]", "ARRAY[4]", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[5]", "ARRAY[4]", "ARRAY[NaN()]", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[5]", "ARRAY[4]", "ARRAY[3]", "ARRAY[NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[NaN()]", "ARRAY[NaN()]", "ARRAY[NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[REAL '1.5']", "ARRAY[REAL '2.3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.3f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[REAL '-1.5']", "ARRAY[REAL '-2.3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(-1.5f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[REAL '-1.5']", "ARRAY[REAL '-2.3']", "ARRAY[CAST(-5/3 AS REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(-1.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[REAL '1.5']", "ARRAY[CAST(infinity() AS REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "CAST(NULL as ARRAY(REAL))", "ARRAY[REAL '3']")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "ARRAY[REAL '3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(5.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[REAL '3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(5.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "ARRAY[REAL '3']", "ARRAY[CAST(NaN() as REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(5.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[CAST(NaN() as REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[CAST(NaN() as REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
    }

    @Test
    public void testLeast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "TINYINT '1'", "TINYINT '2'")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "TINYINT '-1'", "TINYINT '-2'")))).isEqualTo((byte)-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "TINYINT '5'", "TINYINT '4'", "TINYINT '3'", "TINYINT '2'", "TINYINT '1'", "TINYINT '2'", "TINYINT '3'", "TINYINT '4'", "TINYINT '1'", "TINYINT '5'")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "TINYINT '-1'")))).isEqualTo((byte)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "TINYINT '5'", "TINYINT '4'", "CAST(NULL AS TINYINT)", "TINYINT '3'")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "SMALLINT '1'", "SMALLINT '2'")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "SMALLINT '-1'", "SMALLINT '-2'")))).isEqualTo((short)-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "SMALLINT '5'", "SMALLINT '4'", "SMALLINT '3'", "SMALLINT '2'", "SMALLINT '1'", "SMALLINT '2'", "SMALLINT '3'", "SMALLINT '4'", "SMALLINT '1'", "SMALLINT '5'")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "SMALLINT '-1'")))).isEqualTo((short)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "SMALLINT '5'", "SMALLINT '4'", "CAST(NULL AS SMALLINT)", "SMALLINT '3'")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1", "2")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "-1", "-2")))).isEqualTo(-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5", "4", "3", "2", "1", "2", "3", "4", "1", "5")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "-1")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5", "4", "CAST(NULL AS INTEGER)", "3")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "10000000000", "20000000000")))).isEqualTo(10000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "-10000000000", "-20000000000")))).isEqualTo(-20000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "50000000000", "40000000000", "30000000000", "20000000000", "50000000000")))).isEqualTo(20000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "-10000000000")))).isEqualTo(-10000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "500000000", "400000000", "CAST(NULL as BIGINT)", "300000000")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.5E0", "2.3E0")))).isEqualTo(1.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "-1.5E0", "-2.3E0")))).isEqualTo(-2.3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "-1.5E0", "-2.3E0", "-5/3")))).isEqualTo(-2.3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.5E0", "-infinity()", "infinity()")))).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5", "4", "CAST(NULL as DOUBLE)", "3")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "NaN()", "5", "4", "3")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5", "4", "NaN()", "3")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5", "4", "3", "NaN()")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "NaN()")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "NaN()", "NaN()", "NaN()")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "REAL '1.5'", "REAL '2.3'")))).isEqualTo(Float.valueOf(1.5f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "REAL '-1.5'", "REAL '-2.3'")))).isEqualTo(Float.valueOf(-2.3f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "REAL '-1.5'", "REAL '-2.3'", "CAST(-5/3 AS REAL)")))).isEqualTo(Float.valueOf(-2.3f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "REAL '1.5'", "CAST(-infinity() AS REAL)")))).isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "REAL '5'", "REAL '4'", "CAST(NULL as REAL)", "REAL '3'")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "CAST(NaN() as REAL)", "REAL '5'", "REAL '4'", "REAL '3'")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "REAL '5'", "REAL '4'", "CAST(NaN() as REAL)", "REAL '3'")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "REAL '5'", "REAL '4'", "REAL '3'", "CAST(NaN() as REAL)")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "CAST(NaN() as REAL)")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "CAST(NaN() as REAL)", "CAST(NaN() as REAL)", "CAST(NaN() as REAL)")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.0", "2.0")))).isEqualTo(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.0", "-2.0")))).isEqualTo(SqlDecimal.decimal((String)"-2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.0", "1.1", "1.2", "1.3")))).isEqualTo(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1", "20000000000")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1", "BIGINT '2'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.0E0", "2")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1", "2.0E0")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.0E0", "2")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5.0E0", "4", "CAST(NULL as DOUBLE)", "3")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5.0E0", "4", "CAST(NULL as BIGINT)", "3")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "1.0", "2.0E0")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "5", "4", "3.0", "2")))).isEqualTo(SqlDecimal.decimal((String)"0000000002.0", (DecimalType)DecimalType.createDecimalType((int)11, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(1.5E0)", "ROW(2.3E0)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)1.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(-1.5E0)", "ROW(-2.3E0)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)-2.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(-1.5E0)", "ROW(-2.3E0)", "ROW(-5/3)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)-2.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(1.5E0)", "ROW(-infinity())", "ROW(infinity())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)Double.NEGATIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(5)", "ROW(4)", "CAST(NULL as ROW(DOUBLE))", "ROW(3)")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(NaN())", "ROW(5)", "ROW(4)", "ROW(3)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(5)", "ROW(4)", "ROW(NaN())", "ROW(3)")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(5)", "ROW(4)", "ROW(3)", "ROW(NaN())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(NaN())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(NaN())", "ROW(NaN())", "ROW(NaN())")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(REAL '1.5')", "ROW(REAL '2.3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(1.5f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(REAL '-1.5')", "ROW(REAL '-2.3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(-2.3f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(REAL '-1.5')", "ROW(REAL '-2.3')", "ROW(CAST(-5/3 AS REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(-2.3f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(REAL '1.5')", "ROW(CAST(-infinity() AS REAL))", "ROW(CAST(infinity() AS REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(REAL '5')", "ROW(REAL '4')", "CAST(NULL as ROW(REAL))", "ROW(REAL '3')")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(CAST(NaN() as REAL))", "ROW(REAL '5')", "ROW(REAL '4')", "ROW(REAL '3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(REAL '5')", "ROW(REAL '4')", "ROW(CAST(NaN() as REAL))", "ROW(REAL '3')")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(REAL '5')", "ROW(REAL '4')", "ROW(REAL '3')", "ROW(CAST(NaN() as REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(CAST(NaN() as REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ROW(CAST(NaN() as REAL))", "ROW(CAST(NaN() as REAL))", "ROW(CAST(NaN() as REAL))")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[1.5E0]", "ARRAY[2.3E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[-1.5E0]", "ARRAY[-2.3E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)-2.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[-1.5E0]", "ARRAY[-2.3E0]", "ARRAY[-5/3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)-2.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[1.5E0]", "ARRAY[-infinity()]", "ARRAY[infinity()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NEGATIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[5]", "ARRAY[4]", "CAST(NULL as ARRAY(DOUBLE))", "ARRAY[3]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[NaN()]", "ARRAY[5]", "ARRAY[4]", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[5]", "ARRAY[4]", "ARRAY[NaN()]", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[5]", "ARRAY[4]", "ARRAY[3]", "ARRAY[NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[NaN()]", "ARRAY[NaN()]", "ARRAY[NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[REAL '1.5']", "ARRAY[REAL '2.3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(1.5f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[REAL '-1.5']", "ARRAY[REAL '-2.3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(-2.3f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[REAL '-1.5']", "ARRAY[REAL '-2.3']", "ARRAY[CAST(-5/3 AS REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(-2.3f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[REAL '1.5']", "ARRAY[CAST(-infinity() AS REAL)]", "ARRAY[CAST(infinity() AS REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "CAST(NULL as ARRAY(REAL))", "ARRAY[REAL '3']")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "ARRAY[REAL '3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[REAL '3']")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[REAL '5']", "ARRAY[REAL '4']", "ARRAY[REAL '3']", "ARRAY[CAST(NaN() as REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[CAST(NaN() as REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[CAST(NaN() as REAL)]", "ARRAY[CAST(NaN() as REAL)]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(Float.NaN)));
    }

    @Test
    public void testToBase() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base", "2147483648", "16")))).isEqualTo("80000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base", "255", "2")))).isEqualTo("11111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base", "-2147483647", "16")))).isEqualTo("-7fffffff");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base", "NULL", "16")))).isNull((Type)VarcharType.createVarcharType((int)64));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base", "-2147483647", "NULL")))).isNull((Type)VarcharType.createVarcharType((int)64));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base", "NULL", "NULL")))).isNull((Type)VarcharType.createVarcharType((int)64));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("to_base", "255", "1")::evaluate).hasMessage("Radix must be between 2 and 36");
    }

    @Test
    public void testFromBase() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "'80000000'", "16")))).isEqualTo(0x80000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "'11111111'", "2")))).isEqualTo(255L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "'-7fffffff'", "16")))).isEqualTo(-2147483647L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "'9223372036854775807'", "10")))).isEqualTo(Long.MAX_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "'-9223372036854775808'", "10")))).isEqualTo(Long.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "NULL", "10")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "'-9223372036854775808'", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base", "NULL", "NULL")))).isNull((Type)BigintType.BIGINT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base", "'Z'", "37")::evaluate).hasMessage("Radix must be between 2 and 36");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base", "'Z'", "35")::evaluate).hasMessage("Not a valid base-35 number: Z");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base", "'9223372036854775808'", "10")::evaluate).hasMessage("Not a valid base-10 number: 9223372036854775808");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base", "'Z'", "37")::evaluate).hasMessage("Radix must be between 2 and 36");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base", "'Z'", "35")::evaluate).hasMessage("Not a valid base-35 number: Z");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base", "'9223372036854775808'", "10")::evaluate).hasMessage("Not a valid base-10 number: 9223372036854775808");
    }

    @Test
    public void testWidthBucket() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "3.14E0", "0", "4", "3")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "2", "0", "4", "3")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "infinity()", "0", "4", "3")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "-1", "0", "3.2E0", "4")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "3.14E0", "4", "0", "3")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "2", "4", "0", "3")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "infinity()", "4", "0", "3")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "-1", "3.2E0", "0", "4")))).isEqualTo(5L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "0", "4", "0")::evaluate).hasMessage("bucketCount must be greater than 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "0", "4", "-1")::evaluate).hasMessage("bucketCount must be greater than 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "nan()", "0", "4", "3")::evaluate).hasMessage("operand must not be NaN");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "-1", "-1", "3")::evaluate).hasMessage("bounds cannot equal each other");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "nan()", "-1", "3")::evaluate).hasMessage("first bound must be finite");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "-1", "nan()", "3")::evaluate).hasMessage("second bound must be finite");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "infinity()", "-1", "3")::evaluate).hasMessage("first bound must be finite");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "-1", "infinity()", "3")::evaluate).hasMessage("second bound must be finite");
    }

    @Test
    public void testWidthBucketOverflowAscending() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "infinity()", "0", "4", Long.toString(Long.MAX_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Bucket for value Infinity is out of range");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "CAST(infinity() as REAL)", "0", "4", Long.toString(Long.MAX_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Bucket for value Infinity is out of range");
    }

    @Test
    public void testWidthBucketOverflowDescending() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "infinity()", "4", "0", Long.toString(Long.MAX_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Bucket for value Infinity is out of range");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "CAST(infinity() as REAL)", "4", "0", Long.toString(Long.MAX_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Bucket for value Infinity is out of range");
    }

    @Test
    public void testWidthBucketArray() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "3.14E0", "array[0.0E0, 2.0E0, 4.0E0]")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "infinity()", "array[0.0E0, 2.0E0, 4.0E0]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "-1", "array[0.0E0, 1.2E0, 3.3E0, 4.5E0]")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "3.145E0", "array[0.0E0]")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "-3.145E0", "array[0.0E0]")))).isEqualTo(0L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "array[]")::evaluate).hasMessage("Bins cannot be an empty array");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "nan()", "array[1.0E0, 2.0E0, 3.0E0]")::evaluate).hasMessage("Operand cannot be NaN");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.14E0", "array[0.0E0, infinity()]")::evaluate).hasMessage("Bin value must be finite, got Infinity");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.145E0", "array[1.0E0, 0.0E0]")::evaluate).hasMessage("Bin values are not sorted in ascending order");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.145E0", "array[1.0E0, 0.0E0, -1.0E0]")::evaluate).hasMessage("Bin values are not sorted in ascending order");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("width_bucket", "3.145E0", "array[1.0E0, 0.3E0, 0.0E0, -1.0E0]")::evaluate).hasMessage("Bin values are not sorted in ascending order");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("width_bucket", "1.5E0", "array[1.0E0, 2.3E0, 2.0E0]")))).isEqualTo(1L);
    }

    @Test
    public void testCosineSimilarity() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_similarity", "map(ARRAY['a', 'b'], ARRAY[1.0E0, 2.0E0])", "map(ARRAY['c', 'b'], ARRAY[1.0E0, 3.0E0])")))).isEqualTo(6.0 / (Math.sqrt(5.0) * Math.sqrt(10.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_similarity", "map(ARRAY['a', 'b', 'c'], ARRAY[1.0E0, 2.0E0, -1.0E0])", "map(ARRAY['c', 'b'], ARRAY[1.0E0, 3.0E0])")))).isEqualTo(5.0 / (Math.sqrt(6.0) * Math.sqrt(10.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_similarity", "map(ARRAY['a', 'b', 'c'], ARRAY[1.0E0, 2.0E0, -1.0E0])", "map(ARRAY['d', 'e'], ARRAY[1.0E0, 3.0E0])")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_similarity", "null", "map(ARRAY['c', 'b'], ARRAY[1.0E0, 3.0E0])")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_similarity", "map(ARRAY['a', 'b'], ARRAY[1.0E0, null])", "map(ARRAY['c', 'b'], ARRAY[1.0E0, 3.0E0])")))).isNull((Type)DoubleType.DOUBLE);
    }

    @Test
    public void testInverseNormalCdf() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("inverse_normal_cdf", "0", "1", "0.3")))).isEqualTo(-0.5244005127080409);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("inverse_normal_cdf", "10", "9", "0.9")))).isEqualTo(21.533964089901406);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("inverse_normal_cdf", "0.5", "0.25", "0.65")))).isEqualTo(0.596330116601892);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("inverse_normal_cdf", "4", "48", "0")::evaluate).hasMessage("p must be 0 > p > 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("inverse_normal_cdf", "4", "48", "1")::evaluate).hasMessage("p must be 0 > p > 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("inverse_normal_cdf", "4", "0", "0.4")::evaluate).hasMessage("sd must be > 0");
    }

    @Test
    public void testNormalCdf() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "0", "1", "1.96")))).isEqualTo(0.9750021048517796);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "10", "9", "10")))).isEqualTo(0.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "-1.5", "2.1", "-7.8")))).isEqualTo(0.0013498980316301035);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "0", "1", "infinity()")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "0", "1", "-infinity()")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "infinity()", "1", "0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "-infinity()", "1", "0")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "0", "infinity()", "0")))).isEqualTo(0.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "nan()", "1", "0")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("normal_cdf", "0", "1", "nan()")))).isEqualTo(Double.NaN);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("normal_cdf", "0", "0", "0.1985")::evaluate).hasMessage("standardDeviation must be > 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("normal_cdf", "0", "nan()", "0.1985")::evaluate).hasMessage("standardDeviation must be > 0");
    }

    @Test
    public void testInverseBetaCdf() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("inverse_beta_cdf", "3", "3.6", "0.0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("inverse_beta_cdf", "3", "3.6", "1.0")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("inverse_beta_cdf", "3", "3.6", "0.3")))).isEqualTo(0.3469675485440618);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("inverse_beta_cdf", "3", "3.6", "0.95")))).isEqualTo(0.7600272463100223);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("inverse_beta_cdf", "0", "3", "0.5")::evaluate).hasMessage("a, b must be > 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("inverse_beta_cdf", "3", "0", "0.5")::evaluate).hasMessage("a, b must be > 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("inverse_beta_cdf", "3", "5", "-0.1")::evaluate).hasMessage("p must be 0 >= p >= 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("inverse_beta_cdf", "3", "5", "1.1")::evaluate).hasMessage("p must be 0 >= p >= 1");
    }

    @Test
    public void testBetaCdf() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("beta_cdf", "3", "3.6", "0.0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("beta_cdf", "3", "3.6", "1.0")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("beta_cdf", "3", "3.6", "0.3")))).isEqualTo(0.21764809997679938);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("beta_cdf", "3", "3.6", "0.9")))).isEqualTo(0.9972502881611551);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("beta_cdf", "0", "3", "0.5")::evaluate).hasMessage("a, b must be > 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("beta_cdf", "3", "0", "0.5")::evaluate).hasMessage("a, b must be > 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("beta_cdf", "3", "5", "-0.1")::evaluate).hasMessage("value must be 0 >= v >= 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("beta_cdf", "3", "5", "1.1")::evaluate).hasMessage("value must be 0 >= v >= 1");
    }

    @Test
    public void testWilsonInterval() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_lower", "-1", "100", "2.575")::evaluate).hasMessage("number of successes must not be negative");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_lower", "0", "0", "2.575")::evaluate).hasMessage("number of trials must be positive");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_lower", "10", "5", "2.575")::evaluate).hasMessage("number of successes must not be larger than number of trials");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_lower", "0", "100", "-1")::evaluate).hasMessage("z-score must not be negative");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("wilson_interval_lower", "1250", "1310", "1.96e0")))).isEqualTo(0.9414883725395894);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_upper", "-1", "100", "2.575")::evaluate).hasMessage("number of successes must not be negative");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_upper", "0", "0", "2.575")::evaluate).hasMessage("number of trials must be positive");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_upper", "10", "5", "2.575")::evaluate).hasMessage("number of successes must not be larger than number of trials");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("wilson_interval_upper", "0", "100", "-1")::evaluate).hasMessage("z-score must not be negative");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("wilson_interval_upper", "1250", "1310", "1.96e0")))).isEqualTo(0.9642524717143908);
    }
}

