/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestExtract {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void tearDown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2020'");
    }

    @Test
    public void testMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '5'");
    }

    @Test
    public void testWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '19'");
    }

    @Test
    public void testDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '10'");
    }

    @Test
    public void testDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '10'");
    }

    @Test
    public void testHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '12'");
    }

    @Test
    public void testMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '34'");
    }

    @Test
    public void testSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIMESTAMP '1500-05-10 12:34:56.123456789012')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123456789012')")))).matches("BIGINT '56'");
    }

    @Test
    public void testMillisecond() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this.assertions.expression("EXTRACT(MILLISECOND FROM TIMESTAMP '2020-05-10 12:34:56')")::evaluate).isInstanceOf(ParsingException.class)).hasMessage("line 1:12: Invalid EXTRACT field: MILLISECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '123'");
    }

    @Test
    public void testDayOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '7'");
    }

    @Test
    public void testDow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '7'");
    }

    @Test
    public void testDayOfYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '131'");
    }

    @Test
    public void testDoy() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '131'");
    }

    @Test
    public void testQuarter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2'");
    }

    @Test
    public void testWeekOfYear() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this.assertions.expression("EXTRACT(WEEK_OF_YEAR FROM TIMESTAMP '2020-05-10 12:34:56')")::evaluate).isInstanceOf(ParsingException.class)).hasMessage("line 1:12: Invalid EXTRACT field: WEEK_OF_YEAR");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '19'");
    }

    @Test
    public void testYearOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2020'");
    }

    @Test
    public void testYow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2020'");
    }

    @Test
    public void testUnsupported() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.1234567890')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.12345678901')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIMESTAMP '2020-05-10 12:34:56.123456789012')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }
}

