/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PageAssertions;
import io.trino.operator.PageTestUtils;
import io.trino.operator.unnest.TestingUnnesterUtil;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTaskContext;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestUnnestOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private static final int PAGE_COUNT = 2;
    private static final int POSITION_COUNT = 500;

    @BeforeEach
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterEach
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testUnnest() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        Type mapType = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 2, 3), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)4, (Object)5))).row(2L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 99), null).row(3L, null, null).pageBreak().row(6L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 7, 8), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)9, (Object)10, (Object)11, (Object)12))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), false, false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 2L, 4L, 5L}).row(new Object[]{1L, 3L, null, null}).row(new Object[]{2L, 99L, null, null}).row(new Object[]{6L, 7L, 9L, 10L}).row(new Object[]{6L, 8L, 11L, 12L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestWithArray() {
        ArrayType arrayType = new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT));
        Type mapType = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)new ArrayType((Type)BigintType.BIGINT).getTypeSignature(), (TypeSignature)new ArrayType((Type)BigintType.BIGINT).getTypeSignature()));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)2, (Object)4), ImmutableList.of((Object)3, (Object)6)), StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableMap.of((Object)ImmutableList.of((Object)4, (Object)8), (Object)ImmutableList.of((Object)5, (Object)10)))).row(2L, StructuralTestUtil.arrayBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)99, (Object)198)), null).row(3L, null, null).pageBreak().row(6, StructuralTestUtil.arrayBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)7, (Object)14), ImmutableList.of((Object)8, (Object)16)), StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableMap.of((Object)ImmutableList.of((Object)9, (Object)18), (Object)ImmutableList.of((Object)10, (Object)20), (Object)ImmutableList.of((Object)11, (Object)22), (Object)ImmutableList.of((Object)12, (Object)24)))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), false, false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)}).row(new Object[]{1L, ImmutableList.of((Object)2L, (Object)4L), ImmutableList.of((Object)4L, (Object)8L), ImmutableList.of((Object)5L, (Object)10L)}).row(new Object[]{1L, ImmutableList.of((Object)3L, (Object)6L), null, null}).row(new Object[]{2L, ImmutableList.of((Object)99L, (Object)198L), null, null}).row(new Object[]{6L, ImmutableList.of((Object)7L, (Object)14L), ImmutableList.of((Object)9L, (Object)18L), ImmutableList.of((Object)10L, (Object)20L)}).row(new Object[]{6L, ImmutableList.of((Object)8L, (Object)16L), ImmutableList.of((Object)11L, (Object)22L), ImmutableList.of((Object)12L, (Object)24L)}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestWithOrdinality() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        Type mapType = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 2, 3), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)4, (Object)5))).row(2L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 99), null).row(3L, null, null).pageBreak().row(6L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 7, 8), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)9, (Object)10, (Object)11, (Object)12))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), true, false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 2L, 4L, 5L, 1L}).row(new Object[]{1L, 3L, null, null, 2L}).row(new Object[]{2L, 99L, null, null, 1L}).row(new Object[]{6L, 7L, 9L, 10L, 1L}).row(new Object[]{6L, 8L, 11L, 12L, 2L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestNonNumericDoubles() {
        ArrayType arrayType = new ArrayType((Type)DoubleType.DOUBLE);
        Type mapType = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE, ImmutableMap.of((Object)1, (Object)Double.NEGATIVE_INFINITY, (Object)2, (Object)Double.POSITIVE_INFINITY, (Object)3, (Object)Double.NaN))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), false, false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{1L, Double.NEGATIVE_INFINITY, 1L, Double.NEGATIVE_INFINITY}).row(new Object[]{1L, Double.POSITIVE_INFINITY, 2L, Double.POSITIVE_INFINITY}).row(new Object[]{1L, Double.NaN, 3L, Double.NaN}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestWithArrayOfRows() {
        RowType elementType = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR));
        ArrayType arrayOfRowType = new ArrayType((Type)elementType);
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayOfRowType}).row(1, StructuralTestUtil.arrayBlockOf((Type)elementType, ImmutableList.of((Object)2, (Object)4.2, (Object)"abc"), ImmutableList.of((Object)3, (Object)6.6, (Object)"def"))).row(2, StructuralTestUtil.arrayBlockOf((Type)elementType, ImmutableList.of((Object)99, (Object)3.14, (Object)"pi"), null)).row(3, null).pageBreak().row(6, StructuralTestUtil.arrayBlockOf((Type)elementType, null, ImmutableList.of((Object)8, (Object)1.111, (Object)"tt"))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)arrayOfRowType), false, false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR}).row(new Object[]{1L, 2L, 4.2, "abc"}).row(new Object[]{1L, 3L, 6.6, "def"}).row(new Object[]{2L, 99L, 3.14, "pi"}).row(new Object[]{2L, null, null, null}).row(new Object[]{6L, null, null, null}).row(new Object[]{6L, 8L, 1.111, "tt"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testOuterUnnest() {
        Type mapType = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()));
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        RowType elementType = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR));
        ArrayType arrayOfRowType = new ArrayType((Type)elementType);
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, mapType, arrayType, arrayOfRowType}).row(1, StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)1, (Object)2)), StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 3), StructuralTestUtil.arrayBlockOf((Type)elementType, ImmutableList.of((Object)4, (Object)5.5, (Object)"a"), ImmutableList.of((Object)6, (Object)7.7, (Object)"b"))).row(2, null, null, null).pageBreak().row(3, null, null, null).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2, (Object)3), (List)ImmutableList.of((Object)mapType, (Object)arrayType, (Object)arrayOfRowType), false, true);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR}).row(new Object[]{1L, 1L, 2L, 3L, 4L, 5.5, "a"}).row(new Object[]{1L, null, null, null, 6L, 7.7, "b"}).row(new Object[]{2L, null, null, null, null, null, null}).row(new Object[]{3L, null, null, null, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testOuterUnnestWithOrdinality() {
        Type mapType = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()));
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        RowType elementType = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR));
        ArrayType arrayOfRowType = new ArrayType((Type)elementType);
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, mapType, arrayType, arrayOfRowType}).row(1, StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)1, (Object)2, (Object)6, (Object)7)), StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 3), StructuralTestUtil.arrayBlockOf((Type)elementType, ImmutableList.of((Object)4, (Object)5.5, (Object)"a"))).row(2, null, null, null).pageBreak().row(3, null, null, null).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2, (Object)3), (List)ImmutableList.of((Object)mapType, (Object)arrayType, (Object)arrayOfRowType), true, true);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, 1L, 2L, 3L, 4L, 5.5, "a", 1L}).row(new Object[]{1L, 6L, 7L, null, null, null, null, 2L}).row(new Object[]{2L, null, null, null, null, null, null, null}).row(new Object[]{3L, null, null, null, null, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestSingleArray() {
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnnestSingleMap() {
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)TestUnnestOperator.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)TestUnnestOperator.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)TestUnnestOperator.createMapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnnestSingleArrayWithEmptyInput() {
        Page emptyPage = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)new ArrayType((Type)BigintType.BIGINT))).build();
        this.testUnnest((List<Page>)ImmutableList.of((Object)emptyPage), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT)), false, false);
    }

    @Test
    public void testUnnestSingleArrayOfRow() {
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}))));
        this.testUnnest((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}))));
        this.testUnnest((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT), TestUnnestOperator.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)}))));
    }

    @Test
    public void testUnnestTwoArrays() {
        this.testUnnest((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)));
        DecimalType decimalType = DecimalType.createDecimalType((int)19);
        this.testUnnest((List<Type>)ImmutableList.of((Object)decimalType), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)decimalType), (Object)new ArrayType((Type)decimalType)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)));
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)VarcharType.VARCHAR)));
        Type bigintMapType = TestUnnestOperator.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        this.testUnnest((List<Type>)ImmutableList.of((Object)bigintMapType), (List<Type>)ImmutableList.of((Object)new ArrayType(bigintMapType), (Object)new ArrayType(bigintMapType)));
    }

    @Test
    public void testUnnestTwoMaps() {
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)TestUnnestOperator.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Object)TestUnnestOperator.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
    }

    @Test
    public void testUnnestTwoArraysOfRow() {
        RowType rowOfIntegers = RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER, IntegerType.INTEGER});
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)rowOfIntegers), (Object)new ArrayType((Type)rowOfIntegers)));
    }

    @Test
    public void testUnnestMultipleMixed() {
        this.testUnnest((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)TestUnnestOperator.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT})), (Object)new ArrayType((Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}))));
    }

    @Test
    public void testUnnestArrayOfRowsWithNulls() {
        VarcharType replicatedType = VarcharType.VARCHAR;
        RowType elementType = RowType.anonymousRow((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR});
        ArrayType unnestType = new ArrayType((Type)elementType);
        ImmutableList nonNullRowValue = ImmutableList.of((Object)"lalala", (Object)"lalala");
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, unnestType}).row("abc", StructuralTestUtil.arrayBlockOf((Type)elementType, Collections.nCopies(999, nonNullRowValue).toArray())).row("def", StructuralTestUtil.arrayBlockOf((Type)elementType, null, null)).build();
        this.testUnnest(input, (List<Type>)ImmutableList.of((Object)replicatedType), (List<Type>)ImmutableList.of((Object)unnestType), false, false);
    }

    protected void testUnnest(List<Type> replicatedTypes, List<Type> unnestTypes) {
        this.testUnnest(replicatedTypes, unnestTypes, 0.0f, (List<PageTestUtils.Wrapping>)ImmutableList.of());
        this.testUnnest(replicatedTypes, unnestTypes, 0.2f, (List<PageTestUtils.Wrapping>)ImmutableList.of());
        this.testUnnest(replicatedTypes, unnestTypes, 0.0f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.DICTIONARY)));
        this.testUnnest(replicatedTypes, unnestTypes, 0.0f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.RUN_LENGTH)));
        this.testUnnest(replicatedTypes, unnestTypes, 0.0f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.DICTIONARY), (Object)((Object)PageTestUtils.Wrapping.DICTIONARY)));
        this.testUnnest(replicatedTypes, unnestTypes, 0.0f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.RUN_LENGTH), (Object)((Object)PageTestUtils.Wrapping.DICTIONARY)));
        this.testUnnest(replicatedTypes, unnestTypes, 0.2f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.DICTIONARY)));
        this.testUnnest(replicatedTypes, unnestTypes, 0.2f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.RUN_LENGTH)));
        this.testUnnest(replicatedTypes, unnestTypes, 0.2f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.DICTIONARY), (Object)((Object)PageTestUtils.Wrapping.DICTIONARY)));
        this.testUnnest(replicatedTypes, unnestTypes, 0.2f, (List<PageTestUtils.Wrapping>)ImmutableList.of((Object)((Object)PageTestUtils.Wrapping.RUN_LENGTH), (Object)((Object)PageTestUtils.Wrapping.DICTIONARY)));
    }

    private void testUnnest(List<Type> replicatedTypes, List<Type> unnestTypes, float nullRate, List<PageTestUtils.Wrapping> wrappings) {
        ImmutableList types = ImmutableList.builder().addAll(replicatedTypes).addAll(unnestTypes).build();
        ArrayList<Page> inputPages = new ArrayList<Page>();
        for (int i = 0; i < 2; ++i) {
            Page inputPage = PageTestUtils.createRandomPage((List<Type>)types, 500, Optional.empty(), nullRate, wrappings);
            inputPages.add(inputPage);
        }
        this.testUnnest(inputPages, replicatedTypes, unnestTypes, false, false);
        this.testUnnest(inputPages, replicatedTypes, unnestTypes, true, false);
        this.testUnnest(inputPages, replicatedTypes, unnestTypes, false, true);
        this.testUnnest(inputPages, replicatedTypes, unnestTypes, true, true);
    }

    private void testUnnest(List<Page> inputPages, List<Type> replicatedTypes, List<Type> unnestTypes, boolean withOrdinality, boolean outer) {
        List replicatedChannels = (List)IntStream.range(0, replicatedTypes.size()).boxed().collect(ImmutableList.toImmutableList());
        List unnestChannels = (List)IntStream.range(replicatedTypes.size(), replicatedTypes.size() + unnestTypes.size()).boxed().collect(ImmutableList.toImmutableList());
        Operator unnestOperator = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), replicatedChannels, replicatedTypes, unnestChannels, unnestTypes, withOrdinality, outer).createOperator(this.createDriverContext());
        for (Page inputPage : inputPages) {
            Page outputPage;
            TestingUnnesterUtil.UnnestedLengths unnestedLengths = TestingUnnesterUtil.calculateMaxCardinalities(inputPage, replicatedTypes, unnestTypes, outer);
            List<Type> outputTypes = TestingUnnesterUtil.buildOutputTypes(replicatedTypes, unnestTypes, withOrdinality);
            Page expectedPage = TestingUnnesterUtil.buildExpectedPage(inputPage, replicatedTypes, unnestTypes, outputTypes, unnestedLengths, withOrdinality);
            unnestOperator.addInput(inputPage);
            ArrayList<Page> outputPages = new ArrayList<Page>();
            while ((outputPage = unnestOperator.getOutput()) != null) {
                Assert.assertTrue((outputPage.getPositionCount() <= 1000 ? 1 : 0) != 0);
                outputPages.add(outputPage);
            }
            Page mergedOutputPage = TestingUnnesterUtil.mergePages(outputTypes, outputPages);
            try {
                PageAssertions.assertPageEquals(outputTypes, mergedOutputPage, expectedPage);
            }
            catch (Throwable e) {
                System.out.println("withOrdinality: " + withOrdinality + ", outer: " + outer);
                System.out.println("Last index: " + (outputTypes.size() - 1));
                throw e;
            }
        }
    }

    private DriverContext createDriverContext() {
        Session testSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)testSession).addPipelineContext(0, true, true, false).addDriverContext();
    }

    private static Type createMapType(Type keyType, Type valueType) {
        return InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)keyType.getTypeSignature(), (TypeSignature)valueType.getTypeSignature()));
    }
}

