/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.node.NodeInfo;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.security.Keys;
import io.trino.client.OkHttpUtil;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.ProtocolConfig;
import io.trino.server.protocol.PreparedStatementEncoder;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.jwt.JwtUtil;
import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.TokenPairSerializer;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.server.ui.FormAuthenticator;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PasswordAuthenticator;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.crypto.SecretKey;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestWebUi {
    private static final String LOCALHOST_KEYSTORE = Resources.getResource((String)"cert/localhost.pem").getPath();
    private static final String ALLOWED_USER_MAPPING_PATTERN = "(.*)@allowed";
    private static final ImmutableMap<String, String> SECURE_PROPERTIES = ImmutableMap.builder().put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.process-forwarded", (Object)"true").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").buildOrThrow();
    private static final String STATE_KEY = "test-state-key";
    public static final String TOKEN_ISSUER = "http://example.com/";
    public static final String OAUTH_CLIENT_ID = "client";
    private static final ImmutableMap<String, String> OAUTH2_PROPERTIES = ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.authentication.oauth2.state-key", (Object)"test-state-key").put((Object)"http-server.authentication.oauth2.issuer", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.token-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.client-id", (Object)"client").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"client-secret").put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"false").buildOrThrow();
    private static final String TEST_USER = "test-user";
    private static final String AUTHENTICATED_USER = "test-user@allowed";
    private static final String FORM_LOGIN_USER = "form-login-user";
    private static final String TEST_PASSWORD = "test-password";
    private static final String TEST_PASSWORD2 = "test-password2";
    private static final String HMAC_KEY = Resources.getResource((String)"hmac_key.txt").getPath();
    private static final PrivateKey JWK_PRIVATE_KEY;
    private static final String REFRESH_TOKEN = "REFRESH_TOKEN";
    private static final Duration REFRESH_TOKEN_TIMEOUT;
    private OkHttpClient client;
    private Path passwordConfigDummy;

    @BeforeAll
    public void setup() throws IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(false);
        OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), (boolean)false);
        this.client = clientBuilder.build();
        this.passwordConfigDummy = Files.createTempFile("passwordConfigDummy", "", new FileAttribute[0]);
        this.passwordConfigDummy.toFile().deleteOnExit();
    }

    @Test
    public void testInsecureAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.insecure.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).setAdditionalModule(binder -> JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class)).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD, false);
        }
    }

    @Test
    public void testPasswordAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"PaSSworD").put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).setAdditionalModule(binder -> JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class)).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestWebUi::authenticate});
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD, true);
        }
    }

    @Test
    public void testMultiplePasswordAuthenticators() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).setAdditionalModule(binder -> JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class)).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestWebUi::authenticate, TestWebUi::authenticate2});
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD, true);
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD2, true);
        }
    }

    private void testFormAuthentication(TestingTrinoServer server, HttpServerInfo httpServerInfo, String username, String password, boolean sendPasswordForHttps) throws Exception {
        TestWebUi.testRootRedirect(httpServerInfo.getHttpUri(), this.client);
        TestWebUi.testRootRedirect(httpServerInfo.getHttpsUri(), this.client);
        String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
        this.testWorkerResource(nodeId, httpServerInfo.getHttpUri(), username, password, false);
        this.testWorkerResource(nodeId, httpServerInfo.getHttpsUri(), username, password, sendPasswordForHttps);
        this.testLoggedOut(httpServerInfo.getHttpUri());
        this.testLoggedOut(httpServerInfo.getHttpsUri());
        this.testLogIn(httpServerInfo.getHttpUri(), username, password, false);
        this.testLogIn(httpServerInfo.getHttpsUri(), username, password, sendPasswordForHttps);
        this.testFailedLogin(httpServerInfo.getHttpUri(), false, password);
        this.testFailedLogin(httpServerInfo.getHttpsUri(), sendPasswordForHttps, password);
        this.testUserMapping(httpServerInfo.getHttpsUri(), username, password, sendPasswordForHttps);
    }

    private static void testRootRedirect(URI baseUri, OkHttpClient client) throws IOException {
        TestWebUi.assertRedirect(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).toString(), TestWebUi.getUiLocation(baseUri));
    }

    private void testLoggedOut(URI baseUri) throws IOException {
        TestWebUi.assertRedirect(this.client, TestWebUi.getUiLocation(baseUri), TestWebUi.getLoginHtmlLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLocation(baseUri, "/ui/query.html", "abc123"), TestWebUi.getLocation(baseUri, "/ui/login.html", "/ui/query.html?abc123"), false);
        TestWebUi.assertResponseCode(this.client, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertOk(this.client, TestWebUi.getValidAssetsLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidVendorLocation(baseUri));
    }

    private void testLogIn(URI baseUri, String username, String password, boolean sendPassword) throws Exception {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        String body = TestWebUi.assertOk(client, TestWebUi.getLoginHtmlLocation(baseUri)).orElseThrow(() -> new AssertionError((Object)"No response body"));
        Assertions.assertThat((String)body).contains(new CharSequence[]{"action=\"/ui/login\""});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"method=\"post\""});
        Assertions.assertThat((String)body).doesNotContain(new CharSequence[]{"// This value will be replaced"});
        if (sendPassword) {
            Assertions.assertThat((String)body).contains(new CharSequence[]{"var hidePassword = false;"});
        } else {
            Assertions.assertThat((String)body).contains(new CharSequence[]{"var hidePassword = true;"});
        }
        TestWebUi.logIn(baseUri, client, username, password, sendPassword);
        HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
        Assert.assertEquals((String)cookie.getPath(), (String)"/ui");
        Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
        Assert.assertEquals((long)cookie.getMaxAge(), (long)-1L);
        Assert.assertTrue((boolean)cookie.isHttpOnly());
        TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
        TestWebUi.assertRedirect(client, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getLoginHtmlLocation(baseUri), false);
        Assertions.assertThat(cookieManager.getCookieStore().getCookies()).isEmpty();
    }

    private void testFailedLogin(URI uri, boolean passwordAllowed, String password) throws IOException {
        this.testFailedLogin(uri, Optional.empty(), Optional.empty());
        this.testFailedLogin(uri, Optional.empty(), Optional.of(password));
        this.testFailedLogin(uri, Optional.empty(), Optional.of("unknown"));
        if (passwordAllowed) {
            this.testFailedLogin(uri, Optional.of(TEST_USER), Optional.of("unknown"));
            this.testFailedLogin(uri, Optional.of(AUTHENTICATED_USER), Optional.of("unknown"));
            this.testFailedLogin(uri, Optional.of(FORM_LOGIN_USER), Optional.of("unknown"));
            this.testFailedLogin(uri, Optional.of("unknown"), Optional.of(password));
            this.testFailedLogin(uri, Optional.of(TEST_USER), Optional.empty());
            this.testFailedLogin(uri, Optional.of(AUTHENTICATED_USER), Optional.empty());
            this.testFailedLogin(uri, Optional.of(FORM_LOGIN_USER), Optional.empty());
            this.testFailedLogin(uri, Optional.of("unknown"), Optional.empty());
        }
    }

    private void testFailedLogin(URI httpsUrl, Optional<String> username, Optional<String> password) throws IOException {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        FormBody.Builder formData = new FormBody.Builder();
        username.ifPresent(value -> formData.add("username", value));
        password.ifPresent(value -> formData.add("password", value));
        Request request = new Request.Builder().url(TestWebUi.getLoginLocation(httpsUrl)).post((RequestBody)formData.build()).build();
        try (okhttp3.Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)303);
            Assert.assertEquals((String)response.header("Location"), (String)TestWebUi.getLoginHtmlLocation(httpsUrl));
            Assert.assertTrue((boolean)cookieManager.getCookieStore().getCookies().isEmpty());
        }
    }

    private void testWorkerResource(String nodeId, URI baseUri, String username, String password, boolean sendPassword) throws Exception {
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager())).build();
        TestWebUi.logIn(baseUri, client, username, password, sendPassword);
        TestWebUi.testWorkerResource(nodeId, baseUri, client);
    }

    private static void testWorkerResource(String nodeId, URI baseUri, OkHttpClient authorizedClient) throws IOException {
        TestWebUi.assertOk(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/worker/" + nodeId + "/status"));
        TestWebUi.assertOk(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/worker/" + nodeId + "/thread"));
    }

    private void testUserMapping(URI baseUri, String username, String password, boolean sendPassword) throws Exception {
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager())).build();
        TestWebUi.logIn(baseUri, client, username, password, sendPassword);
        Request request = new Request.Builder().url(TestWebUi.getLocation(baseUri, "/ui/username/")).build();
        try (okhttp3.Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)200);
            Assert.assertEquals((String)response.header("user"), (String)TEST_USER);
        }
    }

    private static void logIn(URI baseUri, OkHttpClient client, String username, String password, boolean sendPassword) throws IOException {
        FormBody.Builder formData = new FormBody.Builder().add("username", username);
        if (sendPassword) {
            formData.add("password", password);
        }
        Request request = new Request.Builder().url(TestWebUi.getLoginLocation(baseUri)).post((RequestBody)formData.build()).build();
        okhttp3.Response response = client.newCall(request).execute();
        Assert.assertEquals((int)response.code(), (int)303);
        Assert.assertEquals((String)response.header("Location"), (String)TestWebUi.getUiLocation(baseUri));
    }

    @Test
    public void testDisabled() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.enabled", (Object)"false").buildOrThrow()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testDisabled(httpServerInfo.getHttpUri());
            this.testDisabled(httpServerInfo.getHttpsUri());
        }
    }

    private void testDisabled(URI baseUri) throws Exception {
        TestWebUi.assertRedirect(this.client, TestWebUi.getUiLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLocation(baseUri, "/ui/query.html", "abc123"), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertResponseCode(this.client, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertRedirect(this.client, TestWebUi.getLoginLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidAssetsLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidVendorLocation(baseUri));
    }

    @Test
    public void testNoPasswordAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).buildOrThrow()).build();){
            FormAuthenticator formAuthenticator = (FormAuthenticator)server.getInstance(com.google.inject.Key.get(FormAuthenticator.class));
            Assertions.assertThatThrownBy(() -> formAuthenticator.isValidCredential(TEST_USER, TEST_USER, true)).hasMessage("authenticators were not loaded").isInstanceOf(IllegalStateException.class);
            Assert.assertTrue((boolean)formAuthenticator.isLoginEnabled(true));
        }
    }

    @Test
    public void testFixedAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.authentication.type", (Object)"fixed").put((Object)"web-ui.user", (Object)TEST_USER).buildOrThrow()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpUri(), this.client, nodeId);
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), this.client, nodeId);
            this.testFixedAuthenticator(httpServerInfo.getHttpUri());
            this.testFixedAuthenticator(httpServerInfo.getHttpsUri());
        }
    }

    private void testFixedAuthenticator(URI baseUri) throws Exception {
        TestWebUi.assertOk(this.client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(this.client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(this.client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
    }

    @Test
    public void testCertAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"certificate").put((Object)"http-server.https.truststore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.truststore.key", (Object)"").buildOrThrow()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), FORM_LOGIN_USER, TEST_PASSWORD, false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            OkHttpClient.Builder clientBuilder = this.client.newBuilder();
            OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), (boolean)false);
            OkHttpClient clientWithCert = clientBuilder.build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithCert, nodeId);
        }
    }

    @Test
    public void testJwtAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)HMAC_KEY).buildOrThrow()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), FORM_LOGIN_USER, TEST_PASSWORD, false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            SecretKey hmac = Keys.hmacShaKeyFor((byte[])Base64.getDecoder().decode(Files.readString(Paths.get(HMAC_KEY, new String[0])).trim()));
            String token = JwtUtil.newJwtBuilder().signWith((Key)hmac).setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithJwt, nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJwtWithJwkAuthenticator() throws Exception {
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)jwkServer.getBaseUrl().toString()).buildOrThrow()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), FORM_LOGIN_USER, TEST_PASSWORD, false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            String token = JwtUtil.newJwtBuilder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)"test-rsa").setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithJwt, nodeId);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2Authenticator() throws Exception {
        OAuth2ClientStub oauthClient = new OAuth2ClientStub();
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).buildOrThrow()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)oauthClient)).build();){
            this.assertAuth2Authentication(server, oauthClient.getAccessToken(), oauthClient.getIdToken(), false, true);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2AuthenticatorWithoutOpenIdScope() throws Exception {
        OAuth2ClientStub oauthClient = new OAuth2ClientStub(false, Duration.ofSeconds(5L));
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.scopes", (Object)"").buildOrThrow()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)oauthClient)).build();){
            this.assertAuth2Authentication(server, oauthClient.getAccessToken(), Optional.empty(), false, true);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2AuthenticatorWithRefreshToken() throws Exception {
        OAuth2ClientStub oauthClient = new OAuth2ClientStub(false, Duration.ofSeconds(5L));
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.refresh-tokens", (Object)"true").put((Object)"http-server.authentication.oauth2.refresh-tokens.issued-token.timeout", (Object)(REFRESH_TOKEN_TIMEOUT.getSeconds() + "s")).buildOrThrow()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)oauthClient)).build();){
            this.assertAuth2Authentication(server, oauthClient.getAccessToken(), oauthClient.getIdToken(), true, true);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2AuthenticatorRedirectAfterAuthTokenRefresh() throws Exception {
        OAuth2ClientStub oauthClient = new OAuth2ClientStub(false, Duration.ZERO);
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.refresh-tokens", (Object)"true").put((Object)"http-server.authentication.oauth2.refresh-tokens.issued-token.timeout", (Object)(REFRESH_TOKEN_TIMEOUT.getSeconds() + "s")).buildOrThrow()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)oauthClient)).build();){
            CookieManager cookieManager = new CookieManager();
            OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            URI baseUri = httpServerInfo.getHttpsUri();
            TestWebUi.loginWithCallbackEndpoint(client, baseUri);
            HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
            TestWebUi.assertCookieWithRefreshToken(server, cookie, oauthClient.getAccessToken());
            TestWebUi.assertResponseCode(client, TestWebUi.getValidApiLocation(baseUri), 307);
            TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2AuthenticatorRefreshTokenExpiration() throws Exception {
        OAuth2ClientStub oauthClient = new OAuth2ClientStub(false, Duration.ofSeconds(5L));
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.refresh-tokens", (Object)"true").put((Object)"http-server.authentication.oauth2.refresh-tokens.issued-token.timeout", (Object)"10s").buildOrThrow()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)oauthClient)).build();){
            CookieManager cookieManager = new CookieManager();
            OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            URI baseUri = httpServerInfo.getHttpsUri();
            TestWebUi.loginWithCallbackEndpoint(client, baseUri);
            HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
            TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
            io.trino.testing.assertions.Assert.assertEventually(() -> Assertions.assertThat(cookieManager.getCookieStore().getCookies()).isEmpty());
            TestWebUi.assertResponseCode(client, TestWebUi.getValidApiLocation(baseUri), Response.Status.UNAUTHORIZED.getStatusCode());
            HttpCookie biscuit = new HttpCookie(cookie.getName(), cookie.getValue());
            biscuit.setPath(cookie.getPath());
            cookieManager.getCookieStore().add(baseUri, biscuit);
            TestWebUi.assertResponseCode(client, TestWebUi.getValidApiLocation(baseUri), Response.Status.UNAUTHORIZED.getStatusCode());
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomPrincipalField() throws Exception {
        OAuth2ClientStub oauthClient = new OAuth2ClientStub((Map<String, String>)ImmutableMap.builder().put((Object)"sub", (Object)"unknown").put((Object)"preferred_username", (Object)"test-user@email.com").buildOrThrow(), Duration.ofSeconds(5L), true, true);
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.principal-field", (Object)"preferred_username").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@.*").buildOrThrow()).setAdditionalModule(binder -> {
            OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)oauthClient);
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(AuthenticatedIdentityCapturingFilter.class);
        }).build();){
            this.assertAuth2Authentication(server, oauthClient.getAccessToken(), oauthClient.getIdToken(), false, true);
            Identity identity = ((AuthenticatedIdentityCapturingFilter)server.getInstance(com.google.inject.Key.get(AuthenticatedIdentityCapturingFilter.class))).getAuthenticatedIdentity();
            Assertions.assertThat((String)identity.getUser()).isEqualTo(TEST_USER);
            Assertions.assertThat((Optional)identity.getPrincipal()).isEqualTo(Optional.of(new BasicPrincipal("test-user@email.com")));
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2AuthenticatorWithoutEndSessionEndpoint() throws Exception {
        OAuth2ClientStub oauthClient = new OAuth2ClientStub((Map<String, String>)ImmutableMap.of(), Duration.ofSeconds(5L), false, false);
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.scopes", (Object)"").buildOrThrow()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)oauthClient)).build();){
            this.assertAuth2Authentication(server, oauthClient.getAccessToken(), oauthClient.getIdToken(), false, false);
        }
        finally {
            jwkServer.stop();
        }
    }

    private void assertAuth2Authentication(TestingTrinoServer server, String accessToken, Optional<String> idToken, boolean refreshTokensEnabled, boolean supportsEndSessionEndpoint) throws Exception {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
        this.testDisabled(httpServerInfo.getHttpUri());
        URI baseUri = httpServerInfo.getHttpsUri();
        TestWebUi.testRootRedirect(baseUri, client);
        TestWebUi.assertRedirect(client, TestWebUi.getUiLocation(baseUri), "http://example.com/authorize", false);
        TestWebUi.assertResponseCode(client, TestWebUi.getValidApiLocation(baseUri), Response.Status.UNAUTHORIZED.getStatusCode());
        TestWebUi.assertRedirect(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), "http://example.com/authorize", false);
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), Response.Status.UNAUTHORIZED.getStatusCode());
        TestWebUi.loginWithCallbackEndpoint(client, baseUri);
        HttpCookie cookie = TestWebUi.getCookie(cookieManager, "__Secure-Trino-OAuth2-Token");
        if (refreshTokensEnabled) {
            TestWebUi.assertCookieWithRefreshToken(server, cookie, accessToken);
        } else {
            Assert.assertEquals((String)cookie.getValue(), (String)accessToken);
            Assertions.assertThat((long)cookie.getMaxAge()).isGreaterThan(0L).isLessThan(30L);
        }
        Assert.assertEquals((String)cookie.getPath(), (String)"/ui/");
        Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
        Assert.assertTrue((boolean)cookie.isHttpOnly());
        if (idToken.isPresent()) {
            HttpCookie idTokenCookie = TestWebUi.getCookie(cookieManager, "__Secure-Trino-ID-Token");
            Assert.assertEquals((String)idTokenCookie.getValue(), (String)idToken.get());
            Assert.assertEquals((String)idTokenCookie.getPath(), (String)"/ui/");
            Assert.assertEquals((String)idTokenCookie.getDomain(), (String)baseUri.getHost());
            Assert.assertTrue((idTokenCookie.getMaxAge() > 0L && cookie.getMaxAge() < TimeUnit.MINUTES.toSeconds(5L) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)idTokenCookie.isHttpOnly());
        } else {
            Assertions.assertThatThrownBy(() -> TestWebUi.getCookie(cookieManager, "__Secure-Trino-ID-Token")).hasMessageContaining("No value present");
        }
        TestWebUi.testRootRedirect(baseUri, client);
        TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
        Request request = new Request.Builder().url(HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath("/ui/logout/").toString()).build();
        try (okhttp3.Response response = client.newCall(request).execute();){
            String expectedRedirect = HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath("ui/logout/logout.html").toString();
            if (supportsEndSessionEndpoint) {
                UriBuilder uriBuilder = UriBuilder.fromUri((String)"http://example.com/oauth2/v1/logout");
                idToken.ifPresent(token -> uriBuilder.queryParam("id_token_hint", new Object[]{token}));
                uriBuilder.queryParam("post_logout_redirect_uri", new Object[]{expectedRedirect});
                expectedRedirect = uriBuilder.build(new Object[0]).toString();
            }
            Assert.assertEquals((int)response.code(), (int)303);
            String locationHeader = response.header("Location");
            Assert.assertNotNull((Object)locationHeader);
            Assert.assertEquals((String)locationHeader, (String)expectedRedirect);
            Assertions.assertThat(cookieManager.getCookieStore().getCookies()).isEmpty();
        }
        TestWebUi.assertRedirect(client, TestWebUi.getUiLocation(baseUri), "http://example.com/authorize", false);
    }

    private static void loginWithCallbackEndpoint(OkHttpClient client, URI baseUri) throws IOException {
        String state = JwtUtil.newJwtBuilder().signWith((Key)Keys.hmacShaKeyFor((byte[])Hashing.sha256().hashString((CharSequence)STATE_KEY, StandardCharsets.UTF_8).asBytes())).setAudience("trino_oauth_ui").setExpiration(Date.from(ZonedDateTime.now().plusMinutes(10L).toInstant())).compact();
        TestWebUi.assertRedirect(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath("/oauth2/callback").addParameter("code", new String[]{"TEST_CODE"}).addParameter("state", new String[]{state}).toString(), TestWebUi.getUiLocation(baseUri), false);
    }

    private static void assertCookieWithRefreshToken(TestingTrinoServer server, HttpCookie authCookie, String accessToken) {
        TokenPairSerializer tokenPairSerializer = (TokenPairSerializer)server.getInstance(com.google.inject.Key.get(TokenPairSerializer.class));
        TokenPairSerializer.TokenPair deserialize = tokenPairSerializer.deserialize(authCookie.getValue());
        Assert.assertEquals((String)deserialize.accessToken(), (String)accessToken);
        Assert.assertEquals((Object)deserialize.refreshToken(), Optional.of(REFRESH_TOKEN));
        Assertions.assertThat((long)authCookie.getMaxAge()).isGreaterThan(0L).isLessThan(REFRESH_TOKEN_TIMEOUT.getSeconds());
    }

    private static void testAlwaysAuthorized(URI baseUri, OkHttpClient authorizedClient, String nodeId) throws IOException {
        TestWebUi.testRootRedirect(baseUri, authorizedClient);
        TestWebUi.testWorkerResource(nodeId, baseUri, authorizedClient);
        TestWebUi.assertOk(authorizedClient, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(authorizedClient, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLoginHtmlLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLoginLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertResponseCode(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
    }

    private static void testNeverAuthorized(URI baseUri, OkHttpClient notAuthorizedClient) throws IOException {
        TestWebUi.testRootRedirect(baseUri, notAuthorizedClient);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getUiLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLoginLocation(baseUri), 401, true);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLogoutLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLocation(baseUri, "/ui/unknown"), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 401);
    }

    private static Optional<String> assertOk(OkHttpClient client, String url) throws IOException {
        return TestWebUi.assertResponseCode(client, url, 200);
    }

    private static void assertRedirect(OkHttpClient client, String url, String redirectLocation) throws IOException {
        TestWebUi.assertRedirect(client, url, redirectLocation, true);
    }

    private static void assertRedirect(OkHttpClient client, String url, String redirectLocation, boolean testProxy) throws IOException {
        Request request = new Request.Builder().url(url).build();
        if (url.endsWith("/ui/login")) {
            FormBody formBody = new FormBody.Builder().add("username", "test").add("password", "test").build();
            request = request.newBuilder().post((RequestBody)formBody).build();
        }
        try (okhttp3.Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)303);
            Assert.assertEquals((String)response.header("Location"), (String)redirectLocation);
        }
        if (testProxy) {
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Host", "my-load-balancer.local").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Host", "my-load-balancer.local:123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local:123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").defaultPort().toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    private static Optional<String> assertResponseCode(OkHttpClient client, String url, int expectedCode) throws IOException {
        return TestWebUi.assertResponseCode(client, url, expectedCode, false);
    }

    private static Optional<String> assertResponseCode(OkHttpClient client, String url, int expectedCode, boolean postLogin) throws IOException {
        Request request = new Request.Builder().url(url).build();
        if (postLogin) {
            FormBody formBody = new FormBody.Builder().add("username", "fake").add("password", "bad").build();
            request = request.newBuilder().post((RequestBody)formBody).build();
        }
        try (okhttp3.Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)expectedCode, (String)url);
            Optional<String> optional = Optional.ofNullable(response.body()).map(responseBody -> {
                try {
                    return responseBody.string();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return optional;
        }
    }

    private static Principal authenticate(String user, String password) {
        if (AUTHENTICATED_USER.equals(user) && TEST_PASSWORD.equals(password)) {
            return new BasicPrincipal(AUTHENTICATED_USER);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static Principal authenticate2(String user, String password) {
        if (AUTHENTICATED_USER.equals(user) && TEST_PASSWORD2.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static String getUiLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/");
    }

    private static String getLoginHtmlLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/login.html");
    }

    private static String getLoginLocation(URI httpsUrl) {
        return TestWebUi.getLocation(httpsUrl, "/ui/login");
    }

    private static String getLogoutLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/logout");
    }

    private static String getDisabledLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/disabled.html");
    }

    private static String getValidApiLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/api/cluster");
    }

    private static String getValidAssetsLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/assets/favicon.ico");
    }

    private static String getValidVendorLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/vendor/bootstrap/css/bootstrap.css");
    }

    private static String getLocation(URI baseUri, String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).toString();
    }

    private static String getLocation(URI baseUri, String path, String query) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).replaceParameter(query, new String[0]).toString();
    }

    private static TestingHttpServer createTestingJwkServer() throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)new JwkServlet(), (Map)ImmutableMap.of());
    }

    private static HttpCookie getCookie(CookieManager cookieManager, String cookieName) {
        return cookieManager.getCookieStore().getCookies().stream().filter(cookie -> cookie.getName().equals(cookieName)).findFirst().orElseThrow();
    }

    static {
        REFRESH_TOKEN_TIMEOUT = Duration.ofMinutes(1L);
        try {
            JWK_PRIVATE_KEY = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-private.pem").toURI()), Optional.empty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class OAuth2ClientStub
    implements OAuth2Client {
        private static final SecureRandom secureRandom = new SecureRandom();
        private final Claims claims = new DefaultClaims((Map)OAuth2ClientStub.createClaims());
        private final String accessToken;
        private final Duration accessTokenValidity;
        private final Optional<String> nonce;
        private final Optional<String> idToken;
        private final boolean supportsEndsessionEndpoint;

        public OAuth2ClientStub() {
            this(true, Duration.ofSeconds(5L));
        }

        public OAuth2ClientStub(boolean issueIdToken, Duration accessTokenValidity) {
            this((Map<String, String>)ImmutableMap.of(), accessTokenValidity, issueIdToken, true);
        }

        public OAuth2ClientStub(Map<String, String> additionalClaims, Duration accessTokenValidity, boolean issueIdToken, boolean supportsEndsessionEnpoint) {
            this.claims.putAll(Objects.requireNonNull(additionalClaims, "additionalClaims is null"));
            this.accessTokenValidity = Objects.requireNonNull(accessTokenValidity, "accessTokenValidity is null");
            this.accessToken = OAuth2ClientStub.issueToken(this.claims);
            if (issueIdToken) {
                this.nonce = Optional.of(OAuth2ClientStub.randomNonce());
                this.idToken = Optional.of(OAuth2ClientStub.issueToken((Claims)new DefaultClaims((Map)ImmutableMap.builder().putAll((Map)this.claims).put((Object)"nonce", (Object)this.nonce.get()).buildOrThrow())));
            } else {
                this.nonce = Optional.empty();
                this.idToken = Optional.empty();
            }
            this.supportsEndsessionEndpoint = supportsEndsessionEnpoint;
        }

        public void load() {
        }

        public OAuth2Client.Request createAuthorizationRequest(String state, URI callbackUri) {
            return new OAuth2Client.Request(URI.create("http://example.com/authorize"), this.nonce);
        }

        public OAuth2Client.Response getOAuth2Response(String code, URI callbackUri, Optional<String> nonce) {
            if (!"TEST_CODE".equals(code)) {
                throw new IllegalArgumentException("Expected TEST_CODE");
            }
            return new OAuth2Client.Response(this.accessToken, Instant.now().plus(this.accessTokenValidity), this.idToken, Optional.of(TestWebUi.REFRESH_TOKEN));
        }

        public Optional<Map<String, Object>> getClaims(String accessToken) {
            return Optional.of(this.claims);
        }

        public OAuth2Client.Response refreshTokens(String refreshToken) throws ChallengeFailedException {
            if (refreshToken.equals(TestWebUi.REFRESH_TOKEN)) {
                return new OAuth2Client.Response(OAuth2ClientStub.issueToken(this.claims), Instant.now().plusSeconds(30L), this.idToken, Optional.of(TestWebUi.REFRESH_TOKEN));
            }
            throw new ChallengeFailedException("invalid refresh token");
        }

        public Optional<URI> getLogoutEndpoint(Optional<String> idToken, URI callbackUrl) {
            if (this.supportsEndsessionEndpoint) {
                UriBuilder builder = UriBuilder.fromUri((String)"http://example.com/oauth2/v1/logout");
                idToken.ifPresent(token -> builder.queryParam("id_token_hint", new Object[]{token}));
                builder.queryParam("post_logout_redirect_uri", new Object[]{callbackUrl});
                return Optional.of(builder.build(new Object[0]));
            }
            return Optional.empty();
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Optional<String> getIdToken() {
            return this.idToken;
        }

        private static String issueToken(Claims claims) {
            return JwtUtil.newJwtBuilder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)"test-rsa").setClaims(claims).compact();
        }

        private static Claims createClaims() {
            return new DefaultClaims().setIssuer(TestWebUi.TOKEN_ISSUER).setAudience(TestWebUi.OAUTH_CLIENT_ID).setSubject(TestWebUi.TEST_USER).setExpiration(Date.from(Instant.now().plus(Duration.ofMinutes(5L))));
        }

        public static String randomNonce() {
            byte[] bytes = new byte[32];
            secureRandom.nextBytes(bytes);
            return BaseEncoding.base64Url().encode(bytes);
        }
    }

    private static class AuthenticatedIdentityCapturingFilter
    implements ContainerRequestFilter {
        @GuardedBy(value="this")
        private Identity authenticatedIdentity;

        private AuthenticatedIdentityCapturingFilter() {
        }

        public synchronized void filter(ContainerRequestContext request) throws IOException {
            Optional<Identity> identity = Optional.ofNullable((Identity)request.getProperty("trino.authenticated-identity"));
            if (identity.map(Identity::getUser).filter(Predicate.not("<internal>"::equals)).isPresent()) {
                if (this.authenticatedIdentity == null) {
                    this.authenticatedIdentity = identity.get();
                }
                Preconditions.checkState((boolean)this.authenticatedIdentity.equals((Object)identity.get()), (Object)"Detected more than one user identity");
            }
        }

        public synchronized Identity getAuthenticatedIdentity() {
            return this.authenticatedIdentity;
        }
    }

    private static class JwkServlet
    extends HttpServlet {
        private JwkServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
            response.getWriter().println(jwkKeys);
        }
    }

    @jakarta.ws.rs.Path(value="/ui/username")
    public static class TestResource {
        private final HttpRequestSessionContextFactory sessionContextFactory;

        @Inject
        public TestResource(AccessControl accessControl) {
            this.sessionContextFactory = new HttpRequestSessionContextFactory(new PreparedStatementEncoder(new ProtocolConfig()), (Metadata)MetadataManager.createTestMetadataManager(), ImmutableSet::of, accessControl);
        }

        @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
        @GET
        public Response echoToken(@Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
            Identity identity = this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, Optional.empty());
            return Response.ok().header("user", (Object)identity.getUser()).build();
        }
    }
}

