/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.split.BufferingSplitSource;
import io.trino.split.MockSplitSource;
import io.trino.split.SplitSource;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestBufferingSplitSource {
    @Test
    public void testSlowSource() {
        MockSplitSource mockSource = new MockSplitSource().setBatchSize(1).increaseAvailableSplits(25).atSplitCompletion(MockSplitSource.Action.FINISH);
        try (BufferingSplitSource source = new BufferingSplitSource((SplitSource)mockSource, 10);){
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 20)).assertSize(10).assertNoMoreSplits(false);
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 6)).assertSize(6).assertNoMoreSplits(false);
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 20)).assertSize(9).assertNoMoreSplits(true);
            Assert.assertTrue((boolean)source.isFinished());
            Assert.assertEquals((int)mockSource.getNextBatchInvocationCount(), (int)25);
        }
    }

    @Test
    public void testFastSource() {
        MockSplitSource mockSource = new MockSplitSource().setBatchSize(11).increaseAvailableSplits(22).atSplitCompletion(MockSplitSource.Action.FINISH);
        try (BufferingSplitSource source = new BufferingSplitSource((SplitSource)mockSource, 10);){
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 200)).assertSize(11).assertNoMoreSplits(false);
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 200)).assertSize(11).assertNoMoreSplits(true);
            Assert.assertTrue((boolean)source.isFinished());
            Assert.assertEquals((int)mockSource.getNextBatchInvocationCount(), (int)2);
        }
    }

    @Test
    public void testEmptySource() {
        MockSplitSource mockSource = new MockSplitSource().setBatchSize(1).atSplitCompletion(MockSplitSource.Action.FINISH);
        try (BufferingSplitSource source = new BufferingSplitSource((SplitSource)mockSource, 100);){
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 200)).assertSize(0).assertNoMoreSplits(true);
            Assert.assertTrue((boolean)source.isFinished());
            Assert.assertEquals((int)mockSource.getNextBatchInvocationCount(), (int)1);
        }
    }

    @Test
    public void testBlocked() {
        ListenableFuture<NextBatchResult> nextBatchFuture;
        MockSplitSource mockSource = new MockSplitSource().setBatchSize(1);
        try (BufferingSplitSource source = new BufferingSplitSource((SplitSource)mockSource, 10);){
            nextBatchFuture = TestBufferingSplitSource.getNextBatch((SplitSource)source, 10);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.increaseAvailableSplits(9);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.increaseAvailableSplits(1);
            TestBufferingSplitSource.requireFutureValue(nextBatchFuture).assertSize(10).assertNoMoreSplits(false);
            nextBatchFuture = TestBufferingSplitSource.getNextBatch((SplitSource)source, 10);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.atSplitCompletion(MockSplitSource.Action.FINISH);
            TestBufferingSplitSource.requireFutureValue(nextBatchFuture).assertSize(0).assertNoMoreSplits(true);
            Assert.assertTrue((boolean)source.isFinished());
        }
        mockSource = new MockSplitSource().setBatchSize(1);
        source = new BufferingSplitSource((SplitSource)mockSource, 10);
        try {
            mockSource.increaseAvailableSplits(1);
            nextBatchFuture = TestBufferingSplitSource.getNextBatch((SplitSource)source, 10);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.increaseAvailableSplits(9);
            TestBufferingSplitSource.requireFutureValue(nextBatchFuture).assertSize(10).assertNoMoreSplits(false);
            nextBatchFuture = TestBufferingSplitSource.getNextBatch((SplitSource)source, 10);
            mockSource.increaseAvailableSplits(5);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.atSplitCompletion(MockSplitSource.Action.FINISH);
            TestBufferingSplitSource.requireFutureValue(nextBatchFuture).assertSize(5).assertNoMoreSplits(true);
            Assert.assertTrue((boolean)source.isFinished());
        }
        finally {
            source.close();
        }
        mockSource = new MockSplitSource().setBatchSize(1);
        source = new BufferingSplitSource((SplitSource)mockSource, 10);
        try {
            mockSource.increaseAvailableSplits(9);
            nextBatchFuture = TestBufferingSplitSource.getNextBatch((SplitSource)source, 10);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.increaseAvailableSplits(1);
            TestBufferingSplitSource.requireFutureValue(nextBatchFuture).assertSize(10).assertNoMoreSplits(false);
            nextBatchFuture = TestBufferingSplitSource.getNextBatch((SplitSource)source, 10);
            mockSource.increaseAvailableSplits(5);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.atSplitCompletion(MockSplitSource.Action.FAIL);
            TestBufferingSplitSource.assertFutureFailsWithMockFailure(nextBatchFuture);
            Assert.assertFalse((boolean)source.isFinished());
        }
        finally {
            source.close();
        }
        mockSource = new MockSplitSource().setBatchSize(8);
        source = new BufferingSplitSource((SplitSource)mockSource, 10);
        try {
            mockSource.increaseAvailableSplits(8);
            nextBatchFuture = TestBufferingSplitSource.getNextBatch((SplitSource)source, 20);
            Assert.assertFalse((boolean)nextBatchFuture.isDone());
            mockSource.increaseAvailableSplits(8);
            TestBufferingSplitSource.requireFutureValue(nextBatchFuture).assertSize(16).assertNoMoreSplits(false);
        }
        finally {
            source.close();
        }
    }

    @Test
    public void testFinishedSetWithoutIndicationFromSplitBatch() {
        MockSplitSource mockSource = new MockSplitSource().setBatchSize(1).increaseAvailableSplits(1);
        try (BufferingSplitSource source = new BufferingSplitSource((SplitSource)mockSource, 100);){
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 1)).assertSize(1).assertNoMoreSplits(false);
            Assert.assertFalse((boolean)source.isFinished());
            mockSource.atSplitCompletion(MockSplitSource.Action.FINISH);
            TestBufferingSplitSource.requireFutureValue(TestBufferingSplitSource.getNextBatch((SplitSource)source, 1)).assertSize(0).assertNoMoreSplits(true);
            Assert.assertTrue((boolean)source.isFinished());
            Assert.assertEquals((int)mockSource.getNextBatchInvocationCount(), (int)2);
        }
    }

    @Test
    public void testFailImmediate() {
        MockSplitSource mockSource = new MockSplitSource().setBatchSize(1).atSplitCompletion(MockSplitSource.Action.FAIL);
        try (BufferingSplitSource source = new BufferingSplitSource((SplitSource)mockSource, 100);){
            TestBufferingSplitSource.assertFutureFailsWithMockFailure(TestBufferingSplitSource.getNextBatch((SplitSource)source, 200));
            Assert.assertEquals((int)mockSource.getNextBatchInvocationCount(), (int)1);
        }
    }

    @Test
    public void testFail() {
        MockSplitSource mockSource = new MockSplitSource().setBatchSize(1).increaseAvailableSplits(1).atSplitCompletion(MockSplitSource.Action.FAIL);
        try (BufferingSplitSource source = new BufferingSplitSource((SplitSource)mockSource, 100);){
            TestBufferingSplitSource.assertFutureFailsWithMockFailure(TestBufferingSplitSource.getNextBatch((SplitSource)source, 2));
            Assert.assertEquals((int)mockSource.getNextBatchInvocationCount(), (int)2);
        }
    }

    private static void assertFutureFailsWithMockFailure(ListenableFuture<?> future) {
        Assert.assertTrue((boolean)future.isDone());
        Assertions.assertThatThrownBy(() -> future.get()).hasMessageContaining("Mock failure");
    }

    private static <T> T requireFutureValue(Future<T> future) {
        return MoreFutures.tryGetFutureValue(future).orElseThrow(AssertionError::new);
    }

    private static ListenableFuture<NextBatchResult> getNextBatch(SplitSource splitSource, int maxSize) {
        ListenableFuture future = splitSource.getNextBatch(maxSize);
        return Futures.transform((ListenableFuture)future, NextBatchResult::new, (Executor)MoreExecutors.directExecutor());
    }

    private static class NextBatchResult {
        private final SplitSource.SplitBatch splitBatch;

        public NextBatchResult(SplitSource.SplitBatch splitBatch) {
            this.splitBatch = Objects.requireNonNull(splitBatch, "splitBatch is null");
        }

        public NextBatchResult assertSize(int expectedSize) {
            Assert.assertEquals((int)this.splitBatch.getSplits().size(), (int)expectedSize);
            return this;
        }

        public NextBatchResult assertNoMoreSplits(boolean expectedNoMoreSplits) {
            Assert.assertEquals((boolean)this.splitBatch.isLastBatch(), (boolean)expectedNoMoreSplits);
            return this;
        }
    }
}

