/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.sql.SqlEnvironmentConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestSqlEnvironmentConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SqlEnvironmentConfig)ConfigAssertions.recordDefaults(SqlEnvironmentConfig.class)).setPath("").setDefaultCatalog(null).setDefaultSchema(null).setForcedSessionTimeZone(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"sql.path", (Object)"a.b, c.d").put((Object)"sql.default-catalog", (Object)"some-catalog").put((Object)"sql.default-schema", (Object)"some-schema").put((Object)"sql.forced-session-time-zone", (Object)"UTC").buildOrThrow();
        SqlEnvironmentConfig expected = new SqlEnvironmentConfig().setPath("a.b, c.d").setDefaultCatalog("some-catalog").setDefaultSchema("some-schema").setForcedSessionTimeZone("UTC");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

