/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.WindowFrame;
import java.util.Objects;
import java.util.Optional;

public class WindowFrameProvider
implements ExpectedValueProvider<WindowNode.Frame> {
    private final WindowFrame.Type type;
    private final FrameBound.Type startType;
    private final Optional<SymbolAlias> startValue;
    private final Optional<SymbolAlias> sortKeyForStartComparison;
    private final FrameBound.Type endType;
    private final Optional<SymbolAlias> endValue;
    private final Optional<SymbolAlias> sortKeyForEndComparison;

    WindowFrameProvider(WindowFrame.Type type, FrameBound.Type startType, Optional<SymbolAlias> startValue, Optional<SymbolAlias> sortKeyForStartComparison, FrameBound.Type endType, Optional<SymbolAlias> endValue, Optional<SymbolAlias> sortKeyForEndComparison) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startValue = Objects.requireNonNull(startValue, "startValue is null");
        this.sortKeyForStartComparison = Objects.requireNonNull(sortKeyForStartComparison, "sortKeyForStartComparison is null");
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endValue = Objects.requireNonNull(endValue, "endValue is null");
        this.sortKeyForEndComparison = Objects.requireNonNull(sortKeyForEndComparison, "sortKeyForEndComparison is null");
    }

    @Override
    public WindowNode.Frame getExpectedValue(SymbolAliases aliases) {
        Optional<Expression> originalStartValue = this.startValue.map(alias -> alias.toSymbol(aliases).toSymbolReference());
        Optional<Expression> originalEndValue = this.endValue.map(alias -> alias.toSymbol(aliases).toSymbolReference());
        return new WindowNode.Frame(this.type, this.startType, this.startValue.map(alias -> alias.toSymbol(aliases)), this.sortKeyForStartComparison.map(alias -> alias.toSymbol(aliases)), this.endType, this.endValue.map(alias -> alias.toSymbol(aliases)), this.sortKeyForEndComparison.map(alias -> alias.toSymbol(aliases)), originalStartValue, originalEndValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startValue", this.startValue).add("endType", (Object)this.endType).add("endValue", this.endValue).toString();
    }
}

