/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.eventlistener.QueryPlanOptimizerStatistics;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIterativeOptimizer {
    @Test
    @Timeout(value=10L)
    public void optimizerQueryRulesStatsCollect() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setSystemProperty("iterative_optimizer_timeout", "5s");
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());){
            PlanOptimizersStatsCollector planOptimizersStatsCollector = new PlanOptimizersStatsCollector(10);
            IterativeOptimizer optimizer = new IterativeOptimizer(queryRunner.getPlannerContext(), new RuleStatsRecorder(), queryRunner.getStatsCalculator(), queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new AddIdentityOverTableScan(), (Object)new RemoveRedundantIdentityProjections()));
            Session session = sessionBuilder.build();
            queryRunner.inTransaction(session, arg_0 -> TestIterativeOptimizer.lambda$optimizerQueryRulesStatsCollect$0(queryRunner, (PlanOptimizer)optimizer, planOptimizersStatsCollector, arg_0));
            Optional queryRuleStats = planOptimizersStatsCollector.getTopRuleStats().stream().findFirst();
            Assert.assertTrue((boolean)queryRuleStats.isPresent());
            QueryPlanOptimizerStatistics queryRuleStat = (QueryPlanOptimizerStatistics)queryRuleStats.get();
            Assert.assertEquals((String)queryRuleStat.rule(), (String)RemoveRedundantIdentityProjections.class.getCanonicalName());
            Assert.assertEquals((long)queryRuleStat.invocations(), (long)4L);
            Assert.assertEquals((long)queryRuleStat.applied(), (long)3L);
            Assert.assertEquals((long)queryRuleStat.failures(), (long)0L);
        }
    }

    @Test
    @Timeout(value=10L)
    public void optimizerTimeoutsOnNonConvergingPlan() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema("tiny").setSystemProperty("task_concurrency", "1").setSystemProperty("iterative_optimizer_timeout", "1ms");
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());){
            queryRunner.createCatalog((String)queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
            IterativeOptimizer optimizer = new IterativeOptimizer(queryRunner.getPlannerContext(), new RuleStatsRecorder(), queryRunner.getStatsCalculator(), queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new AddIdentityOverTableScan(), (Object)new RemoveRedundantIdentityProjections()));
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestIterativeOptimizer.lambda$optimizerTimeoutsOnNonConvergingPlan$2(queryRunner, (PlanOptimizer)optimizer)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.OPTIMIZER_TIMEOUT}).hasMessageMatching("The optimizer exhausted the time limit of 1 ms: (no rules invoked|(?s)Top rules:.*(RemoveRedundantIdentityProjections|AddIdentityOverTableScan).*)");
        }
    }

    private static /* synthetic */ void lambda$optimizerTimeoutsOnNonConvergingPlan$2(LocalQueryRunner queryRunner, PlanOptimizer optimizer) throws Throwable {
        queryRunner.inTransaction(queryRunner.getDefaultSession(), transactionSession -> queryRunner.createPlan(transactionSession, "SELECT nationkey FROM nation", (List)ImmutableList.of((Object)optimizer), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector()));
    }

    private static /* synthetic */ Plan lambda$optimizerQueryRulesStatsCollect$0(LocalQueryRunner queryRunner, PlanOptimizer optimizer, PlanOptimizersStatsCollector planOptimizersStatsCollector, Session transactionSession) {
        return queryRunner.createPlan(transactionSession, "SELECT 1", (List)ImmutableList.of((Object)optimizer), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, planOptimizersStatsCollector);
    }

    private static class AddIdentityOverTableScan
    implements Rule<TableScanNode> {
        private AddIdentityOverTableScan() {
        }

        public Pattern<TableScanNode> getPattern() {
            return Patterns.tableScan();
        }

        public Rule.Result apply(TableScanNode tableScan, Captures captures, Rule.Context context) {
            return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)tableScan, Assignments.identity((Iterable)tableScan.getOutputSymbols())));
        }
    }
}

