/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.Plugin;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.ArraySortAfterArrayDistinct;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestArraySortAfterArrayDistinct
extends BaseRuleTest {
    public TestArraySortAfterArrayDistinct() {
        super(new Plugin[0]);
    }

    @Test
    public void testArrayDistinctAfterArraySort() {
        this.test("ARRAY_DISTINCT(ARRAY_SORT(\"$array\"('a')))", "ARRAY_SORT(ARRAY_DISTINCT(\"$array\"('a')))");
    }

    @Test
    public void testArrayDistinctAfterArraySortWithLambda() {
        this.test("ARRAY_DISTINCT(ARRAY_SORT(\"$array\"('a'), (a, b) -> 1))", "ARRAY_SORT(ARRAY_DISTINCT(\"$array\"('a')), (a, b) -> 1)");
    }

    private void test(String original, String rewritten) {
        this.tester().assertThat(new ArraySortAfterArrayDistinct(this.tester().getPlannerContext()).projectExpressionRewrite()).on(p -> p.project(Assignments.builder().put(p.symbol("output"), this.expression(original)).build(), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.project(Map.of("output", PlanMatchPattern.expression(this.expression(rewritten))), PlanMatchPattern.values(new String[0])));
    }

    private Expression expression(String sql) {
        return ExpressionTestUtils.planExpression(this.tester().getQueryRunner().getTransactionManager(), this.tester().getPlannerContext(), this.tester().getSession(), TypeProvider.empty(), PlanBuilder.expression(sql));
    }
}

