/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsAndCosts;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.rule.ReorderJoins;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJoinNodeFlattener {
    private static final int DEFAULT_JOIN_LIMIT = 10;
    private LocalQueryRunner queryRunner;

    @BeforeAll
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().build());
    }

    @AfterAll
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    @Test
    public void testDoesNotAllowOuterJoin() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        JoinNode outerJoin = p.join(JoinNode.Type.FULL, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)outerJoin, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)10, (boolean)false, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes())).isInstanceOf(IllegalStateException.class)).hasMessageMatching("join type must be.*");
    }

    @Test
    public void testDoesNotConvertNestedOuterJoins() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol c1 = p.symbol("C1");
        JoinNode leftJoin = p.join(JoinNode.Type.LEFT, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        ValuesNode valuesC = p.values(c1);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)leftJoin, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), (List<Symbol>)ImmutableList.of((Object)c1), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{leftJoin, valuesC}).setFilter((Expression)this.createEqualsExpression(a1, c1)).setOutputSymbols(new Symbol[]{a1, b1, c1}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)joinNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)10, (boolean)false, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes()), (Object)expected);
    }

    @Test
    public void testPushesProjectionsThroughJoin() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a = p.symbol("A");
        Symbol b = p.symbol("B");
        Symbol c = p.symbol("C");
        Symbol d = p.symbol("D");
        ValuesNode valuesA = p.values(a);
        ValuesNode valuesB = p.values(b);
        ValuesNode valuesC = p.values(c);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)d, (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)a.toSymbolReference())), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, this.equiJoinClause(a, b))), (PlanNode)valuesC, this.equiJoinClause(d, c));
        ReorderJoins.MultiJoinNode actual = ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)joinNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)10, (boolean)true, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes());
        Assert.assertEquals((Collection)actual.getOutputSymbols(), (Collection)ImmutableList.of((Object)d, (Object)c));
        Assert.assertEquals((Object)actual.getFilter(), (Object)ExpressionUtils.and((Expression[])new Expression[]{this.createEqualsExpression(a, b), this.createEqualsExpression(d, c)}));
        Assert.assertTrue((boolean)actual.isPushedProjectionThroughJoin());
        ImmutableList actualSources = ImmutableList.copyOf((Collection)actual.getSources());
        this.assertPlan(p.getTypes(), (PlanNode)actualSources.get(0), PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.values("a")).withNumberOfOutputColumns(2));
        this.assertPlan(p.getTypes(), (PlanNode)actualSources.get(1), PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.values("b")).withNumberOfOutputColumns(1));
        this.assertPlan(p.getTypes(), (PlanNode)actualSources.get(2), PlanMatchPattern.values("c"));
    }

    @Test
    public void testDoesNotPushStraddlingProjection() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a = p.symbol("A");
        Symbol b = p.symbol("B");
        Symbol c = p.symbol("C");
        Symbol d = p.symbol("D");
        ValuesNode valuesA = p.values(a);
        ValuesNode valuesB = p.values(b);
        ValuesNode valuesC = p.values(c);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)d, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)a.toSymbolReference(), (Expression)b.toSymbolReference())), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, this.equiJoinClause(a, b))), (PlanNode)valuesC, this.equiJoinClause(d, c));
        ReorderJoins.MultiJoinNode actual = ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)joinNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)10, (boolean)true, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes());
        Assert.assertEquals((Collection)actual.getOutputSymbols(), (Collection)ImmutableList.of((Object)d, (Object)c));
        Assert.assertEquals((Object)actual.getFilter(), (Object)this.createEqualsExpression(d, c));
        Assert.assertFalse((boolean)actual.isPushedProjectionThroughJoin());
        ImmutableList actualSources = ImmutableList.copyOf((Collection)actual.getSources());
        this.assertPlan(p.getTypes(), (PlanNode)actualSources.get(0), PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.values("a"), PlanMatchPattern.values("b"))).withNumberOfOutputColumns(1));
        this.assertPlan(p.getTypes(), (PlanNode)actualSources.get(1), PlanMatchPattern.values("c"));
    }

    @Test
    public void testRetainsOutputSymbols() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol b2 = p.symbol("B2");
        Symbol c1 = p.symbol("C1");
        Symbol c2 = p.symbol("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<Symbol>)ImmutableList.of((Object)b1, (Object)b2), (List<Symbol>)ImmutableList.of((Object)c1, (Object)c2), Optional.empty()), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC}).setFilter(ExpressionUtils.and((Expression[])new Expression[]{this.createEqualsExpression(b1, c1), this.createEqualsExpression(a1, b1)})).setOutputSymbols(new Symbol[]{a1, b1}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)joinNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)10, (boolean)false, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes()), (Object)expected);
    }

    @Test
    public void testCombinesCriteriaAndFilters() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol b2 = p.symbol("B2");
        Symbol c1 = p.symbol("C1");
        Symbol c2 = p.symbol("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        Expression bcFilter = ExpressionUtils.and((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)c2.toSymbolReference(), (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)c2.toSymbolReference(), (Expression)new LongLiteral("7")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b2.toSymbolReference(), (Expression)c2.toSymbolReference())});
        ComparisonExpression abcFilter = new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)a1.toSymbolReference(), (Expression)c1.toSymbolReference()), (Expression)b1.toSymbolReference());
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<Symbol>)ImmutableList.of((Object)b1, (Object)b2), (List<Symbol>)ImmutableList.of((Object)c1, (Object)c2), Optional.of(bcFilter)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.of(abcFilter));
        ReorderJoins.MultiJoinNode expected = new ReorderJoins.MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)valuesA, (Object)valuesB, (Object)valuesC)), ExpressionUtils.and((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)b1.toSymbolReference(), (Expression)c1.toSymbolReference()), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)a1.toSymbolReference(), (Expression)b1.toSymbolReference()), bcFilter, abcFilter}), (List)ImmutableList.of((Object)a1, (Object)b1, (Object)b2, (Object)c1, (Object)c2), false);
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)joinNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)10, (boolean)false, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes()), (Object)expected);
    }

    @Test
    public void testConvertsBushyTrees() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol c1 = p.symbol("C1");
        Symbol d1 = p.symbol("D1");
        Symbol d2 = p.symbol("D2");
        Symbol e1 = p.symbol("E1");
        Symbol e2 = p.symbol("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty()), (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), (List<Symbol>)ImmutableList.of((Object)c1), Optional.empty()), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<Symbol>)ImmutableList.of((Object)d1, (Object)d2), (List<Symbol>)ImmutableList.of((Object)e1, (Object)e2), Optional.empty()), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), (List<Symbol>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC, valuesD, valuesE}).setFilter(ExpressionUtils.and((Expression[])new Expression[]{this.createEqualsExpression(a1, b1), this.createEqualsExpression(a1, c1), this.createEqualsExpression(d1, e1), this.createEqualsExpression(d2, e2), this.createEqualsExpression(b1, e1)})).setOutputSymbols(new Symbol[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)joinNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)5, (boolean)false, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes()), (Object)expected);
    }

    @Test
    public void testMoreThanJoinLimit() {
        PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = this.planBuilder(planNodeIdAllocator);
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol c1 = p.symbol("C1");
        Symbol d1 = p.symbol("D1");
        Symbol d2 = p.symbol("D2");
        Symbol e1 = p.symbol("E1");
        Symbol e2 = p.symbol("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode join1 = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        JoinNode join2 = p.join(JoinNode.Type.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<Symbol>)ImmutableList.of((Object)d1, (Object)d2), (List<Symbol>)ImmutableList.of((Object)e1, (Object)e2), Optional.empty());
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)join1, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), (List<Symbol>)ImmutableList.of((Object)c1), Optional.empty()), (PlanNode)join2, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), (List<Symbol>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{join1, join2, valuesC}).setFilter(ExpressionUtils.and((Expression[])new Expression[]{this.createEqualsExpression(a1, c1), this.createEqualsExpression(b1, e1)})).setOutputSymbols(new Symbol[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((PlannerContext)this.queryRunner.getPlannerContext(), (JoinNode)joinNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)planNodeIdAllocator, (int)2, (boolean)false, (Session)TestingSession.testSessionBuilder().build(), (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.queryRunner.getPlannerContext()), (TypeProvider)p.getTypes()), (Object)expected);
    }

    private ComparisonExpression createEqualsExpression(Symbol left, Symbol right) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)left.toSymbolReference(), (Expression)right.toSymbolReference());
    }

    private JoinNode.EquiJoinClause equiJoinClause(Symbol symbol1, Symbol symbol2) {
        return new JoinNode.EquiJoinClause(symbol1, symbol2);
    }

    private PlanBuilder planBuilder(PlanNodeIdAllocator planNodeIdAllocator) {
        return new PlanBuilder(planNodeIdAllocator, this.queryRunner.getPlannerContext(), this.queryRunner.getDefaultSession());
    }

    private void assertPlan(TypeProvider typeProvider, PlanNode actual, PlanMatchPattern pattern) {
        PlanAssert.assertPlan(TestingSession.testSessionBuilder().build(), AbstractMockMetadata.dummyMetadata(), this.queryRunner.getFunctionManager(), node -> PlanNodeStatsEstimate.unknown(), new Plan(actual, typeProvider, StatsAndCosts.empty()), Lookup.noLookup(), pattern);
    }
}

