/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.SessionTestUtils;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.DynamicFilters;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.RemoveUnsupportedDynamicFilters;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.sanity.DynamicFiltersChecker;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestRemoveUnsupportedDynamicFilters
extends BasePlanTest {
    private PlannerContext plannerContext;
    private Metadata metadata;
    private PlanBuilder builder;
    private Symbol lineitemOrderKeySymbol;
    private TableScanNode lineitemTableScanNode;
    private TableHandle lineitemTableHandle;
    private Symbol ordersOrderKeySymbol;
    private TableScanNode ordersTableScanNode;

    @BeforeAll
    public void setup() {
        this.plannerContext = this.getQueryRunner().getPlannerContext();
        this.metadata = this.plannerContext.getMetadata();
        this.builder = new PlanBuilder(new PlanNodeIdAllocator(), this.plannerContext, SessionTestUtils.TEST_SESSION);
        CatalogHandle catalogHandle = this.getCurrentCatalogHandle();
        this.lineitemTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "lineitem", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        this.lineitemOrderKeySymbol = this.builder.symbol("LINEITEM_OK", (Type)BigintType.BIGINT);
        this.lineitemTableScanNode = this.builder.tableScan(this.lineitemTableHandle, (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.lineitemOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
        TableHandle ordersTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        this.ordersOrderKeySymbol = this.builder.symbol("ORDERS_OK", (Type)BigintType.BIGINT);
        this.ordersTableScanNode = this.builder.tableScan(ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.ordersOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnconsumedDynamicFilterInJoin() {
        JoinNode root = this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(PlanBuilder.expression("ORDERS_OK > 0"), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.filter(PlanBuilder.expression("ORDERS_OK > 0"), (Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))));
    }

    @Test
    public void testDynamicFilterConsumedOnBuildSide() {
        Expression dynamicFilter = DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference());
        JoinNode root = this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(dynamicFilter, (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(dynamicFilter, (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").dynamicFilter("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)new SymbolReference("ORDERS_OK")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))));
    }

    @Test
    public void testUnmatchedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(TestRemoveUnsupportedDynamicFilters.filter(PlanBuilder.expression("LINEITEM_OK > 0"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRemoveDynamicFilterNotAboveTableScan() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.lineitemOrderKeySymbol)), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("LINEITEM_OK", "ORDERS_OK").left(TestRemoveUnsupportedDynamicFilters.filter(PlanBuilder.expression("LINEITEM_OK > 0"), PlanMatchPattern.values("LINEITEM_OK"))).right(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testNestedDynamicFilterDisjunctionRewrite() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{ExpressionUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK IS NULL"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), ExpressionUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK IS NOT NULL"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())})}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testNestedDynamicFilterConjunctionRewrite() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(ExpressionUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK IS NULL"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK IS NOT NULL"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())})}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(TestRemoveUnsupportedDynamicFilters.filter(ExpressionUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK IS NULL"), PlanBuilder.expression("LINEITEM_OK IS NOT NULL")}), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRemoveUnsupportedCast() {
        Symbol lineitemDoubleOrderKeySymbol = this.builder.symbol("LINEITEM_DOUBLE_OK", (Type)DoubleType.DOUBLE);
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)PlanBuilder.expression("CAST(LINEITEM_DOUBLE_OK AS BIGINT)")), (PlanNode)this.builder.tableScan(this.lineitemTableHandle, (List<Symbol>)ImmutableList.of((Object)lineitemDoubleOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)lineitemDoubleOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)DoubleType.DOUBLE)))), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(lineitemDoubleOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)lineitemDoubleOrderKeySymbol), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("LINEITEM_DOUBLE_OK", "ORDERS_OK").left(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_DOUBLE_OK", (Object)"orderkey"))).right(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testSpatialJoin() {
        Symbol leftSymbol = this.builder.symbol("LEFT_SYMBOL", (Type)BigintType.BIGINT);
        Symbol rightSymbol = this.builder.symbol("RIGHT_SYMBOL", (Type)BigintType.BIGINT);
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), this.builder.spatialJoin(SpatialJoinNode.Type.INNER, (PlanNode)this.builder.values(leftSymbol), (PlanNode)this.builder.values(rightSymbol), (List<Symbol>)ImmutableList.of((Object)leftSymbol, (Object)rightSymbol), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)PlanBuilder.expression("LEFT_SYMBOL + RIGHT_SYMBOL"))));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.spatialJoin("true", PlanMatchPattern.values("LEFT_SYMBOL"), PlanMatchPattern.values("RIGHT_SYMBOL"))));
    }

    @Test
    public void testUnconsumedDynamicFilterInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(PlanBuilder.expression("ORDERS_OK > 0"), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, TestRemoveUnsupportedDynamicFilters.filter(PlanBuilder.expression("ORDERS_OK > 0"), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))));
    }

    @Test
    public void testDynamicFilterConsumedOnFilteringSourceSideInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")), TestRemoveUnsupportedDynamicFilters.filter(PlanBuilder.expression("LINEITEM_OK > 0"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))));
    }

    @Test
    public void testUnmatchedDynamicFilterInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("ORDERS_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, TestRemoveUnsupportedDynamicFilters.filter(PlanBuilder.expression("ORDERS_OK > 0"), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))));
    }

    @Test
    public void testRemoveDynamicFilterNotAboveTableScanWithSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("ORDERS_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.ordersOrderKeySymbol)), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, TestRemoveUnsupportedDynamicFilters.filter(PlanBuilder.expression("ORDERS_OK > 0"), PlanMatchPattern.values("ORDERS_OK")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))));
    }

    private static PlanMatchPattern filter(Expression expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.filter(expectedPredicate, (Expression)BooleanLiteral.TRUE_LITERAL, source);
    }

    private PlanNode removeUnsupportedDynamicFilters(PlanNode root) {
        return (PlanNode)this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            PlanNode rewrittenPlan = new RemoveUnsupportedDynamicFilters(this.plannerContext).optimize(root, session, this.builder.getTypes(), new SymbolAllocator(), new PlanNodeIdAllocator(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), (TableStatsProvider)new CachingTableStatsProvider(this.metadata, session));
            new DynamicFiltersChecker().validate(rewrittenPlan, session, this.plannerContext, TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.plannerContext), this.builder.getTypes(), WarningCollector.NOOP);
            return rewrittenPlan;
        });
    }

    protected void assertPlan(PlanNode actual, PlanMatchPattern pattern) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            PlanAssert.assertPlan(session, this.metadata, this.getQueryRunner().getFunctionManager(), this.getQueryRunner().getStatsCalculator(), new Plan(actual, this.builder.getTypes(), StatsAndCosts.empty()), pattern);
            return null;
        });
    }
}

