/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestComplexTypesWithNull {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testRowTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT r.a, r.b, c\nFROM (VALUES ROW(CAST(ROW(1, NULL) AS ROW(a INTEGER, b INTEGER)))) t(r)\nJOIN (VALUES 1) u(c) ON c = r.a\n")))).matches("VALUES (1, CAST(NULL AS INTEGER), 1)");
    }

    @Test
    public void testArrayTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.a, t.b, c\nFROM UNNEST(ARRAY[CAST(ROW(1, NULL) as ROW(a INTEGER, b INTEGER)) ]) t\nJOIN (VALUES 1) u(c) ON c = t.a\n")))).matches("VALUES (1, CAST(NULL AS INTEGER), 1)");
    }

    @Test
    public void testNestedRowTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT r.a, r[2].b, r[2].c, c FROM\n(VALUES ROW(CAST(ROW(1, ROW(1, NULL)) AS ROW(a INTEGER, ROW(b INTEGER, c INTEGER))))) t(r)\nJOIN (VALUES 1) u(c) ON c = r.a\n")))).matches("VALUES (1, 1, CAST(NULL AS INTEGER), 1)");
    }

    @Test
    public void testNestedArrayTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT r.a, r.b, c FROM\n(VALUES CAST(ROW(ROW(1, ARRAY[NULL])) AS ROW(ROW(a INTEGER, b ARRAY(INTEGER))))) t(r)\nJOIN (VALUES 1) u(c) ON c = r.a\n")))).matches("VALUES (1, ARRAY[CAST(NULL AS INTEGER)], 1)");
    }
}

