/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableMap;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestFilterInaccessibleColumns {
    private static final String USER = "user";
    private static final String ADMIN = "admin";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema("tiny").setSystemProperty("hide_inaccessible_columns", "true").setIdentity(Identity.forUser((String)"user").build()).build();
    private QueryAssertions assertions;
    private TestingAccessControlManager accessControl;

    @BeforeAll
    public void init() {
        LocalQueryRunner runner = LocalQueryRunner.builder((Session)SESSION).withFeaturesConfig(new FeaturesConfig().setHideInaccessibleColumns(true)).build();
        runner.createCatalog("test-catalog", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSelectBaseline() {
        this.accessControl.reset();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3', CAST('refully final requests. regular, ironi' AS VARCHAR(152)))");
    }

    @Test
    public void testSimpleTableSchemaFilter() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3')");
    }

    @Test
    public void testDescribeBaseline() {
        this.accessControl.reset();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("DESCRIBE nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().anyMatch(materializedRow -> materializedRow.getField(0).equals("comment")));
    }

    @Test
    public void testDescribe() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("DESCRIBE nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().noneMatch(materializedRow -> materializedRow.getField(0).equals("comment")));
    }

    @Test
    public void testShowColumnsBaseline() {
        this.accessControl.reset();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().anyMatch(materializedRow -> materializedRow.getField(0).equals("comment")));
    }

    @Test
    public void testShowColumns() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().noneMatch(materializedRow -> materializedRow.getField(0).equals("comment")));
    }

    @Test
    public void testFilterExplicitSelect() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT nationkey, name, regionkey FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3')");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT nationkey, name, regionkey, comment FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view test-catalog.tiny.nation");
    }

    @Test
    public void testRowFilterWithAccessToInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName("test-catalog", "tiny", "nation"), USER, ViewExpression.builder().identity(ADMIN).catalog("test-catalog").schema("tiny").expression("comment IS NOT null").build());
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3')");
    }

    @Test
    public void testRowFilterWithoutAccessToInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName("test-catalog", "tiny", "nation"), USER, ViewExpression.builder().identity(USER).catalog("test-catalog").schema("tiny").expression("comment IS NOT null").build());
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view test-catalog.tiny.nation");
    }

    @Test
    public void testRowFilterAsSessionUserOnInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        QualifiedObjectName table = new QualifiedObjectName("test-catalog", "tiny", "nation");
        ViewExpression filter = ViewExpression.builder().catalog("test-catalog").schema("tiny").expression("comment IS NOT null").build();
        this.accessControl.rowFilter(table, ADMIN, filter);
        this.accessControl.rowFilter(table, USER, filter);
        Assertions.assertThatThrownBy(() -> this.assertions.query(this.user(USER), "SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view test-catalog.tiny.nation");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(this.user(ADMIN), "SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3', CAST('refully final requests. regular, ironi' AS VARCHAR(152)))");
    }

    @Test
    public void testMaskingOnAccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName("test-catalog", "tiny", "nation"), "nationkey", USER, ViewExpression.builder().identity(ADMIN).catalog("test-catalog").schema("tiny").expression("-nationkey").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '-6',CAST('FRANCE' AS VARCHAR(25)), BIGINT '3', CAST('refully final requests. regular, ironi' AS VARCHAR(152)))");
    }

    @Test
    public void testMaskingWithoutAccessToInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName("test-catalog", "tiny", "nation"), "comment", USER, ViewExpression.builder().identity(USER).catalog("test-catalog").schema("tiny").expression("CASE nationkey WHEN 6 THEN 'masked-comment' ELSE comment END").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view test-catalog.tiny.nation");
    }

    @Test
    public void testMaskingWithAccessToInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName("test-catalog", "tiny", "nation"), "comment", USER, ViewExpression.builder().identity(ADMIN).catalog("test-catalog").schema("tiny").expression("CASE nationkey WHEN 6 THEN 'masked-comment' ELSE comment END").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (CAST('FRANCE' AS VARCHAR(25)), BIGINT '3', CAST('masked-comment' AS VARCHAR(152)))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'CANADA'")))).matches("VALUES (CAST('CANADA' AS VARCHAR(25)), BIGINT '1', CAST('eas hang ironic, silent packages. slyly regular packages are furiously over the tithes. fluffily bold' AS VARCHAR(152)))");
    }

    @Test
    public void testMaskingAsSessionUserWithCaseOnInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        QualifiedObjectName table = new QualifiedObjectName("test-catalog", "tiny", "nation");
        ViewExpression mask = ViewExpression.builder().catalog("test-catalog").schema("tiny").expression("CASE nationkey WHEN 3 THEN 'masked-comment' ELSE comment END").build();
        this.accessControl.columnMask(table, "comment", ADMIN, mask);
        this.accessControl.columnMask(table, "comment", USER, mask);
        Assertions.assertThatThrownBy(() -> this.assertions.query(this.user(USER), "SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view test-catalog.tiny.nation");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(this.user(ADMIN), "SELECT * FROM nation WHERE name = 'CANADA'")))).matches("VALUES (BIGINT '3', CAST('CANADA' AS VARCHAR(25)), BIGINT '1', CAST('masked-comment' AS VARCHAR(152)))");
    }

    @Test
    public void testPredicateOnInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.name", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view test-catalog.tiny.nation");
    }

    @Test
    public void testJoinBaseline() {
        this.accessControl.reset();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation,customer WHERE customer.nationkey = nation.nationkey AND nation.name = 'FRANCE' AND customer.name='Customer#000001477'")))).matches(materializedRows -> ((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(11).equals("ites nag blithely alongside of the ironic accounts. accounts use. carefully silent deposits"));
    }

    @Test
    public void testJoin() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation,customer WHERE customer.nationkey = nation.nationkey AND nation.name = 'FRANCE' AND customer.name='Customer#000001477'")))).matches(materializedRows -> ((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getFields().size() == 11);
    }

    @Test
    public void testConstantFields() {
        this.accessControl.reset();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (SELECT 'test')")))).matches("VALUES ('test')");
    }

    @Test
    public void testFunctionFields() {
        this.accessControl.reset();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (SELECT concat(name,'-test') FROM nation WHERE name = 'FRANCE')")))).matches("VALUES (CAST('FRANCE-test' AS VARCHAR))");
    }

    @Test
    public void testFunctionOnInaccessibleColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.name", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (SELECT concat(name,'-test') FROM nation WHERE name = 'FRANCE')")).hasMessage("Access Denied: Cannot select from columns [name] in table or view test-catalog.tiny.nation");
    }

    private Session user(String user) {
        return Session.builder((Session)this.assertions.getDefaultSession()).setIdentity(Identity.ofUser((String)user)).build();
    }
}

