/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockSerdeUtil;
import io.trino.operator.OperatorAssertion;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.BlockTypeOperators;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public abstract class AbstractTestType {
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
    private final Class<?> objectValueType;
    private final Block testBlock;
    protected final Type type;
    private final TypeOperators typeOperators;
    private final MethodHandle readBlockMethod;
    private final MethodHandle writeBlockMethod;
    private final MethodHandle writeFlatToBlockMethod;
    private final MethodHandle readFlatMethod;
    private final MethodHandle writeFlatMethod;
    private final MethodHandle writeBlockToFlatMethod;
    private final MethodHandle flatFlatEqualOperator;
    private final MethodHandle flatBlockPositionEqualOperator;
    private final MethodHandle blockPositionFlatEqualOperator;
    private final MethodHandle flatHashCodeOperator;
    private final MethodHandle flatXxHash64Operator;
    private final MethodHandle flatFlatDistinctFromOperator;
    private final MethodHandle flatBlockPositionDistinctFromOperator;
    private final MethodHandle blockPositionFlatDistinctFromOperator;
    protected final BlockTypeOperators blockTypeOperators;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final BlockTypeOperators.BlockPositionHashCode hashCodeOperator;
    private final BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator;
    private final BlockTypeOperators.BlockPositionIsDistinctFrom distinctFromOperator;
    private final SortedMap<Integer, Object> expectedStackValues;
    private final SortedMap<Integer, Object> expectedObjectValues;
    private final Block testBlockWithNulls;

    protected AbstractTestType(Type type, Class<?> objectValueType, Block testBlock) {
        this(type, objectValueType, testBlock, testBlock);
    }

    protected AbstractTestType(Type type, Class<?> objectValueType, Block testBlock, Block expectedValues) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.typeOperators = new TypeOperators();
        this.readBlockMethod = this.typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        this.writeBlockMethod = this.typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        this.writeFlatToBlockMethod = this.typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
        this.readFlatMethod = this.typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
        this.writeFlatMethod = this.typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        this.writeBlockToFlatMethod = this.typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
        this.blockTypeOperators = new BlockTypeOperators(this.typeOperators);
        if (type.isComparable()) {
            this.flatFlatEqualOperator = this.typeOperators.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
            this.flatBlockPositionEqualOperator = this.typeOperators.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
            this.blockPositionFlatEqualOperator = this.typeOperators.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.FLAT}));
            this.flatHashCodeOperator = this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
            this.flatXxHash64Operator = this.typeOperators.getXxHash64Operator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
            this.flatFlatDistinctFromOperator = this.typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
            this.flatBlockPositionDistinctFromOperator = this.typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
            this.blockPositionFlatDistinctFromOperator = this.typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.FLAT}));
            this.equalOperator = this.blockTypeOperators.getEqualOperator(type);
            this.hashCodeOperator = this.blockTypeOperators.getHashCodeOperator(type);
            this.xxHash64Operator = this.blockTypeOperators.getXxHash64Operator(type);
            this.distinctFromOperator = this.blockTypeOperators.getDistinctFromOperator(type);
        } else {
            this.flatFlatEqualOperator = null;
            this.flatBlockPositionEqualOperator = null;
            this.blockPositionFlatEqualOperator = null;
            this.flatHashCodeOperator = null;
            this.flatXxHash64Operator = null;
            this.flatFlatDistinctFromOperator = null;
            this.flatBlockPositionDistinctFromOperator = null;
            this.blockPositionFlatDistinctFromOperator = null;
            this.equalOperator = null;
            this.hashCodeOperator = null;
            this.xxHash64Operator = null;
            this.distinctFromOperator = null;
        }
        this.objectValueType = Objects.requireNonNull(objectValueType, "objectValueType is null");
        this.testBlock = Objects.requireNonNull(testBlock, "testBlock is null");
        Objects.requireNonNull(expectedValues, "expectedValues is null");
        this.expectedStackValues = AbstractTestType.indexStackValues(type, expectedValues);
        this.expectedObjectValues = AbstractTestType.indexObjectValues(type, expectedValues);
        this.testBlockWithNulls = this.createAlternatingNullsBlock(testBlock);
    }

    private Block createAlternatingNullsBlock(Block testBlock) {
        BlockBuilder nullsBlockBuilder = this.type.createBlockBuilder(null, testBlock.getPositionCount());
        for (int position = 0; position < testBlock.getPositionCount(); ++position) {
            if (testBlock.isNull(position)) {
                Preconditions.checkState((boolean)(this.type instanceof UnknownType));
                nullsBlockBuilder.appendNull();
            } else if (this.type.getJavaType() == Boolean.TYPE) {
                this.type.writeBoolean(nullsBlockBuilder, this.type.getBoolean(testBlock, position));
            } else if (this.type.getJavaType() == Long.TYPE) {
                this.type.writeLong(nullsBlockBuilder, this.type.getLong(testBlock, position));
            } else if (this.type.getJavaType() == Double.TYPE) {
                this.type.writeDouble(nullsBlockBuilder, this.type.getDouble(testBlock, position));
            } else if (this.type.getJavaType() == Slice.class) {
                Slice slice = this.type.getSlice(testBlock, position);
                this.type.writeSlice(nullsBlockBuilder, slice, 0, slice.length());
            } else {
                this.type.writeObject(nullsBlockBuilder, this.type.getObject(testBlock, position));
            }
            nullsBlockBuilder.appendNull();
        }
        return nullsBlockBuilder.build();
    }

    @Test
    public void testLiteralFormRecognized() {
        PlannerContext plannerContext = this.createPlannerContext();
        LiteralEncoder literalEncoder = new LiteralEncoder(plannerContext);
        for (int position = 0; position < this.testBlock.getPositionCount(); ++position) {
            Object value = TypeUtils.readNativeValue((Type)this.type, (Block)this.testBlock, (int)position);
            Expression expression = literalEncoder.toExpression(value, this.type);
            if (ExpressionUtils.isEffectivelyLiteral((PlannerContext)plannerContext, (Session)SessionTestUtils.TEST_SESSION, (Expression)expression)) continue;
            Assert.fail((String)String.format("Expression not recognized literal for value %s at position %s (%s): %s", value, position, this.type.getObjectValue(TestingConnectorSession.SESSION, this.testBlock, position), expression));
        }
    }

    protected PlannerContext createPlannerContext() {
        return TestingPlannerContext.plannerContextBuilder().addType(this.type).build();
    }

    @Test
    public void testBlock() throws Throwable {
        for (Map.Entry<Integer, Object> entry : this.expectedStackValues.entrySet()) {
            this.assertPositionEquals(this.testBlock, entry.getKey(), entry.getValue(), this.expectedObjectValues.get(entry.getKey()));
        }
        for (Map.Entry<Integer, Object> entry : this.expectedStackValues.entrySet()) {
            this.assertPositionEquals(this.testBlockWithNulls, entry.getKey() * 2, entry.getValue(), this.expectedObjectValues.get(entry.getKey()));
            this.assertPositionEquals(this.testBlockWithNulls, entry.getKey() * 2 + 1, null, null);
        }
    }

    @Test
    public void testFlat() throws Throwable {
        int i;
        int flatFixedSize = this.type.getFlatFixedSize();
        int[] variableLengths = new int[this.expectedStackValues.size()];
        if (this.type.isFlatVariableWidth()) {
            for (int i2 = 0; i2 < variableLengths.length; ++i2) {
                variableLengths[i2] = this.type.getFlatVariableWidthSize(this.testBlock, i2);
            }
        }
        byte[] fixed = new byte[this.expectedStackValues.size() * flatFixedSize];
        byte[] variable = new byte[IntStream.of(variableLengths).sum()];
        int variableOffset = 0;
        for (i = 0; i < this.expectedStackValues.size(); ++i) {
            this.writeFlatMethod.invoke(this.expectedStackValues.get(i), fixed, i * flatFixedSize, variable, variableOffset);
            variableOffset += variableLengths[i];
        }
        this.assertFlat(fixed, 0, variable);
        Arrays.fill(fixed, (byte)0);
        Arrays.fill(variable, (byte)0);
        variableOffset = 0;
        for (i = 0; i < this.expectedStackValues.size(); ++i) {
            this.writeBlockToFlatMethod.invokeExact(this.testBlock, i, fixed, i * flatFixedSize, variable, variableOffset);
            variableOffset += variableLengths[i];
        }
        this.assertFlat(fixed, 0, variable);
        byte[] newFixed = new byte[fixed.length + 73];
        System.arraycopy(fixed, 0, newFixed, 73, fixed.length);
        byte[] newVariable = new byte[variable.length + 101];
        System.arraycopy(variable, 0, newVariable, 101, variable.length);
        Arrays.fill(fixed, (byte)0);
        Arrays.fill(variable, (byte)0);
        variableOffset = 101;
        for (int i3 = 0; i3 < this.expectedStackValues.size(); ++i3) {
            int variableSize = this.type.relocateFlatVariableWidthOffsets(newFixed, 73 + i3 * flatFixedSize, newVariable, variableOffset);
            variableOffset += variableSize;
            Assertions.assertThat((int)variableSize).isEqualTo(variableLengths[i3]);
        }
        this.assertFlat(newFixed, 73, newVariable);
    }

    private void assertFlat(byte[] fixed, int fixedOffset, byte[] variable) throws Throwable {
        int flatFixedSize = this.type.getFlatFixedSize();
        for (int i = 0; i < this.expectedStackValues.size(); ++i) {
            Object expectedStackValue = this.expectedStackValues.get(i);
            int elementFixedOffset = fixedOffset + i * flatFixedSize;
            if (this.type.getJavaType() == Boolean.TYPE) {
                Assert.assertEquals((Object)this.readFlatMethod.invokeExact(fixed, elementFixedOffset, variable), expectedStackValue);
            } else if (this.type.getJavaType() == Long.TYPE) {
                Assert.assertEquals((Object)this.readFlatMethod.invokeExact(fixed, elementFixedOffset, variable), expectedStackValue);
            } else if (this.type.getJavaType() == Double.TYPE) {
                Assert.assertEquals((Object)this.readFlatMethod.invokeExact(fixed, elementFixedOffset, variable), expectedStackValue);
            } else if (this.type.getJavaType() == Slice.class) {
                Assert.assertEquals((Object)this.readFlatMethod.invokeExact(fixed, elementFixedOffset, variable), expectedStackValue);
            } else if (this.type.getJavaType() == Block.class) {
                this.assertBlockEquals(this.readFlatMethod.invokeExact(fixed, elementFixedOffset, variable), (Block)expectedStackValue);
            } else {
                Assert.assertEquals((Object)this.readFlatMethod.invoke(fixed, elementFixedOffset, variable), expectedStackValue);
            }
            BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
            this.writeFlatToBlockMethod.invokeExact(fixed, elementFixedOffset, variable, blockBuilder);
            this.assertPositionEquals(this.testBlock, i, expectedStackValue, this.expectedObjectValues.get(i));
            if (!this.type.isComparable()) continue;
            Assert.assertTrue((boolean)this.flatFlatEqualOperator.invokeExact(fixed, elementFixedOffset, variable, fixed, elementFixedOffset, variable));
            Assert.assertTrue((boolean)this.flatBlockPositionEqualOperator.invokeExact(fixed, elementFixedOffset, variable, this.testBlock, i));
            Assert.assertTrue((boolean)this.blockPositionFlatEqualOperator.invokeExact(this.testBlock, i, fixed, elementFixedOffset, variable));
            Assert.assertEquals((long)this.flatHashCodeOperator.invokeExact(fixed, elementFixedOffset, variable), (long)this.hashCodeOperator.hashCodeNullSafe(this.testBlock, i));
            Assert.assertEquals((long)this.flatXxHash64Operator.invokeExact(fixed, elementFixedOffset, variable), (long)this.xxHash64Operator.xxHash64(this.testBlock, i));
            Assert.assertFalse((boolean)this.flatFlatDistinctFromOperator.invokeExact(fixed, elementFixedOffset, variable, fixed, elementFixedOffset, variable));
            Assert.assertFalse((boolean)this.flatBlockPositionDistinctFromOperator.invokeExact(fixed, elementFixedOffset, variable, this.testBlock, i));
            Assert.assertFalse((boolean)this.blockPositionFlatDistinctFromOperator.invokeExact(this.testBlock, i, fixed, elementFixedOffset, variable));
            Block nullValue = this.type.createBlockBuilder(null, 1).appendNull().build();
            Assert.assertTrue((boolean)this.flatBlockPositionDistinctFromOperator.invokeExact(fixed, elementFixedOffset, variable, nullValue, 0));
            Assert.assertTrue((boolean)this.blockPositionFlatDistinctFromOperator.invokeExact(nullValue, 0, fixed, elementFixedOffset, variable));
        }
    }

    protected Object getSampleValue() {
        return Objects.requireNonNull(Iterables.get(this.expectedStackValues.values(), (int)0), "sample value is null");
    }

    protected void assertPositionEquals(Block block, int position, Object expectedStackValue, Object expectedObjectValue) throws Throwable {
        long hash = 0L;
        if (this.type.isComparable()) {
            hash = this.hashCodeOperator.hashCodeNullSafe(block, position);
        }
        this.assertPositionValue(block, position, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getSingleValueBlock(position), 0, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(position, 1), 0, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(0, position + 1), position, expectedStackValue, hash, expectedObjectValue);
        this.assertPositionValue(block.getRegion(position, block.getPositionCount() - position), 0, expectedStackValue, hash, expectedObjectValue);
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        this.type.appendTo(block, position, blockBuilder);
        this.assertPositionValue(blockBuilder.build(), 0, expectedStackValue, hash, expectedObjectValue);
        if (expectedStackValue != null) {
            blockBuilder = this.type.createBlockBuilder(null, 1);
            this.writeBlockMethod.invoke(expectedStackValue, blockBuilder);
            this.assertPositionValue(blockBuilder.build(), 0, expectedStackValue, hash, expectedObjectValue);
        }
    }

    private void assertPositionValue(Block block, int position, Object expectedStackValue, long expectedHash, Object expectedObjectValue) throws Throwable {
        Assert.assertEquals((boolean)block.isNull(position), (expectedStackValue == null ? 1 : 0) != 0);
        Object objectValue = this.type.getObjectValue(TestingConnectorSession.SESSION, block, position);
        Assert.assertEquals((Object)objectValue, (Object)expectedObjectValue);
        if (objectValue != null) {
            io.airlift.testing.Assertions.assertInstanceOf((Object)objectValue, this.objectValueType);
        }
        Block expectedBlock = AbstractTestType.createBlock(this.type, expectedStackValue);
        if (this.type.isComparable()) {
            Assert.assertTrue((boolean)this.equalOperator.equalNullSafe(block, position, block, position));
            Assert.assertTrue((boolean)this.equalOperator.equalNullSafe(block, position, expectedBlock, 0));
            Assert.assertTrue((boolean)this.equalOperator.equalNullSafe(expectedBlock, 0, block, position));
            Assert.assertEquals((long)this.hashCodeOperator.hashCodeNullSafe(block, position), (long)expectedHash);
            Assert.assertFalse((boolean)this.distinctFromOperator.isDistinctFrom(block, position, block, position));
            Assert.assertFalse((boolean)this.distinctFromOperator.isDistinctFrom(block, position, expectedBlock, 0));
            Assert.assertFalse((boolean)this.distinctFromOperator.isDistinctFrom(expectedBlock, 0, block, position));
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.typeOperators.getHashCodeOperator(this.type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("is not comparable");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.typeOperators.getEqualOperator(this.type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("is not comparable");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.typeOperators.getEqualOperator(this.type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("is not comparable");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.typeOperators.getDistinctFromOperator(this.type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("is not comparable");
        }
        Assert.assertEquals((boolean)block.isNull(position), (expectedStackValue == null ? 1 : 0) != 0);
        if (this.type.isOrderable()) {
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_FIRST).order(block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_LAST).order(block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.DESC_NULLS_FIRST).order(block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.DESC_NULLS_LAST).order(block, position, expectedBlock, 0) == 0 ? 1 : 0) != 0);
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.typeOperators.getComparisonUnorderedLastOperator(this.type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("is not orderable");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.typeOperators.getComparisonUnorderedFirstOperator(this.type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("is not orderable");
        }
        this.verifyInvalidPositionHandling(block);
        if (block.isNull(position)) {
            if (this.type.isOrderable() && !(this.type instanceof UnknownType)) {
                Block nonNullValue = this.toBlock(this.getNonNullValue());
                Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_FIRST).order(block, position, nonNullValue, 0) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_LAST).order(block, position, nonNullValue, 0) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.DESC_NULLS_FIRST).order(block, position, nonNullValue, 0) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.DESC_NULLS_LAST).order(block, position, nonNullValue, 0) > 0 ? 1 : 0) != 0);
            }
            return;
        }
        if (this.type.isOrderable() && expectedStackValue != Boolean.TRUE) {
            Block greaterValue = this.toBlock(this.getGreaterValue(expectedStackValue));
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_FIRST).order(block, position, greaterValue, 0) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_LAST).order(block, position, greaterValue, 0) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.DESC_NULLS_FIRST).order(block, position, greaterValue, 0) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.DESC_NULLS_LAST).order(block, position, greaterValue, 0) > 0 ? 1 : 0) != 0);
        }
        if (this.type.getJavaType() == Boolean.TYPE) {
            Assert.assertEquals((Object)this.type.getBoolean(block, position), (Object)expectedStackValue);
            Assertions.assertThatThrownBy(() -> this.type.getLong(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getDouble(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getObject(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assert.assertEquals((Object)this.readBlockMethod.invokeExact(block, position), (Object)expectedStackValue);
        } else if (this.type.getJavaType() == Long.TYPE) {
            Assert.assertEquals((Object)this.type.getLong(block, position), (Object)expectedStackValue);
            Assertions.assertThatThrownBy(() -> this.type.getBoolean(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getDouble(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getObject(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assert.assertEquals((Object)this.readBlockMethod.invokeExact(block, position), (Object)expectedStackValue);
        } else if (this.type.getJavaType() == Double.TYPE) {
            Assert.assertEquals((Object)this.type.getDouble(block, position), (Object)expectedStackValue);
            Assertions.assertThatThrownBy(() -> this.type.getBoolean(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getLong(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getObject(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assert.assertEquals((Object)this.readBlockMethod.invokeExact(block, position), (Object)expectedStackValue);
        } else if (this.type.getJavaType() == Slice.class) {
            Assert.assertEquals((Object)this.type.getSlice(block, position), (Object)expectedStackValue);
            Assert.assertEquals((Object)this.type.getObject(block, position), (Object)expectedStackValue);
            Assertions.assertThatThrownBy(() -> this.type.getBoolean(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getLong(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getDouble(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assert.assertEquals((Object)this.readBlockMethod.invokeExact(block, position), (Object)expectedStackValue);
        } else if (this.type.getJavaType() == Block.class) {
            this.assertBlockEquals((Block)this.type.getObject(block, position), (Block)expectedStackValue);
            Assertions.assertThatThrownBy(() -> this.type.getBoolean(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getLong(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getDouble(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getSlice(block, position)).isInstanceOf(UnsupportedOperationException.class);
            this.assertBlockEquals(this.readBlockMethod.invokeExact(block, position), (Block)expectedStackValue);
        } else {
            Assert.assertEquals((Object)this.type.getObject(block, position), (Object)expectedStackValue);
            Assertions.assertThatThrownBy(() -> this.type.getBoolean(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getLong(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assertions.assertThatThrownBy(() -> this.type.getDouble(block, position)).isInstanceOf(UnsupportedOperationException.class);
            Assert.assertEquals((Object)this.readBlockMethod.invoke(block, position), (Object)expectedStackValue);
        }
    }

    private void assertBlockEquals(Block actualValue, Block expectedValue) {
        DynamicSliceOutput actualSliceOutput = new DynamicSliceOutput(100);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.blockEncodingSerde, (SliceOutput)actualSliceOutput, (Block)actualValue);
        DynamicSliceOutput expectedSliceOutput = new DynamicSliceOutput(actualSliceOutput.size());
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.blockEncodingSerde, (SliceOutput)expectedSliceOutput, (Block)expectedValue);
        Assert.assertEquals((Object)actualSliceOutput.slice(), (Object)expectedSliceOutput.slice());
    }

    private void verifyInvalidPositionHandling(Block block) {
        Block other;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getObjectValue(TestingConnectorSession.SESSION, block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getObjectValue(TestingConnectorSession.SESSION, block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        if (this.type.isComparable()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.hashCodeOperator.hashCode(block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.hashCodeOperator.hashCode(block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.xxHash64Operator.xxHash64(block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.xxHash64Operator.xxHash64(block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        }
        if (this.type.isComparable() && !(this.type instanceof UnknownType)) {
            other = this.toBlock(this.getNonNullValue());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.equalOperator.equal(block, -1, other, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.equalOperator.equal(block, block.getPositionCount(), other, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.distinctFromOperator.isDistinctFrom(block, -1, other, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.distinctFromOperator.isDistinctFrom(block, block.getPositionCount(), other, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        }
        if (this.type.isOrderable() && !(this.type instanceof UnknownType)) {
            other = this.toBlock(this.getNonNullValue());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_FIRST).order(block, -1, other, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.blockTypeOperators.generateBlockPositionOrdering(this.type, SortOrder.ASC_NULLS_FIRST).order(block, block.getPositionCount(), other, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.readBlockMethod.invoke(block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.readBlockMethod.invoke(block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        if (this.type.getJavaType() == Boolean.TYPE) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getBoolean(block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getBoolean(block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        } else if (this.type.getJavaType() == Long.TYPE) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getLong(block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getLong(block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        } else if (this.type.getJavaType() == Double.TYPE) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getDouble(block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getDouble(block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        } else if (this.type.getJavaType() == Slice.class) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getSlice(block, -1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getSlice(block, block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        }
    }

    private static Block createBlock(Type type, Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        Class javaType = type.getJavaType();
        if (value == null) {
            blockBuilder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            type.writeLong(blockBuilder, ((Long)value).longValue());
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = (Slice)value;
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
        return blockBuilder.build();
    }

    protected abstract Object getGreaterValue(Object var1);

    protected Object getNonNullValue() {
        return AbstractTestType.getNonNullValueForType(this.type);
    }

    private static Object getNonNullValueForType(Type type) {
        if (type.getJavaType() == Boolean.TYPE) {
            return true;
        }
        if (type.getJavaType() == Long.TYPE) {
            return 1L;
        }
        if (type.getJavaType() == Double.TYPE) {
            return 1.0;
        }
        if (type.getJavaType() == Slice.class) {
            return Slices.utf8Slice((String)"_");
        }
        if (type.getJavaType() == LongTimestamp.class) {
            return new LongTimestamp(1L, 0);
        }
        if (type.getJavaType() == LongTimestampWithTimeZone.class) {
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)1L, (long)0L, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            Object elementNonNullValue = AbstractTestType.getNonNullValueForType(elementType);
            return StructuralTestUtil.arrayBlockOf(elementType, elementNonNullValue);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            Object keyNonNullValue = AbstractTestType.getNonNullValueForType(keyType);
            Object valueNonNullValue = AbstractTestType.getNonNullValueForType(valueType);
            ImmutableMap map = ImmutableMap.of((Object)keyNonNullValue, (Object)valueNonNullValue);
            return StructuralTestUtil.mapBlockOf(keyType, valueType, map);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List elementTypes = rowType.getTypeParameters();
            Object[] elementNonNullValues = elementTypes.stream().map(AbstractTestType::getNonNullValueForType).toArray(Object[]::new);
            return OperatorAssertion.toRow(elementTypes, elementNonNullValues);
        }
        throw new IllegalStateException("Unsupported Java type " + type.getJavaType() + " (for type " + type + ")");
    }

    private Block toBlock(Object value) {
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        Class javaType = this.type.getJavaType();
        if (value == null) {
            blockBuilder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            this.type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            this.type.writeLong(blockBuilder, ((Long)value).longValue());
        } else if (javaType == Double.TYPE) {
            this.type.writeDouble(blockBuilder, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = (Slice)value;
            this.type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            this.type.writeObject(blockBuilder, value);
        }
        return blockBuilder.build();
    }

    private static SortedMap<Integer, Object> indexStackValues(Type type, Block block) {
        TreeMap<Integer, Object> values = new TreeMap<Integer, Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                values.put(position, null);
                continue;
            }
            if (type.getJavaType() == Boolean.TYPE) {
                values.put(position, type.getBoolean(block, position));
                continue;
            }
            if (type.getJavaType() == Long.TYPE) {
                values.put(position, type.getLong(block, position));
                continue;
            }
            if (type.getJavaType() == Double.TYPE) {
                values.put(position, type.getDouble(block, position));
                continue;
            }
            if (type.getJavaType() == Slice.class) {
                values.put(position, type.getSlice(block, position));
                continue;
            }
            values.put(position, type.getObject(block, position));
        }
        return Collections.unmodifiableSortedMap(values);
    }

    private static SortedMap<Integer, Object> indexObjectValues(Type type, Block block) {
        TreeMap<Integer, Object> values = new TreeMap<Integer, Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.put(position, type.getObjectValue(TestingConnectorSession.SESSION, block, position));
        }
        return Collections.unmodifiableSortedMap(values);
    }
}

