/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import io.trino.type.BlockTypeOperators;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestDoubleType
extends AbstractTestType {
    public TestDoubleType() {
        super((Type)DoubleType.DOUBLE, Double.class, TestDoubleType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 15);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 11.11);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 11.11);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 11.11);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 33.33);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 33.33);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 44.44);
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Double)value + 0.1;
    }

    @Test
    public void testNaNHash() {
        LongArrayBlockBuilder blockBuilder = (LongArrayBlockBuilder)DoubleType.DOUBLE.createBlockBuilder(null, 5);
        DoubleType.DOUBLE.writeDouble((BlockBuilder)blockBuilder, Double.NaN);
        blockBuilder.writeLong(Double.doubleToLongBits(Double.NaN));
        blockBuilder.writeLong(Double.doubleToRawLongBits(Double.NaN));
        blockBuilder.writeLong(-4503599627370495L);
        blockBuilder.writeLong(9221120237041090560L);
        Block block = blockBuilder.build();
        BlockTypeOperators.BlockPositionHashCode hashCodeOperator = this.blockTypeOperators.getHashCodeOperator((Type)DoubleType.DOUBLE);
        Assert.assertEquals((long)hashCodeOperator.hashCode(block, 0), (long)hashCodeOperator.hashCode(block, 1));
        Assert.assertEquals((long)hashCodeOperator.hashCode(block, 0), (long)hashCodeOperator.hashCode(block, 2));
        Assert.assertEquals((long)hashCodeOperator.hashCode(block, 0), (long)hashCodeOperator.hashCode(block, 3));
        Assert.assertEquals((long)hashCodeOperator.hashCode(block, 0), (long)hashCodeOperator.hashCode(block, 4));
        BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator = this.blockTypeOperators.getXxHash64Operator((Type)DoubleType.DOUBLE);
        Assert.assertEquals((long)xxHash64Operator.xxHash64(block, 0), (long)xxHash64Operator.xxHash64(block, 1));
        Assert.assertEquals((long)xxHash64Operator.xxHash64(block, 0), (long)xxHash64Operator.xxHash64(block, 2));
        Assert.assertEquals((long)xxHash64Operator.xxHash64(block, 0), (long)xxHash64Operator.xxHash64(block, 3));
        Assert.assertEquals((long)xxHash64Operator.xxHash64(block, 0), (long)xxHash64Operator.xxHash64(block, 4));
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

