/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestLongTimestampWithTimeZoneType
extends AbstractTestType {
    public TestLongTimestampWithTimeZoneType() {
        super((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, SqlTimestampWithTimeZone.class, TestLongTimestampWithTimeZoneType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.createBlockBuilder(null, 15);
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1111L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)0L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1111L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)1L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1111L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)2L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)2222L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)3L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)2222L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)4L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)2222L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)5L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)2222L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)6L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)2222L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)7L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)3333L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)8L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)3333L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)9L)));
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)4444L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)10L)));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(((LongTimestampWithTimeZone)value).getEpochMillis() + 1L), (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)33L));
    }

    @Test
    public void testPreviousValue() {
        LongTimestampWithTimeZone minValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MIN_VALUE, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone nextToMinValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MIN_VALUE, (int)1000000, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone previousToMaxValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MAX_VALUE, (int)998000000, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone maxValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MAX_VALUE, (int)999000000, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)nextToMinValue)).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1110L, (int)999000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)0L))));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1483228800000L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)0L)))).isEqualTo(Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1483228799999L, (int)999000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)0L))));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)previousToMaxValue)).isEqualTo(Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MAX_VALUE, (int)997000000, (TimeZoneKey)TimeZoneKey.UTC_KEY)));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(previousToMaxValue));
    }

    @Test
    public void testNextValue() {
        LongTimestampWithTimeZone minValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MIN_VALUE, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone nextToMinValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MIN_VALUE, (int)1000000, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone previousToMaxValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MAX_VALUE, (int)998000000, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone maxValue = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MAX_VALUE, (int)999000000, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(nextToMinValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)nextToMinValue)).isEqualTo(Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Long.MIN_VALUE, (int)2000000, (TimeZoneKey)TimeZoneKey.UTC_KEY)));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1111L, (int)1000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)0L))));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1483228799999L, (int)999000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)0L)))).isEqualTo(Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1483228800000L, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)0L))));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)previousToMaxValue)).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }

    @ParameterizedTest
    @MethodSource(value={"testPreviousNextValueEveryPrecisionDataProvider"})
    public void testPreviousValueEveryPrecision(int precision, long minValue, long maxValue, long step) {
        TimestampType type = TimestampType.createTimestampType((int)precision);
        Assertions.assertThat((Optional)type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)type.getPreviousValue((Object)(minValue + step))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)0L)).isEqualTo(Optional.of(-step));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)123456789000000L)).isEqualTo(Optional.of(123456789000000L - step));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)(maxValue - step))).isEqualTo(Optional.of(maxValue - 2L * step));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - step));
    }

    @ParameterizedTest
    @MethodSource(value={"testPreviousNextValueEveryPrecisionDataProvider"})
    public void testNextValueEveryPrecision(int precision, long minValue, long maxValue, long step) {
        TimestampType type = TimestampType.createTimestampType((int)precision);
        Assertions.assertThat((Optional)type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + step));
        Assertions.assertThat((Optional)type.getNextValue((Object)(minValue + step))).isEqualTo(Optional.of(minValue + 2L * step));
        Assertions.assertThat((Optional)type.getNextValue((Object)0L)).isEqualTo(Optional.of(step));
        Assertions.assertThat((Optional)type.getNextValue((Object)123456789000000L)).isEqualTo(Optional.of(123456789000000L + step));
        Assertions.assertThat((Optional)type.getNextValue((Object)(maxValue - step))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }

    public static Stream<Arguments> testPreviousNextValueEveryPrecisionDataProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{0, -9223372036854000000L, 9223372036854000000L, 1000000L}), Arguments.of((Object[])new Object[]{1, -9223372036854700000L, 9223372036854700000L, 100000L}), Arguments.of((Object[])new Object[]{2, -9223372036854770000L, 9223372036854770000L, 10000L}), Arguments.of((Object[])new Object[]{3, -9223372036854775000L, 9223372036854775000L, 1000L}), Arguments.of((Object[])new Object[]{4, -9223372036854775800L, 0x7FFFFFFFFFFFFFF8L, 100L}), Arguments.of((Object[])new Object[]{5, -9223372036854775800L, 0x7FFFFFFFFFFFFFF8L, 10L}), Arguments.of((Object[])new Object[]{6, Long.MIN_VALUE, Long.MAX_VALUE, 1L}));
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }
}

