/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.util.Long2LongOpenBigHashMap;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestLong2LongOpenBigHashMap {
    @Test
    public void testBasicOps() {
        int expected = 100000;
        Long2LongOpenBigHashMap map = new Long2LongOpenBigHashMap((long)expected);
        map.defaultReturnValue(-1L);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((int)map.size(), (int)0);
        Assert.assertEquals((long)map.get(0L), (long)-1L);
        Assert.assertEquals((long)map.get(1L), (long)-1L);
        List<Long> values = Arrays.asList(Long.MIN_VALUE, -10L, 0L, 10L, Long.MAX_VALUE);
        int count = 0;
        for (long key : values) {
            Assert.assertEquals((long)map.put(key, (long)(++count - 1)), (long)-1L);
            Assert.assertFalse((boolean)map.isEmpty());
            Assert.assertEquals((int)map.size(), (int)count);
        }
        count = 0;
        for (long key : values) {
            Assert.assertTrue((boolean)map.replace(key, (long)(++count - 1), (long)count));
            Assert.assertFalse((boolean)map.isEmpty());
            Assert.assertEquals((int)map.size(), (int)values.size());
        }
        count = 0;
        for (long key : values) {
            Assert.assertTrue((boolean)map.containsKey(key));
            Assert.assertTrue((boolean)map.containsValue((long)(++count)));
            Assert.assertEquals((long)map.get(key), (long)count);
        }
        count = 0;
        for (long key : values) {
            Assert.assertEquals((long)map.remove(key), (long)(++count));
        }
    }

    @Test
    public void testRehash() {
        long key;
        int initialCapacity = 1;
        Long2LongOpenBigHashMap map = new Long2LongOpenBigHashMap((long)initialCapacity);
        map.defaultReturnValue(-1L);
        for (key = 0L; key < 1000000L; ++key) {
            Assert.assertEquals((long)map.put(key, key + 1L), (long)-1L);
        }
        for (key = 0L; key < 1000000L; ++key) {
            Assert.assertEquals((long)map.get(key), (long)(key + 1L));
        }
        for (key = 1L; key < 1000000L; ++key) {
            map.remove(key);
        }
        map.trim();
        Assert.assertEquals((long)map.get(0L), (long)1L);
    }
}

