/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.type.InternalTypeManager;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;

public final class ColumnarTestUtils {
    private static final BlockEncodingSerde BLOCK_ENCODING_SERDE = new TestingBlockEncodingSerde(arg_0 -> ((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER).getType(arg_0));

    private ColumnarTestUtils() {
    }

    public static <T> void assertBlock(Type type, Block block, T[] expectedValues) {
        ColumnarTestUtils.assertBlockPositions(type, block, expectedValues);
        ColumnarTestUtils.assertBlockPositions(type, ColumnarTestUtils.copyBlock(block), expectedValues);
    }

    private static <T> void assertBlockPositions(Type type, Block block, T[] expectedValues) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            ColumnarTestUtils.assertBlockPosition(type, block, position, expectedValues[position]);
        }
    }

    public static <T> void assertBlockPosition(Type type, Block block, int position, T expectedValue) {
        ColumnarTestUtils.assertPositionValue(type, block, position, expectedValue);
        ColumnarTestUtils.assertPositionValue(type, block.getSingleValueBlock(position), 0, expectedValue);
    }

    private static <T> void assertPositionValue(Type type, Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assert.assertTrue((boolean)block.isNull(position));
            return;
        }
        Assert.assertFalse((boolean)block.isNull(position));
        if (expectedValue instanceof Slice) {
            Slice expected = (Slice)expectedValue;
            int length = block.getSliceLength(position);
            Assert.assertEquals((int)length, (int)expected.length());
            Slice actual = block.getSlice(position, 0, length);
            Assert.assertEquals((Object)actual, (Object)expected);
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Block actual = arrayType.getObject(block, position);
            ColumnarTestUtils.assertBlock(type, actual, (Slice[])expectedValue);
        } else if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            SqlRow actual = rowType.getObject(block, position);
            int rawIndex = actual.getRawIndex();
            List fieldBlocks = actual.getRawFieldBlocks();
            Slice[] expectedValues = (Slice[])expectedValue;
            for (int fieldIndex = 0; fieldIndex < fieldBlocks.size(); ++fieldIndex) {
                Block fieldBlock = (Block)fieldBlocks.get(fieldIndex);
                Type fieldType = (Type)rowType.getTypeParameters().get(fieldIndex);
                ColumnarTestUtils.assertBlockPosition(fieldType, fieldBlock, rawIndex, expectedValues[fieldIndex]);
            }
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Slice[][] expected = (Slice[][])expectedValue;
            SqlMap actual = mapType.getObject(block, position);
            Block actualKeys = actual.getRawKeyBlock().getRegion(actual.getRawOffset(), actual.getSize());
            Slice[] expectedKeys = (Slice[])Arrays.stream(expected).map(pair -> pair[0]).toArray(Slice[]::new);
            ColumnarTestUtils.assertBlock(type, actualKeys, expectedKeys);
            Block actualValues = actual.getRawValueBlock().getRegion(actual.getRawOffset(), actual.getSize());
            Slice[] expectedValues = (Slice[])Arrays.stream(expected).map(pair -> pair[1]).toArray(Slice[]::new);
            ColumnarTestUtils.assertBlock(type, actualValues, expectedValues);
        } else {
            throw new IllegalArgumentException(expectedValue.getClass().getName());
        }
    }

    public static <T> T[] alternatingNullValues(T[] objects) {
        Object[] objectsWithNulls = (Object[])Array.newInstance(objects.getClass().getComponentType(), objects.length * 2 + 1);
        for (int i = 0; i < objects.length; ++i) {
            objectsWithNulls[i * 2] = null;
            objectsWithNulls[i * 2 + 1] = objects[i];
        }
        objectsWithNulls[objectsWithNulls.length - 1] = null;
        return objectsWithNulls;
    }

    private static Block copyBlock(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        BLOCK_ENCODING_SERDE.writeBlock((SliceOutput)sliceOutput, block);
        return BLOCK_ENCODING_SERDE.readBlock((SliceInput)sliceOutput.slice().getInput());
    }

    public static Block createTestDictionaryBlock(Block block) {
        int[] dictionaryIndexes = ColumnarTestUtils.createTestDictionaryIndexes(block.getPositionCount());
        return DictionaryBlock.create((int)dictionaryIndexes.length, (Block)block, (int[])dictionaryIndexes);
    }

    public static <T> T[] createTestDictionaryExpectedValues(T[] expectedValues) {
        int[] dictionaryIndexes = ColumnarTestUtils.createTestDictionaryIndexes(expectedValues.length);
        T[] expectedDictionaryValues = Arrays.copyOf(expectedValues, dictionaryIndexes.length);
        for (int i = 0; i < dictionaryIndexes.length; ++i) {
            T expectedValue;
            int dictionaryIndex = dictionaryIndexes[i];
            expectedDictionaryValues[i] = expectedValue = expectedValues[dictionaryIndex];
        }
        return expectedDictionaryValues;
    }

    private static int[] createTestDictionaryIndexes(int valueCount) {
        int[] dictionaryIndexes = new int[valueCount * 2];
        for (int i = 0; i < valueCount; ++i) {
            dictionaryIndexes[i] = valueCount - i - 1;
            dictionaryIndexes[i + valueCount] = i;
        }
        return dictionaryIndexes;
    }

    public static <T> T[] createTestRleExpectedValues(T[] expectedValues, int position) {
        T[] expectedDictionaryValues = Arrays.copyOf(expectedValues, 10);
        for (int i = 0; i < 10; ++i) {
            expectedDictionaryValues[i] = expectedValues[position];
        }
        return expectedDictionaryValues;
    }

    public static RunLengthEncodedBlock createTestRleBlock(Block block, int position) {
        return (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)block.getRegion(position, 1), (int)10);
    }
}

