/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.ColumnarTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestColumnarMap {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private static final MapType MAP_TYPE = new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, TYPE_OPERATORS);
    private static final int[] MAP_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void test() {
        Slice[][][] expectedValues = new Slice[MAP_SIZES.length][][];
        for (int mapIndex = 0; mapIndex < MAP_SIZES.length; ++mapIndex) {
            expectedValues[mapIndex] = new Slice[MAP_SIZES[mapIndex]][];
            for (int entryIndex = 0; entryIndex < MAP_SIZES[mapIndex]; ++entryIndex) {
                Slice[] entry = new Slice[2];
                entry[0] = Slices.utf8Slice((String)String.format("key.%d.%d", mapIndex, entryIndex));
                if (entryIndex % 3 != 1) {
                    entry[1] = Slices.utf8Slice((String)String.format("value.%d.%d", mapIndex, entryIndex));
                }
                expectedValues[mapIndex][entryIndex] = entry;
            }
        }
        Block block = TestColumnarMap.createBlockBuilderWithValues(expectedValues).build();
        TestColumnarMap.verifyBlock(block, expectedValues);
        Slice[][][] expectedValuesWithNull = (Slice[][][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        Block blockWithNull = TestColumnarMap.createBlockBuilderWithValues(expectedValuesWithNull).build();
        TestColumnarMap.verifyBlock(blockWithNull, expectedValuesWithNull);
    }

    private static void verifyBlock(Block block, Slice[][][] expectedValues) {
        ColumnarTestUtils.assertBlock((Type)MAP_TYPE, block, expectedValues);
        TestColumnarMap.assertColumnarMap(block, expectedValues);
        TestColumnarMap.assertDictionaryBlock(block, expectedValues);
        TestColumnarMap.assertRunLengthEncodedBlock(block, expectedValues);
        int offset = 1;
        int length = expectedValues.length - 2;
        Block blockRegion = block.getRegion(offset, length);
        Slice[][][] expectedValuesRegion = (Slice[][][])Arrays.copyOfRange(expectedValues, offset, offset + length);
        ColumnarTestUtils.assertBlock((Type)MAP_TYPE, blockRegion, expectedValuesRegion);
        TestColumnarMap.assertColumnarMap(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertDictionaryBlock(blockRegion, expectedValuesRegion);
        TestColumnarMap.assertRunLengthEncodedBlock(blockRegion, expectedValuesRegion);
    }

    private static void assertDictionaryBlock(Block block, Slice[][][] expectedValues) {
        Block dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock((Type)MAP_TYPE, dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertColumnarMap(dictionaryBlock, expectedDictionaryValues);
        TestColumnarMap.assertRunLengthEncodedBlock(dictionaryBlock, expectedDictionaryValues);
    }

    private static void assertRunLengthEncodedBlock(Block block, Slice[][][] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            Slice[][][] expectedDictionaryValues = (Slice[][][])ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Type)MAP_TYPE, (Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestColumnarMap.assertColumnarMap((Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static void assertColumnarMap(Block block, Slice[][][] expectedValues) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Assert.assertEquals((int)columnarMap.getPositionCount(), (int)expectedValues.length);
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        int elementsPosition = 0;
        for (int position = 0; position < expectedValues.length; ++position) {
            Slice[][] expectedMap = expectedValues[position];
            Assert.assertEquals((boolean)columnarMap.isNull(position), (expectedMap == null ? 1 : 0) != 0);
            if (expectedMap == null) {
                Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)0);
                continue;
            }
            Assert.assertEquals((int)columnarMap.getEntryCount(position), (int)expectedMap.length);
            Assert.assertEquals((int)columnarMap.getOffset(position), (int)elementsPosition);
            for (int i = 0; i < columnarMap.getEntryCount(position); ++i) {
                Slice[] expectedEntry = expectedMap[i];
                Slice expectedKey = expectedEntry[0];
                ColumnarTestUtils.assertBlockPosition((Type)MAP_TYPE, keysBlock, elementsPosition, expectedKey);
                Slice expectedValue = expectedEntry[1];
                ColumnarTestUtils.assertBlockPosition((Type)MAP_TYPE, valuesBlock, elementsPosition, expectedValue);
                ++elementsPosition;
            }
        }
    }

    public static BlockBuilder createBlockBuilderWithValues(Slice[][][] expectedValues) {
        MapBlockBuilder blockBuilder = MAP_TYPE.createBlockBuilder(null, 100);
        for (Slice[][] expectedMap : expectedValues) {
            if (expectedMap == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
                for (Slice[] entry : expectedMap) {
                    Slice key = entry[0];
                    Assert.assertNotNull((Object)key);
                    VarcharType.VARCHAR.writeSlice(keyBuilder, key);
                    Slice value = entry[1];
                    if (value == null) {
                        valueBuilder.appendNull();
                        continue;
                    }
                    VarcharType.VARCHAR.writeSlice(valueBuilder, value);
                }
            });
        }
        return blockBuilder;
    }
}

