/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestRowBlock
extends AbstractTestBlock {
    @Test
    public void testWithVarcharBigint() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] testRows = this.generateTestRows((List<Type>)fieldTypes, 100);
        this.testWith((List<Type>)fieldTypes, testRows);
        this.testWith((List<Type>)fieldTypes, TestRowBlock.alternatingNullValues(testRows));
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        List<Object>[] expectedValues = TestRowBlock.alternatingNullValues(this.generateTestRows((List<Type>)fieldTypes, 100));
        Block block = this.createBlockBuilderWithValues((List<Type>)fieldTypes, expectedValues).build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = this.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    @Test
    public void testFromFieldBlocksNoNullsDetection() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock fieldBlock = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        boolean[] rowIsNull = new boolean[fieldBlock.getPositionCount()];
        Arrays.fill(rowIsNull, false);
        Assert.assertFalse((boolean)RowBlock.fromFieldBlocks((int)5, Optional.of(rowIsNull), (Block[])new Block[]{fieldBlock}).mayHaveNull());
        rowIsNull[rowIsNull.length - 1] = true;
        Assert.assertTrue((boolean)RowBlock.fromFieldBlocks((int)5, Optional.of(rowIsNull), (Block[])new Block[]{fieldBlock}).mayHaveNull());
        Assert.assertFalse((boolean)RowBlock.fromFieldBlocks((int)0, Optional.of(new boolean[0]), (Block[])new Block[]{emptyBlock}).mayHaveNull());
        ImmutableList fieldTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        Block hasNullsBlock = this.createBlockBuilderWithValues((List<Type>)fieldTypes, TestRowBlock.alternatingNullValues(this.generateTestRows((List<Type>)fieldTypes, 100))).build();
        Assert.assertTrue((boolean)hasNullsBlock.mayHaveNull());
    }

    private int getExpectedEstimatedDataSize(List<Object> row) {
        if (row == null) {
            return 0;
        }
        int size = 0;
        size += row.get(0) == null ? 0 : ((String)row.get(0)).length();
        return size += row.get(1) == null ? 0 : 8;
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactFieldBlock1 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        ByteArrayBlock compactFieldBlock2 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(5).getBytes());
        ByteArrayBlock incompactFieldBlock1 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(6).getBytes());
        ByteArrayBlock incompactFieldBlock2 = new ByteArrayBlock(5, Optional.empty(), TestRowBlock.createExpectedValue(6).getBytes());
        boolean[] rowIsNull = new boolean[]{false, true, false, false, false, false};
        TestRowBlock.assertCompact(RowBlock.fromFieldBlocks((int)0, Optional.empty(), (Block[])new Block[]{emptyBlock, emptyBlock}));
        TestRowBlock.assertCompact(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{compactFieldBlock1, compactFieldBlock2}));
        TestRowBlock.testIncompactBlock(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{incompactFieldBlock1, incompactFieldBlock2}));
        TestRowBlock.testIncompactBlock(RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])new Block[]{incompactFieldBlock1, incompactFieldBlock2}));
    }

    private void testWith(List<Type> fieldTypes, List<Object>[] expectedValues) {
        Block block = this.createBlockBuilderWithValues(fieldTypes, expectedValues).build();
        this.assertBlock(block, expectedValues);
        IntArrayList positionList = this.generatePositionList(expectedValues.length, expectedValues.length / 2);
        this.assertBlockFilteredPositions(expectedValues, block, positionList.toIntArray());
    }

    private BlockBuilder createBlockBuilderWithValues(List<Type> fieldTypes, List<Object>[] rows) {
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder(fieldTypes, null, 1);
        for (List<Object> row : rows) {
            if (row == null) {
                rowBlockBuilder.appendNull();
                continue;
            }
            rowBlockBuilder.buildEntry(fieldBuilders -> {
                for (int i = 0; i < row.size(); ++i) {
                    Object fieldValue = row.get(i);
                    if (fieldValue == null) {
                        ((BlockBuilder)fieldBuilders.get(i)).appendNull();
                        continue;
                    }
                    if (fieldValue instanceof Long) {
                        BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(i), ((Long)fieldValue).longValue());
                        continue;
                    }
                    if (fieldValue instanceof String) {
                        VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(i), Slices.utf8Slice((String)((String)fieldValue)));
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            });
        }
        return rowBlockBuilder;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue instanceof List) {
            this.assertValue(block, position, (List)expectedValue);
            return;
        }
        super.assertPositionValue(block, position, expectedValue);
    }

    private void assertValue(Block rowBlock, int position, List<?> row) {
        Objects.requireNonNull(row, "row is null");
        Assert.assertFalse((boolean)rowBlock.isNull(position));
        SqlRow sqlRow = (SqlRow)rowBlock.getObject(position, SqlRow.class);
        Assert.assertEquals((int)sqlRow.getFieldCount(), (int)row.size());
        int rawIndex = sqlRow.getRawIndex();
        for (int i = 0; i < row.size(); ++i) {
            Object fieldValue = row.get(i);
            Block rawFieldBlock = sqlRow.getRawFieldBlock(i);
            if (fieldValue == null) {
                Assert.assertTrue((boolean)rawFieldBlock.isNull(rawIndex));
                continue;
            }
            if (fieldValue instanceof Long) {
                Assert.assertEquals((long)BigintType.BIGINT.getLong(rawFieldBlock, rawIndex), (long)((Long)fieldValue));
                continue;
            }
            if (fieldValue instanceof String) {
                Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(rawFieldBlock, rawIndex), (Object)Slices.utf8Slice((String)((String)fieldValue)));
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private List<Object>[] generateTestRows(List<Type> fieldTypes, int numRows) {
        List[] testRows = new List[numRows];
        for (int i = 0; i < numRows; ++i) {
            ArrayList<Object> testRow = new ArrayList<Object>(fieldTypes.size());
            for (int j = 0; j < fieldTypes.size(); ++j) {
                int cellId = i * fieldTypes.size() + j;
                if (cellId % 7 == 3) {
                    testRow.add(null);
                    continue;
                }
                if (fieldTypes.get(j) == BigintType.BIGINT) {
                    testRow.add((long)i * 100L + (long)j);
                    continue;
                }
                if (fieldTypes.get(j) == VarcharType.VARCHAR) {
                    testRow.add(String.format("field(%s, %s)", i, j));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            testRows[i] = testRow;
        }
        return testRows;
    }

    private IntArrayList generatePositionList(int numRows, int numPositions) {
        IntArrayList positions = new IntArrayList(numPositions);
        for (int i = 0; i < numPositions; ++i) {
            positions.add((7 * i + 3) % numRows);
        }
        Collections.sort(positions);
        return positions;
    }
}

