/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.JoinStatsRule;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestJoinStatsRule
extends BaseStatsCalculatorTest {
    private static final String LEFT_JOIN_COLUMN = "left_join_column";
    private static final String LEFT_JOIN_COLUMN_2 = "left_join_column_2";
    private static final String RIGHT_JOIN_COLUMN = "right_join_column";
    private static final String RIGHT_JOIN_COLUMN_2 = "right_join_column_2";
    private static final String LEFT_OTHER_COLUMN = "left_column";
    private static final String RIGHT_OTHER_COLUMN = "right_column";
    private static final double LEFT_ROWS_COUNT = 500.0;
    private static final double RIGHT_ROWS_COUNT = 1000.0;
    private static final double TOTAL_ROWS_COUNT = 1500.0;
    private static final double LEFT_JOIN_COLUMN_NULLS = 0.3;
    private static final double LEFT_JOIN_COLUMN_2_NULLS = 0.4;
    private static final double LEFT_JOIN_COLUMN_NON_NULLS = 0.7;
    private static final double LEFT_JOIN_COLUMN_2_NON_NULLS = 0.6;
    private static final int LEFT_JOIN_COLUMN_NDV = 20;
    private static final int LEFT_JOIN_COLUMN_2_NDV = 50;
    private static final double RIGHT_JOIN_COLUMN_NULLS = 0.6;
    private static final double RIGHT_JOIN_COLUMN_2_NULLS = 0.8;
    private static final double RIGHT_JOIN_COLUMN_NON_NULLS = 0.4;
    private static final double RIGHT_JOIN_COLUMN_2_NON_NULLS = 0.19999999999999996;
    private static final int RIGHT_JOIN_COLUMN_NDV = 15;
    private static final int RIGHT_JOIN_COLUMN_2_NDV = 15;
    private static final SymbolStatistics LEFT_JOIN_COLUMN_STATS = TestJoinStatsRule.symbolStatistics("left_join_column", 0.0, 20.0, 0.3, 20.0);
    private static final SymbolStatistics LEFT_JOIN_COLUMN_2_STATS = TestJoinStatsRule.symbolStatistics("left_join_column_2", 0.0, 200.0, 0.4, 50.0);
    private static final SymbolStatistics LEFT_OTHER_COLUMN_STATS = TestJoinStatsRule.symbolStatistics("left_column", 42.0, 42.0, 0.42, 1.0);
    private static final SymbolStatistics RIGHT_JOIN_COLUMN_STATS = TestJoinStatsRule.symbolStatistics("right_join_column", 5.0, 20.0, 0.6, 15.0);
    private static final SymbolStatistics RIGHT_JOIN_COLUMN_2_STATS = TestJoinStatsRule.symbolStatistics("right_join_column_2", 100.0, 200.0, 0.8, 15.0);
    private static final SymbolStatistics RIGHT_OTHER_COLUMN_STATS = TestJoinStatsRule.symbolStatistics("right_column", 24.0, 24.0, 0.24, 1.0);
    private static final PlanNodeStatsEstimate LEFT_STATS = TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_OTHER_COLUMN_STATS);
    private static final PlanNodeStatsEstimate RIGHT_STATS = TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
    private static final StatsNormalizer NORMALIZER = new StatsNormalizer();
    private static final JoinStatsRule JOIN_STATS_RULE = new JoinStatsRule(new FilterStatsCalculator(TestingPlannerContext.PLANNER_CONTEXT, new ScalarStatsCalculator(TestingPlannerContext.PLANNER_CONTEXT, TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT)), NORMALIZER), NORMALIZER, 1.0);
    private static final TypeProvider TYPES = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("left_join_column"), (Object)BigintType.BIGINT).put((Object)new Symbol("left_join_column_2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("right_join_column"), (Object)BigintType.BIGINT).put((Object)new Symbol("right_join_column_2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("left_column"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("right_column"), (Object)BigintType.BIGINT).buildOrThrow());

    @Test
    public void testStatsForInnerJoin() {
        double innerJoinRowCount = 7000.0;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), LEFT_OTHER_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
        this.assertJoinStats(JoinNode.Type.INNER, LEFT_STATS, RIGHT_STATS, innerJoinStats);
    }

    @Test
    public void testStatsForInnerJoinWithRepeatedClause() {
        double clauseSelectivity = 0.013999999999999999;
        double innerJoinRowCount = 500000.0 * clauseSelectivity * Math.pow(clauseSelectivity, 0.5);
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), LEFT_OTHER_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
        this.tester().assertStatsFor(TestingSession.testSessionBuilder().setSystemProperty("join_multi_clause_independence_factor", "0.5").build(), pb -> {
            Symbol leftJoinColumnSymbol = pb.symbol(LEFT_JOIN_COLUMN, (Type)BigintType.BIGINT);
            Symbol rightJoinColumnSymbol = pb.symbol(RIGHT_JOIN_COLUMN, (Type)DoubleType.DOUBLE);
            Symbol leftOtherColumnSymbol = pb.symbol(LEFT_OTHER_COLUMN, (Type)BigintType.BIGINT);
            Symbol rightOtherColumnSymbol = pb.symbol(RIGHT_OTHER_COLUMN, (Type)DoubleType.DOUBLE);
            return pb.join(JoinNode.Type.INNER, (PlanNode)pb.values(leftJoinColumnSymbol, leftOtherColumnSymbol), (PlanNode)pb.values(rightJoinColumnSymbol, rightOtherColumnSymbol), new JoinNode.EquiJoinClause(leftJoinColumnSymbol, rightJoinColumnSymbol), new JoinNode.EquiJoinClause(leftJoinColumnSymbol, rightJoinColumnSymbol));
        }).withSourceStats(0, LEFT_STATS).withSourceStats(1, RIGHT_STATS).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testStatsForInnerJoinWithTwoEquiClauses() {
        double crossJoinRowCount = 500000.0;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(crossJoinRowCount, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0), TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0));
        Function<PlanBuilder, PlanNode> planProvider = pb -> {
            Symbol leftJoinColumnSymbol = pb.symbol(LEFT_JOIN_COLUMN, (Type)BigintType.BIGINT);
            Symbol rightJoinColumnSymbol = pb.symbol(RIGHT_JOIN_COLUMN, (Type)DoubleType.DOUBLE);
            Symbol leftJoinColumnSymbol2 = pb.symbol(LEFT_JOIN_COLUMN_2, (Type)BigintType.BIGINT);
            Symbol rightJoinColumnSymbol2 = pb.symbol(RIGHT_JOIN_COLUMN_2, (Type)DoubleType.DOUBLE);
            return pb.join(JoinNode.Type.INNER, (PlanNode)pb.values(leftJoinColumnSymbol, leftJoinColumnSymbol2), (PlanNode)pb.values(rightJoinColumnSymbol, rightJoinColumnSymbol2), new JoinNode.EquiJoinClause(leftJoinColumnSymbol2, rightJoinColumnSymbol2), new JoinNode.EquiJoinClause(leftJoinColumnSymbol, rightJoinColumnSymbol));
        };
        double firstClauseSelectivity = 0.0023999999999999994;
        this.tester().assertStatsFor(TestingSession.testSessionBuilder().setSystemProperty("join_multi_clause_independence_factor", "0").build(), planProvider).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats.mapOutputRowCount(rowCount -> rowCount * firstClauseSelectivity)));
        double secondClauseSelectivity = 0.013999999999999999;
        this.tester().assertStatsFor(TestingSession.testSessionBuilder().setSystemProperty("join_multi_clause_independence_factor", "1").build(), planProvider).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats.mapOutputRowCount(rowCount -> rowCount * firstClauseSelectivity * secondClauseSelectivity)));
        this.tester().assertStatsFor(TestingSession.testSessionBuilder().setSystemProperty("join_multi_clause_independence_factor", "0.5").build(), planProvider).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats.mapOutputRowCount(rowCount -> rowCount * firstClauseSelectivity * Math.pow(secondClauseSelectivity, 0.5))));
    }

    @Test
    public void testStatsForInnerJoinWithTwoEquiClausesAndNonEqualityFunction() {
        double firstClauseSelectivity = 0.0023999999999999994;
        double secondClauseSelectivity = 0.013999999999999999;
        double innerJoinRowCount = 500000.0 * firstClauseSelectivity * Math.pow(secondClauseSelectivity, 0.5) * 0.3333333333;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 5.0, 10.0, 0.0, 4.9999999995), TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0), TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0));
        this.tester().assertStatsFor(TestingSession.testSessionBuilder().setSystemProperty("join_multi_clause_independence_factor", "0.5").build(), pb -> {
            Symbol leftJoinColumnSymbol = pb.symbol(LEFT_JOIN_COLUMN, (Type)BigintType.BIGINT);
            Symbol rightJoinColumnSymbol = pb.symbol(RIGHT_JOIN_COLUMN, (Type)DoubleType.DOUBLE);
            Symbol leftJoinColumnSymbol2 = pb.symbol(LEFT_JOIN_COLUMN_2, (Type)BigintType.BIGINT);
            Symbol rightJoinColumnSymbol2 = pb.symbol(RIGHT_JOIN_COLUMN_2, (Type)DoubleType.DOUBLE);
            ComparisonExpression leftJoinColumnLessThanTen = new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)leftJoinColumnSymbol.toSymbolReference(), (Expression)new LongLiteral("10"));
            return pb.join(JoinNode.Type.INNER, (PlanNode)pb.values(leftJoinColumnSymbol, leftJoinColumnSymbol2), (PlanNode)pb.values(rightJoinColumnSymbol, rightJoinColumnSymbol2), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(leftJoinColumnSymbol2, rightJoinColumnSymbol2), (Object)new JoinNode.EquiJoinClause(leftJoinColumnSymbol, rightJoinColumnSymbol)), (List<Symbol>)ImmutableList.of((Object)leftJoinColumnSymbol, (Object)leftJoinColumnSymbol2), (List<Symbol>)ImmutableList.of((Object)rightJoinColumnSymbol, (Object)rightJoinColumnSymbol2), Optional.of(leftJoinColumnLessThanTen));
        }).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testJoinComplementStats() {
        PlanNodeStatsEstimate expected = TestJoinStatsRule.planNodeStats(237.5, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.631578947368421, 5.0), LEFT_OTHER_COLUMN_STATS);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol(LEFT_JOIN_COLUMN), new Symbol(RIGHT_JOIN_COLUMN))), LEFT_STATS, RIGHT_STATS, TYPES);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testRightJoinComplementStats() {
        PlanNodeStatsEstimate expected = NORMALIZER.normalize(TestJoinStatsRule.planNodeStats(600.0, TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN, Double.NaN, Double.NaN, 1.0, 0.0), RIGHT_OTHER_COLUMN_STATS), TYPES);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol(RIGHT_JOIN_COLUMN), new Symbol(LEFT_JOIN_COLUMN))), RIGHT_STATS, LEFT_STATS, TYPES);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testLeftJoinComplementStatsWithNoClauses() {
        PlanNodeStatsEstimate expected = NORMALIZER.normalize(LEFT_STATS.mapOutputRowCount(rowCount -> 0.0), TYPES);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of(), LEFT_STATS, RIGHT_STATS, TYPES);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testLeftJoinComplementStatsWithMultipleClauses() {
        PlanNodeStatsEstimate expected = TestJoinStatsRule.planNodeStats(237.5, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.631578947368421, 5.0), LEFT_OTHER_COLUMN_STATS).mapOutputRowCount(rowCount -> rowCount / 0.9);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol(LEFT_JOIN_COLUMN), new Symbol(RIGHT_JOIN_COLUMN)), (Object)new JoinNode.EquiJoinClause(new Symbol(LEFT_OTHER_COLUMN), new Symbol(RIGHT_OTHER_COLUMN))), LEFT_STATS, RIGHT_STATS, TYPES);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testStatsForLeftAndRightJoin() {
        double innerJoinRowCount = 7000.0;
        double joinComplementRowCount = 237.5;
        double joinComplementColumnNulls = 0.631578947368421;
        double totalRowCount = innerJoinRowCount + joinComplementRowCount;
        PlanNodeStatsEstimate leftJoinStats = TestJoinStatsRule.planNodeStats(totalRowCount, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, joinComplementColumnNulls * joinComplementRowCount / totalRowCount, 20.0), LEFT_OTHER_COLUMN_STATS, TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, joinComplementRowCount / totalRowCount, 15.0), TestJoinStatsRule.symbolStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, (0.24 * innerJoinRowCount + joinComplementRowCount) / totalRowCount, 1.0));
        this.assertJoinStats(JoinNode.Type.LEFT, LEFT_STATS, RIGHT_STATS, leftJoinStats);
        this.assertJoinStats(JoinNode.Type.RIGHT, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_STATS, LEFT_STATS, leftJoinStats);
    }

    @Test
    public void testLeftJoinMissingStats() {
        PlanNodeStatsEstimate leftStats = TestJoinStatsRule.planNodeStats(1.0, new SymbolStatistics(LEFT_JOIN_COLUMN, SymbolStatsEstimate.unknown()), new SymbolStatistics(LEFT_OTHER_COLUMN, SymbolStatsEstimate.unknown()));
        PlanNodeStatsEstimate rightStats = TestJoinStatsRule.planNodeStats(1.0, new SymbolStatistics(RIGHT_JOIN_COLUMN, SymbolStatsEstimate.unknown()), new SymbolStatistics(RIGHT_OTHER_COLUMN, SymbolStatsEstimate.unknown()));
        this.assertJoinStats(JoinNode.Type.LEFT, leftStats, rightStats, PlanNodeStatsEstimate.unknown());
    }

    @Test
    public void testStatsForFullJoin() {
        double innerJoinRowCount = 7000.0;
        double leftJoinComplementRowCount = 237.5;
        double leftJoinComplementColumnNulls = 0.631578947368421;
        double rightJoinComplementRowCount = 600.0;
        double rightJoinComplementColumnNulls = 1.0;
        double totalRowCount = innerJoinRowCount + leftJoinComplementRowCount + rightJoinComplementRowCount;
        PlanNodeStatsEstimate leftJoinStats = TestJoinStatsRule.planNodeStats(totalRowCount, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, (leftJoinComplementColumnNulls * leftJoinComplementRowCount + rightJoinComplementRowCount) / totalRowCount, 20.0), TestJoinStatsRule.symbolStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, (0.42 * (innerJoinRowCount + leftJoinComplementRowCount) + rightJoinComplementRowCount) / totalRowCount, 1.0), TestJoinStatsRule.symbolStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, (rightJoinComplementColumnNulls * rightJoinComplementRowCount + leftJoinComplementRowCount) / totalRowCount, 15.0), TestJoinStatsRule.symbolStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, (0.24 * (innerJoinRowCount + rightJoinComplementRowCount) + leftJoinComplementRowCount) / totalRowCount, 1.0));
        this.assertJoinStats(JoinNode.Type.FULL, LEFT_STATS, RIGHT_STATS, leftJoinStats);
    }

    @Test
    public void testAddJoinComplementStats() {
        double statsToAddNdv = 5.0;
        PlanNodeStatsEstimate statsToAdd = TestJoinStatsRule.planNodeStats(1000.0, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 0.0, 5.0, 0.2, statsToAddNdv));
        PlanNodeStatsEstimate addedStats = TestJoinStatsRule.planNodeStats(1500.0, TestJoinStatsRule.symbolStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.23333333333333334, 20.0), TestJoinStatsRule.symbolStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, 0.8066666666666666, 1.0));
        PlanNodeStatsAssertion.assertThat(JOIN_STATS_RULE.addJoinComplementStats(LEFT_STATS, LEFT_STATS, statsToAdd)).equalTo(addedStats);
    }

    @Test
    public void testUnknownInputStats() {
        this.assertJoinStats(JoinNode.Type.INNER, PlanNodeStatsEstimate.unknown(), RIGHT_STATS, PlanNodeStatsEstimate.unknown());
        this.assertJoinStats(JoinNode.Type.INNER, LEFT_STATS, PlanNodeStatsEstimate.unknown(), PlanNodeStatsEstimate.unknown());
        this.assertJoinStats(JoinNode.Type.INNER, PlanNodeStatsEstimate.unknown(), PlanNodeStatsEstimate.unknown(), PlanNodeStatsEstimate.unknown());
    }

    @Test
    public void testZeroInputStats() {
        PlanNodeStatsEstimate zeroLeftStats = TestJoinStatsRule.planNodeStats(0.0, new SymbolStatistics(LEFT_JOIN_COLUMN, SymbolStatsEstimate.zero()), new SymbolStatistics(LEFT_OTHER_COLUMN, SymbolStatsEstimate.zero()));
        PlanNodeStatsEstimate zeroRightStats = TestJoinStatsRule.planNodeStats(0.0, new SymbolStatistics(RIGHT_JOIN_COLUMN, SymbolStatsEstimate.zero()), new SymbolStatistics(RIGHT_OTHER_COLUMN, SymbolStatsEstimate.zero()));
        PlanNodeStatsEstimate zeroResultStats = TestJoinStatsRule.planNodeStats(0.0, new SymbolStatistics(LEFT_JOIN_COLUMN, SymbolStatsEstimate.zero()), new SymbolStatistics(LEFT_OTHER_COLUMN, SymbolStatsEstimate.zero()), new SymbolStatistics(RIGHT_JOIN_COLUMN, SymbolStatsEstimate.zero()), new SymbolStatistics(RIGHT_OTHER_COLUMN, SymbolStatsEstimate.zero()));
        this.assertJoinStats(JoinNode.Type.INNER, zeroLeftStats, RIGHT_STATS, zeroResultStats);
        this.assertJoinStats(JoinNode.Type.INNER, LEFT_STATS, zeroRightStats, zeroResultStats);
        this.assertJoinStats(JoinNode.Type.INNER, zeroLeftStats, zeroRightStats, zeroResultStats);
    }

    private void assertJoinStats(JoinNode.Type joinType, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats, PlanNodeStatsEstimate resultStats) {
        this.assertJoinStats(joinType, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, leftStats, rightStats, resultStats);
    }

    private void assertJoinStats(JoinNode.Type joinType, String leftJoinColumn, String leftOtherColumn, String rightJoinColumn, String rightOtherColumn, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats, PlanNodeStatsEstimate resultStats) {
        this.tester().assertStatsFor(pb -> {
            Symbol leftJoinColumnSymbol = pb.symbol(leftJoinColumn, (Type)BigintType.BIGINT);
            Symbol rightJoinColumnSymbol = pb.symbol(rightJoinColumn, (Type)DoubleType.DOUBLE);
            Symbol leftOtherColumnSymbol = pb.symbol(leftOtherColumn, (Type)BigintType.BIGINT);
            Symbol rightOtherColumnSymbol = pb.symbol(rightOtherColumn, (Type)DoubleType.DOUBLE);
            return pb.join(joinType, (PlanNode)pb.values(leftJoinColumnSymbol, leftOtherColumnSymbol), (PlanNode)pb.values(rightJoinColumnSymbol, rightOtherColumnSymbol), new JoinNode.EquiJoinClause(leftJoinColumnSymbol, rightJoinColumnSymbol));
        }).withSourceStats(0, leftStats).withSourceStats(1, rightStats).check((ComposableStatsCalculator.Rule<?>)JOIN_STATS_RULE, stats -> stats.equalTo(resultStats));
    }

    private static PlanNodeStatsEstimate planNodeStats(double rowCount, SymbolStatistics ... symbolStatistics) {
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount);
        for (SymbolStatistics symbolStatistic : symbolStatistics) {
            builder.addSymbolStatistics(symbolStatistic.symbol, symbolStatistic.estimate);
        }
        return builder.build();
    }

    private static SymbolStatistics symbolStatistics(String symbolName, double low, double high, double nullsFraction, double ndv) {
        return new SymbolStatistics(new Symbol(symbolName), SymbolStatsEstimate.builder().setLowValue(low).setHighValue(high).setNullsFraction(nullsFraction).setDistinctValuesCount(ndv).build());
    }

    private static class SymbolStatistics {
        final Symbol symbol;
        final SymbolStatsEstimate estimate;

        SymbolStatistics(String symbolName, SymbolStatsEstimate estimate) {
            this(new Symbol(symbolName), estimate);
        }

        SymbolStatistics(Symbol symbol, SymbolStatsEstimate estimate) {
            this.symbol = symbol;
            this.estimate = estimate;
        }
    }
}

