/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.AddColumnTask;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAddColumnTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testAddColumn() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"new_col"), (Type)IntegerType.INTEGER, Optional.empty(), false, false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT), new ColumnMetadata("new_col", (Type)IntegerType.INTEGER)});
    }

    @Test
    public void testAddColumnWithComment() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"new_col"), (Type)IntegerType.INTEGER, Optional.of("test comment"), false, false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT), ColumnMetadata.builder().setName("new_col").setType((Type)IntegerType.INTEGER).setComment(Optional.of("test comment")).build()});
    }

    @Test
    public void testAddColumnWithColumnProperty() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Property columnProperty = new Property(new Identifier("column_property"), (Expression)new LongLiteral("111"));
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"new_col"), (Type)IntegerType.INTEGER, (List<Property>)ImmutableList.of((Object)columnProperty), false, false));
        ColumnMetadata columnMetadata = (ColumnMetadata)this.metadata.getTableMetadata(this.testSession, table).getColumns().stream().filter(column -> column.getName().equals("new_col")).collect(MoreCollectors.onlyElement());
        Assertions.assertThat((Map)columnMetadata.getProperties()).containsExactly(new Map.Entry[]{Map.entry("column_property", 111L)});
    }

    @Test
    public void testAddColumnNotExistingTable() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testAddColumnNotExistingTableIfExists() {
        QualifiedName tableName = TestAddColumnTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeAddColumn(tableName, QualifiedName.of((String)"test"), (Type)IntegerType.INTEGER, Optional.empty(), true, false));
    }

    @Test
    public void testAddColumnNotExists() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"test"), (Type)IntegerType.INTEGER, Optional.empty(), false, true));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testAddColumnAlreadyExist() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_ALREADY_EXISTS}).hasMessage("Column 'test' already exists");
    }

    @Test
    public void testAddColumnOnView() {
        QualifiedObjectName viewName = TestAddColumnTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestAddColumnTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(viewName), QualifiedName.of((String)"test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testAddColumnOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestAddColumnTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(materializedViewName), QualifiedName.of((String)"test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{materializedViewName});
    }

    @Test
    public void testAddFieldWithNotExists() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)}))});
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a"}), (Type)IntegerType.INTEGER, false, true));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)}))});
    }

    @Test
    public void testAddFieldToNotExistingField() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("b"), (Type)IntegerType.INTEGER)}))), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"x", "c"}), (Type)IntegerType.INTEGER, false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("Field 'x' does not exist within row(a row(b integer))");
    }

    @Test
    public void testUnsupportedArrayTypeInRowField() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)new ArrayType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("element"), (Type)IntegerType.INTEGER)})))), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a", "c"}), (Type)IntegerType.INTEGER, false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("Unsupported type: array(row(element integer))");
    }

    @Test
    public void testUnsupportedMapTypeInRowField() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)new MapType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("key"), (Type)IntegerType.INTEGER)}), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("key"), (Type)IntegerType.INTEGER)}), new TypeOperators()))), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a", "c"}), (Type)IntegerType.INTEGER, false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("Unsupported type: map(row(key integer), row(key integer))");
    }

    @Test
    public void testUnsupportedAddDuplicatedField() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).orElseThrow();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)}))});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a"}), (Type)IntegerType.INTEGER, false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_ALREADY_EXISTS}).hasMessage("Field 'a' already exists");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"A"}), (Type)IntegerType.INTEGER, false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_ALREADY_EXISTS}).hasMessage("Field 'a' already exists");
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)BigintType.BIGINT)}))});
    }

    @Test
    public void testUnsupportedAddAmbiguousField() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.rowTable(tableName, new RowType.Field(Optional.of("a"), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("x"), (Type)IntegerType.INTEGER)})), new RowType.Field(Optional.of("A"), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("y"), (Type)IntegerType.INTEGER)}))), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("x"), (Type)IntegerType.INTEGER)})), new RowType.Field(Optional.of("A"), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("y"), (Type)IntegerType.INTEGER)}))}))});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), QualifiedName.of((String)"col", (String[])new String[]{"a", "z"}), (Type)IntegerType.INTEGER, false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("Field path [a, z] within row(a row(x integer), A row(y integer)) is ambiguous");
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("a"), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("x"), (Type)IntegerType.INTEGER)})), new RowType.Field(Optional.of("A"), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("y"), (Type)IntegerType.INTEGER)}))}))});
    }

    private ListenableFuture<Void> executeAddColumn(QualifiedName table, QualifiedName column, Type type, boolean tableExists, boolean columnNotExists) {
        return this.executeAddColumn(table, column, type, Optional.empty(), tableExists, columnNotExists);
    }

    private ListenableFuture<Void> executeAddColumn(QualifiedName table, QualifiedName column, Type type, Optional<String> comment, boolean tableExists, boolean columnNotExists) {
        ColumnDefinition columnDefinition = new ColumnDefinition(column, TypeSignatureTranslator.toSqlType((Type)type), true, (List)ImmutableList.of(), comment);
        return this.executeAddColumn(table, columnDefinition, tableExists, columnNotExists);
    }

    private ListenableFuture<Void> executeAddColumn(QualifiedName table, QualifiedName column, Type type, List<Property> properties, boolean tableExists, boolean columnNotExists) {
        ColumnDefinition columnDefinition = new ColumnDefinition(column, TypeSignatureTranslator.toSqlType((Type)type), true, properties, Optional.empty());
        return this.executeAddColumn(table, columnDefinition, tableExists, columnNotExists);
    }

    private ListenableFuture<Void> executeAddColumn(QualifiedName table, ColumnDefinition columnDefinition, boolean tableExists, boolean columnNotExists) {
        return new AddColumnTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager).execute(new AddColumn(table, columnDefinition, tableExists, columnNotExists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private static ConnectorTableMetadata rowTable(QualifiedObjectName tableName, RowType.Field ... fields) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("col", (Type)RowType.rowType((RowType.Field[])fields))));
    }
}

