/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.DropCatalogTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.Identifier;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestDropCatalogTask {
    private static final String TEST_CATALOG = "test_catalog";
    protected LocalQueryRunner queryRunner;

    @BeforeEach
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        this.queryRunner.registerCatalogFactory((ConnectorFactory)new TpchConnectorFactory());
    }

    @AfterEach
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
        this.queryRunner = null;
    }

    @Test
    public void testDuplicatedCreateCatalog() {
        this.queryRunner.createCatalog(TEST_CATALOG, "tpch", (Map)ImmutableMap.of());
        Assert.assertTrue((boolean)this.queryRunner.getMetadata().catalogExists(this.createNewQuery().getSession(), TEST_CATALOG));
        DropCatalogTask task = this.getCreateCatalogTask();
        DropCatalog statement = new DropCatalog(new Identifier(TEST_CATALOG), false, false);
        MoreFutures.getFutureValue((Future)task.execute(statement, this.createNewQuery(), Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)this.queryRunner.getMetadata().catalogExists(this.createNewQuery().getSession(), TEST_CATALOG));
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)task.execute(statement, this.createNewQuery(), Collections.emptyList(), WarningCollector.NOOP))).withMessage("Catalog '%s' does not exist", new Object[]{TEST_CATALOG});
    }

    @Test
    public void testDuplicatedCreateCatalogIfNotExists() {
        this.queryRunner.createCatalog(TEST_CATALOG, "tpch", (Map)ImmutableMap.of());
        Assert.assertTrue((boolean)this.queryRunner.getMetadata().catalogExists(this.createNewQuery().getSession(), TEST_CATALOG));
        DropCatalogTask task = this.getCreateCatalogTask();
        DropCatalog statement = new DropCatalog(new Identifier(TEST_CATALOG), true, false);
        MoreFutures.getFutureValue((Future)task.execute(statement, this.createNewQuery(), Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)this.queryRunner.getMetadata().catalogExists(this.createNewQuery().getSession(), TEST_CATALOG));
        MoreFutures.getFutureValue((Future)task.execute(statement, this.createNewQuery(), Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)this.queryRunner.getMetadata().catalogExists(this.createNewQuery().getSession(), TEST_CATALOG));
    }

    private DropCatalogTask getCreateCatalogTask() {
        return new DropCatalogTask(this.queryRunner.getCatalogManager(), (AccessControl)new AllowAllAccessControl());
    }

    private QueryStateMachine createNewQuery() {
        return QueryStateMachine.begin(Optional.empty(), (String)"test", Optional.empty(), (Session)TestingSession.testSession((Session)this.queryRunner.getDefaultSession()), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl(), (Executor)MoreExecutors.directExecutor(), (Metadata)this.queryRunner.getMetadata(), (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
    }
}

