/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.CreateSchemaTask;
import io.trino.execution.DropSchemaTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingHandles;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestDropSchemaTask
extends BaseDataDefinitionTaskTest {
    private static final CatalogSchemaName CATALOG_SCHEMA_NAME = new CatalogSchemaName("test-catalog", "test_db");

    @Test
    public void testDropSchemaRestrict() {
        CreateSchemaTask createSchemaTask = this.getCreateSchemaTask();
        CreateSchema createSchema = new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)createSchemaTask.execute(createSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
        DropSchemaTask dropSchemaTask = this.getDropSchemaTask();
        DropSchema dropSchema = new DropSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, false);
        MoreFutures.getFutureValue((Future)dropSchemaTask.execute(dropSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)dropSchemaTask.execute(dropSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("Schema 'test-catalog.test_db' does not exist");
    }

    @Test
    public void testDropNonEmptySchemaRestrict() {
        CreateSchemaTask createSchemaTask = this.getCreateSchemaTask();
        CreateSchema createSchema = new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)createSchemaTask.execute(createSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        DropSchemaTask dropSchemaTask = this.getDropSchemaTask();
        DropSchema dropSchema = new DropSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, false);
        QualifiedObjectName tableName = new QualifiedObjectName(CATALOG_SCHEMA_NAME.getCatalogName(), CATALOG_SCHEMA_NAME.getSchemaName(), "test_table");
        this.metadata.createTable(this.testSession, CATALOG_SCHEMA_NAME.getCatalogName(), TestDropSchemaTask.someTable(tableName), false);
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)dropSchemaTask.execute(dropSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("Cannot drop non-empty schema 'test_db'");
        Assert.assertTrue((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
    }

    @Test
    public void testDropSchemaIfExistsRestrict() {
        CatalogSchemaName schema = new CatalogSchemaName(CATALOG_SCHEMA_NAME.getCatalogName(), "test_if_exists_restrict");
        Assert.assertFalse((boolean)this.metadata.schemaExists(this.testSession, schema));
        DropSchemaTask dropSchemaTask = this.getDropSchemaTask();
        DropSchema dropSchema = new DropSchema(QualifiedName.of((String)"test_if_exists_restrict"), true, false);
        MoreFutures.getFutureValue((Future)dropSchemaTask.execute(dropSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
    }

    @Test
    public void testDropSchemaCascade() {
        CreateSchemaTask createSchemaTask = this.getCreateSchemaTask();
        CreateSchema createSchema = new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)createSchemaTask.execute(createSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
        DropSchemaTask dropSchemaTask = this.getDropSchemaTask();
        DropSchema dropSchema = new DropSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, true);
        MoreFutures.getFutureValue((Future)dropSchemaTask.execute(dropSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
    }

    @Test
    public void testDropNonEmptySchemaCascade() {
        CreateSchemaTask createSchemaTask = this.getCreateSchemaTask();
        CreateSchema createSchema = new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)createSchemaTask.execute(createSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        DropSchemaTask dropSchemaTask = this.getDropSchemaTask();
        DropSchema dropSchema = new DropSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, true);
        QualifiedObjectName tableName = new QualifiedObjectName(CATALOG_SCHEMA_NAME.getCatalogName(), CATALOG_SCHEMA_NAME.getSchemaName(), "test_table");
        this.metadata.createTable(this.testSession, CATALOG_SCHEMA_NAME.getCatalogName(), TestDropSchemaTask.someTable(tableName), false);
        MoreFutures.getFutureValue((Future)dropSchemaTask.execute(dropSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
    }

    @Test
    public void testDropSchemaIfExistsCascade() {
        CatalogSchemaName schema = new CatalogSchemaName(CATALOG_SCHEMA_NAME.getCatalogName(), "test_if_exists_cascade");
        Assert.assertFalse((boolean)this.metadata.schemaExists(this.testSession, schema));
        DropSchemaTask dropSchemaTask = this.getDropSchemaTask();
        DropSchema dropSchema = new DropSchema(QualifiedName.of((String)"test_if_exists_cascade"), true, false);
        MoreFutures.getFutureValue((Future)dropSchemaTask.execute(dropSchema, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
    }

    private CreateSchemaTask getCreateSchemaTask() {
        SchemaPropertyManager schemaPropertyManager = new SchemaPropertyManager(CatalogServiceProvider.singleton((CatalogHandle)TestingHandles.TEST_CATALOG_HANDLE, (Object)ImmutableMap.of()));
        return new CreateSchemaTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), schemaPropertyManager);
    }

    private DropSchemaTask getDropSchemaTask() {
        return new DropSchemaTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl());
    }
}

