/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.DropViewTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDropViewTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testDropExistingView() {
        QualifiedObjectName viewName = TestDropViewTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestDropViewTask.someView(), false);
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
        MoreFutures.getFutureValue(this.executeDropView(TestDropViewTask.asQualifiedName(viewName), false));
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isFalse();
    }

    @Test
    public void testDropNotExistingView() {
        QualifiedName viewName = TestDropViewTask.qualifiedName("not_existing_view");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropView(viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("View '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testDropNotExistingViewIfExists() {
        QualifiedName viewName = TestDropViewTask.qualifiedName("not_existing_view");
        MoreFutures.getFutureValue(this.executeDropView(viewName, true));
    }

    @Test
    public void testDropViewOnTable() {
        QualifiedObjectName tableName = TestDropViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropView(TestDropViewTask.asQualifiedName(tableName), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("View '%s' does not exist, but a table with that name exists. Did you mean DROP TABLE %s?", new Object[]{tableName, tableName});
    }

    @Test
    public void testDropViewOnTableIfExists() {
        QualifiedObjectName tableName = TestDropViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropView(TestDropViewTask.asQualifiedName(tableName), true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("View '%s' does not exist, but a table with that name exists. Did you mean DROP TABLE %s?", new Object[]{tableName, tableName});
    }

    @Test
    public void testDropViewOnMaterializedView() {
        QualifiedName viewName = TestDropViewTask.qualifiedName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropView(viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("View '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", new Object[]{viewName, viewName});
    }

    @Test
    public void testDropViewOnMaterializedViewIfExists() {
        QualifiedName viewName = TestDropViewTask.qualifiedName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropView(viewName, true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("View '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", new Object[]{viewName, viewName});
    }

    private ListenableFuture<Void> executeDropView(QualifiedName viewName, boolean exists) {
        return new DropViewTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(new DropView(viewName, exists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

